/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.safeguards;

import com.azul.crs.javaagent.client.safeguards.HardReferenceFactory;
import com.azul.crs.javaagent.client.safeguards.Reference;
import com.azul.crs.javaagent.client.safeguards.SafeReferenceFactory;
import com.azul.crs.javaagent.client.safeguards.ThrowingRunnable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;

public interface ReferenceFactory {
    public static ReferenceFactory getHardReferenceFactoryInstance() {
        return new HardReferenceFactory();
    }

    public static Function<Runnable, ReferenceFactory> getReferenceFactoryFactory(boolean safeguardsEnabled) {
        return safeguardsEnabled ? r -> new SafeReferenceFactory(true, (Runnable)r) : r -> ReferenceFactory.getHardReferenceFactoryInstance();
    }

    public String stats();

    public void onShutdown();

    public <T> Reference<T> createNewReference(T var1);

    public <T> BlockingQueue<T> createNewBlockingQueue(int var1);

    public <T> BlockingQueue<T> createNewBlockingQueue();

    public ThreadFactory createThreadFactory();

    public void oomSafeRun(Runnable var1);

    public <E extends Throwable> void oomSafeRunThrowing(ThrowingRunnable<E> var1) throws E;

    public void notifyWithException(Throwable var1);

    public void ensureIsAlive();

    public ThreadGroup getThreadGroup();
}

