/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.safeguards;

import com.azul.crs.javaagent.client.safeguards.InsufficientMemoryException;
import com.azul.crs.javaagent.client.safeguards.Reference;
import com.azul.crs.javaagent.client.safeguards.SafeReferenceFactory;
import com.azul.crs.javaagent.client.safeguards.ThrowingRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SafeBlockingQueue<T>
implements BlockingQueue<T> {
    private final SafeReferenceFactory referenceFactory;
    private final Reference<Map<T, Reference<T>>> weakMap;
    private final Reference<BlockingQueue<Reference<T>>> delegate;
    private AtomicBoolean oomThrown = new AtomicBoolean();

    public SafeBlockingQueue(SafeReferenceFactory referenceFactory) {
        this.referenceFactory = referenceFactory;
        this.delegate = referenceFactory.createNewReference(new LinkedBlockingDeque());
        this.weakMap = referenceFactory.createNewReference(Collections.synchronizedMap(new WeakHashMap()));
    }

    public SafeBlockingQueue(SafeReferenceFactory referenceFactory, int size) {
        this.referenceFactory = referenceFactory;
        this.delegate = referenceFactory.createNewReference(new LinkedBlockingDeque(size));
        this.weakMap = referenceFactory.createNewReference(Collections.synchronizedMap(new WeakHashMap()));
    }

    private <U, E extends Throwable> U throwOomOnce(ThrowingSupplier<U, E> supplier, U defaultValue) throws E {
        try {
            return supplier.supply();
        }
        catch (InsufficientMemoryException t) {
            if (this.oomThrown.compareAndSet(false, true)) {
                throw t;
            }
            return defaultValue;
        }
    }

    private <E extends Throwable> void throwOomAlways(ThrowingRunnable<E> runnable) throws E {
        try {
            runnable.run();
        }
        catch (InsufficientMemoryException t) {
            this.oomThrown.set(true);
            throw t;
        }
    }

    private <U, E extends Throwable> U throwOomAlways(ThrowingSupplier<U, E> supplier) throws E {
        try {
            return supplier.supply();
        }
        catch (InsufficientMemoryException t) {
            this.oomThrown.set(true);
            throw t;
        }
    }

    private Reference<T> newRef(T t) {
        Reference<T> ref = this.referenceFactory.createNewReference(t);
        this.weakMap.get().put(t, ref);
        return ref;
    }

    private T releaseRef(T t) {
        if (t != null) {
            this.weakMap.get().remove(t);
        }
        return t;
    }

    private Collection<?> getAllRefs(Collection<?> c) {
        return this.throwOomAlways(() -> c.stream().map(e -> this.weakMap.get().get(e)).collect(Collectors.toList()));
    }

    @Override
    public boolean add(T t) {
        return this.throwOomAlways(() -> this.delegate.get().add(this.newRef(t)));
    }

    @Override
    public boolean offer(T t) {
        return this.throwOomAlways(() -> this.delegate.get().offer(this.newRef(t)));
    }

    @Override
    public T remove() {
        return (T)this.throwOomAlways(() -> ((Reference)this.delegate.get().remove()).get());
    }

    @Override
    public T poll() {
        return (T)this.throwOomAlways(() -> this.releaseRef(((Reference)this.delegate.get().poll()).get()));
    }

    @Override
    public T element() {
        return (T)this.throwOomAlways(() -> ((Reference)this.delegate.get().element()).get());
    }

    @Override
    public T peek() {
        return (T)this.throwOomAlways(() -> this.releaseRef(((Reference)this.delegate.get().peek()).get()));
    }

    @Override
    public void put(T t) throws InterruptedException {
        this.throwOomAlways(() -> this.delegate.get().put(this.newRef(t)));
    }

    @Override
    public boolean offer(T t, long timeout, TimeUnit unit) throws InterruptedException {
        return this.throwOomAlways(() -> this.delegate.get().offer(this.newRef(t), timeout, unit));
    }

    @Override
    public T take() throws InterruptedException {
        return this.throwOomOnce(() -> this.releaseRef(this.delegate.get().take().get()), null);
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        Reference ref = this.throwOomOnce(() -> this.delegate.get().poll(timeout, unit), null);
        return ref == null ? null : this.throwOomOnce(() -> this.releaseRef(ref.get()), null);
    }

    @Override
    public int remainingCapacity() {
        return this.throwOomAlways(() -> this.delegate.get().remainingCapacity());
    }

    @Override
    public boolean remove(Object o) {
        Reference ref = this.throwOomAlways(() -> this.weakMap.get().get(o));
        boolean result = this.throwOomAlways(() -> this.delegate.get().remove(ref));
        if (result) {
            this.throwOomAlways(() -> this.releaseRef(o));
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.throwOomAlways(() -> this.delegate.get().containsAll(this.getAllRefs(c)));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean added = true;
        for (T t : c) {
            added &= this.add(t);
        }
        return added;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.throwOomAlways(() -> this.delegate.get().removeAll(this.getAllRefs(c)));
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.throwOomAlways(() -> this.delegate.get().removeIf((? super E e) -> filter.test((Object)e.get())));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.throwOomAlways(() -> this.delegate.get().retainAll(this.getAllRefs(c)));
    }

    @Override
    public void clear() {
        this.throwOomAlways(() -> this.delegate.get().clear());
    }

    @Override
    public Spliterator<T> spliterator() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Stream<T> stream() {
        return this.throwOomAlways(() -> this.delegate.get().stream().map(e -> e.get()));
    }

    @Override
    public Stream<T> parallelStream() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public int size() {
        return this.throwOomOnce(() -> this.delegate.get().size(), 0);
    }

    @Override
    public boolean isEmpty() {
        return this.throwOomOnce(() -> this.delegate.get().isEmpty(), true);
    }

    @Override
    public boolean contains(Object o) {
        return this.throwOomAlways(() -> this.delegate.get().contains(this.weakMap.get().get(o)));
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<Reference<T>> delegateIteragor;
            {
                this.delegateIteragor = (Iterator)SafeBlockingQueue.this.throwOomAlways(() -> ((BlockingQueue)SafeBlockingQueue.this.delegate.get()).iterator());
            }

            @Override
            public boolean hasNext() {
                return this.delegateIteragor.hasNext();
            }

            @Override
            public T next() {
                return SafeBlockingQueue.this.throwOomAlways(() -> this.delegateIteragor.next().get());
            }
        };
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.throwOomAlways(() -> this.delegate.get().forEach(e -> action.accept((Object)e.get())));
    }

    @Override
    public Object[] toArray() {
        return this.throwOomAlways(() -> this.delegate.get().stream().map(e -> e.get()).toArray());
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.throwOomAlways(() -> this.delegate.get().stream().map(e -> e.get()).toArray());
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        ArrayList list = new ArrayList();
        int result = this.throwOomAlways(() -> this.delegate.get().drainTo(list));
        c.addAll(this.throwOomAlways(() -> list.stream().map(e -> e.get()).collect(Collectors.toList())));
        return result;
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        ArrayList list = new ArrayList();
        int result = this.throwOomAlways(() -> this.delegate.get().drainTo(list, maxElements));
        c.addAll(this.throwOomAlways(() -> list.stream().map(e -> e.get()).collect(Collectors.toList())));
        return result;
    }

    private static interface ThrowingSupplier<U, E extends Throwable> {
        public U supply() throws E;
    }
}

