/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.safeguards;

import com.azul.crs.javaagent.client.safeguards.InsufficientMemoryException;
import com.azul.crs.javaagent.client.safeguards.Reference;
import com.azul.crs.javaagent.client.safeguards.SafeReferenceFactory;
import java.lang.ref.SoftReference;

public class SafeReference<T>
extends Reference<T> {
    private final SoftReference<T> objectReference;
    private final SafeReferenceFactory referenceFactory;

    SafeReference(T object, SafeReferenceFactory referenceFactory) {
        super(object);
        this.objectReference = new SoftReference<T>(object);
        this.referenceFactory = referenceFactory;
    }

    @Override
    T getInner() {
        return this.objectReference.get();
    }

    @Override
    public T get() {
        try {
            this.referenceFactory.ensureIsAlive();
        }
        catch (InsufficientMemoryException e) {
            SafeReferenceFactory.onTheFlyClearedReferences.incrementAndGet();
            this.release();
            SafeReferenceFactory.getOnReleasedObject.incrementAndGet();
            this.referenceFactory.onReferenceNotAliveCallback(this);
            throw e;
        }
        T object = this.getInner();
        if (object == null) {
            SafeReferenceFactory.getOnReleasedObject.incrementAndGet();
            this.referenceFactory.onReferenceNotAliveCallback(this);
            throw new InsufficientMemoryException(this.referenceFactory, "Object inaccessible", object, this.klass);
        }
        return object;
    }

    @Override
    void release() {
        this.objectReference.clear();
    }

    @Override
    boolean isReleased() {
        return this.getInner() != null;
    }
}

