/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.safeguards;

import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.safeguards.InsufficientMemoryException;
import com.azul.crs.javaagent.client.safeguards.NullReference;
import com.azul.crs.javaagent.client.safeguards.Reference;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.safeguards.SafeBlockingQueue;
import com.azul.crs.javaagent.client.safeguards.SafeProxySet;
import com.azul.crs.javaagent.client.safeguards.SafeReference;
import com.azul.crs.javaagent.client.safeguards.SafeThreadFactory;
import com.azul.crs.javaagent.client.safeguards.ThrowingRunnable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class SafeReferenceFactory
implements ReferenceFactory {
    private Set<Reference<?>> allAliveRefs = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private Set<Object> allAliveChildrenObjects = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final boolean DEBUG;
    private final Runnable callback;
    private final AtomicBoolean isAlive = new AtomicBoolean(true);
    private final int limitRefDump = 999999;
    private final ThreadGroup threadGroup;
    static AtomicInteger preemptivelyThrownInsufficientMemory = new AtomicInteger();
    static AtomicInteger getOnReleasedObject = new AtomicInteger();
    static AtomicInteger onTheFlyClearedReferences = new AtomicInteger();
    static AtomicInteger amountOfRegisteredOOMErrors = new AtomicInteger();
    static String onStartMemStats = SafeReferenceFactory.memStats();
    static String onFirstHitMemStats = SafeReferenceFactory.memStats();

    public SafeReferenceFactory(boolean enabled, Runnable callback) {
        this.callback = callback;
        this.DEBUG = Tweaks.DEBUG_SAFEGUARDS && enabled;
        this.threadGroup = new ThreadGroup("CRS-agent"){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                SafeReferenceFactory.this.notifyWithException(e);
            }
        };
    }

    private static String memStats() {
        return String.format("maxMemory=%d, freeMemory=%d, totalMemory=%d", Runtime.getRuntime().maxMemory(), Runtime.getRuntime().freeMemory(), Runtime.getRuntime().totalMemory());
    }

    @Override
    public String stats() {
        return String.format("onStartMemStats = { %s }, onFirstHitMemStats = { %s }, preemptivelyThrownInsufficientMemory=%d, getOnReleasedObject=%d, onTheFlyClearedReferences=%d, amountOfRegisteredOOMErrors=%d", onStartMemStats, onFirstHitMemStats, preemptivelyThrownInsufficientMemory.get(), getOnReleasedObject.get(), onTheFlyClearedReferences.get(), amountOfRegisteredOOMErrors.get());
    }

    @Override
    public void onShutdown() {
        if (this.DEBUG) {
            List nonNullRefs = new ArrayList(this.allAliveRefs).stream().filter(e -> !e.isReleased()).collect(Collectors.toList());
            boolean alive = this.isAlive.get();
            System.err.println(String.format("[CRS.memory][debug] agent terminating %s. Alive objects: non-null refs=%d, alive children objects=%d", alive ? "correctly" : "because of OOM", nonNullRefs.size(), this.allAliveChildrenObjects.size()));
            int i = 0;
            if (!alive && this.allAliveChildrenObjects.size() > 0) {
                for (Object t : new ArrayList<Object>(this.allAliveChildrenObjects)) {
                    String pretty = t == null ? null : String.format("%s@%x", t.getClass(), Objects.hashCode(t));
                    System.err.println("[CRS.memory][debug]: Alive child object: " + pretty);
                    if (i++ <= 999999) continue;
                    System.err.println("...");
                    break;
                }
            }
            i = 0;
            if (!alive && nonNullRefs.size() > 0) {
                for (Reference ref : nonNullRefs) {
                    System.err.println("[CRS.memory][debug]: Alive ref: " + ref);
                    if (i++ <= 999999) continue;
                    System.err.println("...");
                    break;
                }
            }
            System.err.println(String.format("Final stats: %s", this.stats()));
        }
    }

    @Override
    public <T> Reference<T> createNewReference(T object) {
        this.ensureIsAlive();
        this.trackChildren(object);
        if (object == null) {
            return new NullReference<T>(object);
        }
        SafeReference<T> newReference = null;
        newReference = new SafeReference<T>(object, this);
        if (this.DEBUG) {
            this.allAliveRefs.add(newReference);
        }
        return newReference;
    }

    @Override
    public <T> BlockingQueue<T> createNewBlockingQueue(int size) {
        this.ensureIsAlive();
        return new SafeBlockingQueue(this, size);
    }

    @Override
    public <T> BlockingQueue<T> createNewBlockingQueue() {
        this.ensureIsAlive();
        return new SafeBlockingQueue(this);
    }

    private <T> Set<T> createSafeProxySet(Set<T> set) {
        this.ensureIsAlive();
        return new SafeProxySet<T>(this, set);
    }

    private <K, V> SafeProxySet<K> createSafeProxySetFromMap(Map<K, Boolean> map) {
        this.ensureIsAlive();
        return new SafeProxySet<K>(this, Collections.newSetFromMap(map));
    }

    @Override
    public ThreadFactory createThreadFactory() {
        return new SafeThreadFactory(this);
    }

    @Override
    public void oomSafeRun(Runnable runnable) {
        this.ensureIsAlive();
        try {
            runnable.run();
        }
        catch (OutOfMemoryError oom) {
            this.isAlive.set(false);
            this.callback.run();
            throw new InsufficientMemoryException(this, "Memory allocation caused OOM: ", oom);
        }
    }

    @Override
    public <E extends Throwable> void oomSafeRunThrowing(ThrowingRunnable<E> runnable) throws E {
        this.ensureIsAlive();
        try {
            runnable.run();
        }
        catch (OutOfMemoryError oom) {
            this.isAlive.set(false);
            this.callback.run();
            throw new InsufficientMemoryException(this, "Memory allocation caused OOM: ", oom);
        }
    }

    @Override
    public void notifyWithException(Throwable t) {
        if (t != null && OutOfMemoryError.class.isAssignableFrom(t.getClass())) {
            amountOfRegisteredOOMErrors.incrementAndGet();
            this.isAlive.set(false);
        }
    }

    private Set<Object> children(Object object) {
        if (!this.DEBUG) {
            throw new RuntimeException("should not reach here");
        }
        if (object == null) {
            return Collections.emptySet();
        }
        HashSet<Object> children = new HashSet<Object>();
        for (Field f : object.getClass().getFields()) {
            try {
                f.setAccessible(true);
                children.add(f.get(object));
            }
            catch (Exception e) {
                System.err.println("Failed to access field: " + f + ", of the object: " + object);
                e.printStackTrace();
            }
        }
        return children;
    }

    private void trackChildren(Object object) {
        if (this.DEBUG) {
            this.allAliveChildrenObjects.add(object);
            this.allAliveChildrenObjects.addAll(this.children(object));
        }
    }

    void release(Reference<?> ref) {
        if (this.DEBUG) {
            this.allAliveRefs.remove(ref);
        }
    }

    @Override
    public void ensureIsAlive() {
        if (!this.isAlive.get()) {
            preemptivelyThrownInsufficientMemory.incrementAndGet();
            throw new InsufficientMemoryException(this, "Memory allocation previously caused OOM");
        }
    }

    void onReferenceNotAliveCallback(Reference<?> missedObject) {
        onFirstHitMemStats = SafeReferenceFactory.memStats();
        this.isAlive.set(false);
        this.release(missedObject);
        this.callback.run();
    }

    public <T extends Throwable> void rethrowIfFirst(T t) throws T {
        if (this.isAlive.compareAndSet(false, true)) {
            this.callback.run();
            throw t;
        }
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }
}

