/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.safeguards;

import com.azul.crs.javaagent.client.safeguards.SafeReferenceFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class SafeThreadFactory
implements ThreadFactory {
    private final SafeReferenceFactory safeReferenceFactory;
    private static AtomicInteger counter = new AtomicInteger();

    public SafeThreadFactory(SafeReferenceFactory safeReferenceFactory) {
        this.safeReferenceFactory = safeReferenceFactory;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        this.safeReferenceFactory.ensureIsAlive();
        Thread t = new Thread(this.safeReferenceFactory.getThreadGroup(), runnable);
        t.setDaemon(true);
        t.setName(String.format("CRS-ES-%3d", counter.incrementAndGet()));
        return t;
    }
}

