/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.service;

import com.azul.crs.javaagent.client.Inventory;
import com.azul.crs.javaagent.client.Options;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.eventconsumer.VmEventConsumer;
import com.azul.crs.javaagent.client.models.VMArtifact;
import com.azul.crs.javaagent.client.service.ClientService;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class CRSLogService
implements ClientService {
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private static final String OVERFLOW_WARNING = "... [truncated] ...";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final AtomicReference<ByteBuffer> bufferRef;
    private final AtomicBoolean overflow = new AtomicBoolean(false);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final AtomicInteger artifactID = new AtomicInteger(0);
    private final AtomicReference<VmEventConsumer> eventConsumerRef = new AtomicReference();

    public CRSLogService() {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        buffer.limit(4096 - OVERFLOW_WARNING.length());
        this.bufferRef = new AtomicReference<ByteBuffer>(buffer);
    }

    public void setEventConsumer(VmEventConsumer eventConsumer) {
        if (!this.eventConsumerRef.compareAndSet(null, eventConsumer)) {
            throw new IllegalStateException(this.serviceName() + " client is defined already");
        }
    }

    @Override
    public void start() {
        if (!Options.sendCRSLogs.isYes()) {
            return;
        }
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException(this.serviceName() + " is running already");
        }
        VmEventConsumer eventConsumer = this.eventConsumerRef.get();
        if (eventConsumer == null) {
            throw new IllegalStateException(this.serviceName() + " starting without client defined");
        }
        int id = eventConsumer.createArtifactId();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("name", "crs.log");
        metadata.put("tags", Inventory.instanceTags());
        eventConsumer.consumeVMArtifactCreate(VMArtifact.Type.CRS_LOG, id, metadata);
        if (!this.artifactID.compareAndSet(0, id)) {
            throw new IllegalStateException(this.serviceName() + " artifactID is set already");
        }
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.stopped.set(true);
    }

    @Override
    public void terminate() {
        this.stopped.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCRSLogEntry(byte[] buf, int offset, int len) {
        block11: {
            if (!Options.sendCRSLogs.isYes()) {
                return;
            }
            try {
                if (this.stopped.get()) {
                    return;
                }
                int id = this.artifactID.get();
                ByteBuffer buffer = this.bufferRef.get();
                if (id == 0) {
                    if (this.overflow.get()) break block11;
                    AtomicBoolean atomicBoolean = this.overflow;
                    synchronized (atomicBoolean) {
                        if (!this.overflow.get() && buffer.remaining() > len) {
                            buffer.put(buf, offset, len);
                        } else {
                            buffer.limit(buffer.capacity());
                            buffer.put(OVERFLOW_WARNING.getBytes());
                            this.overflow.set(true);
                        }
                        break block11;
                    }
                }
                VmEventConsumer eventConsumer = this.eventConsumerRef.get();
                if (buffer != null && this.bufferRef.compareAndSet(buffer, null)) {
                    eventConsumer.consumeVMArtifactData(id, new String(buffer.array(), 0, buffer.position(), CHARSET));
                }
                eventConsumer.consumeVMArtifactData(id, new String(buf, offset, len, CHARSET));
            }
            catch (Throwable t) {
                t.printStackTrace(System.out);
            }
        }
    }
}

