/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.service;

import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.eventconsumer.VmEventConsumer;
import com.azul.crs.javaagent.client.featureflags.FeatureFlagsConfiguration;
import com.azul.crs.javaagent.client.filter.FiltersFactory;
import com.azul.crs.javaagent.client.filter.PrefixFilter;
import com.azul.crs.javaagent.client.models.VMEvent;
import com.azul.crs.javaagent.client.service.ClassLoadInterface;
import com.azul.crs.javaagent.util.logging.Logger;
import java.util.HashMap;

public class ClassLoadMonitor
implements ClassLoadInterface {
    private static final Logger logger = Logger.getLogger(ClassLoadMonitor.class);
    private final VmEventConsumer eventConsumer;
    private final PrefixFilter filter = FiltersFactory.getClassLoadFilter();

    public ClassLoadMonitor(VmEventConsumer eventConsumer) {
        this.eventConsumer = eventConsumer;
    }

    private VMEvent classLoadEvent(String className, String originalHashString, String hashString, int classId, int loaderId, String source, int firstCallPatchingResult, long eventTime) {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("className", className);
        if (originalHashString != null) {
            payload.put("transformedHash", hashString);
        }
        payload.put("hash", originalHashString != null ? originalHashString : hashString);
        payload.put("classId", Integer.toString(classId));
        payload.put("loaderId", Integer.toString(loaderId));
        if (source != null) {
            payload.put("source", source);
        }
        if (FeatureFlagsConfiguration.notifyFirstCall()) {
            payload.put("firstCallPatchingResult", Integer.toString(firstCallPatchingResult));
        }
        return new VMEvent().eventType(VMEvent.Type.VM_CLASS_LOADED).eventTime(eventTime).eventPayload(payload);
    }

    @Override
    public void notifyClassLoad(String className, byte[] originalHash, byte[] hash, int classId, int loaderId, String source, int firstCallPatchingResult) {
        if (!FeatureFlagsConfiguration.notifyClassLoad()) {
            return;
        }
        if (this.filter.match(className)) {
            logger.trace("filer out the class=%s", className);
            return;
        }
        long eventTime = Utils.currentTimeMillis();
        String originalHashString = Utils.encodeToStringOrNull(originalHash);
        String hashString = Utils.encodeToStringOrNull(hash);
        this.eventConsumer.consumeVMEvent(this.classLoadEvent(className, originalHashString, hashString, classId, loaderId, source, firstCallPatchingResult, eventTime));
    }

    @Override
    public void notifyClassLoad(String className, byte[] originalHash, byte[] hash, int classId, int loaderId, String source) {
        this.notifyClassLoad(className, originalHash, hash, classId, loaderId, source, 0);
    }
}

