/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.service;

import com.azul.crs.javaagent.client.Client;
import com.azul.crs.javaagent.client.InterfaceConnectionManager;
import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.featureflags.FeatureFlagsConfiguration;
import com.azul.crs.javaagent.client.models.VMEvent;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.service.ClientService;
import com.azul.crs.javaagent.client.service.QueueService;
import com.azul.crs.javaagent.util.logging.Logger;
import com.azul.crs.javaagent.util.logging.LoggingHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class EventService
implements ClientService {
    private final Client client;
    private final QueueService<VMEvent> queue;
    private volatile boolean fullyStarted = false;
    private VMEvent vmStart = null;
    private List<VMEvent> eventsToBeSentSynchronously = new ArrayList<VMEvent>();

    private EventService(Client client, ReferenceFactory referenceFactory) {
        this.client = client;
        this.queue = new QueueService.Builder().maxQueueSize(Tweaks.MAX_QUEUE_SIZE).maxBatchSize(Tweaks.BATCH_SIZE).maxWorkers(Tweaks.MAX_WORKERS).postBatch(this::postWithRetries).filter(this::filter).cancelBatch(this::discard).name("EVENT").referenceFactory(referenceFactory).build();
    }

    private boolean filter(VMEvent vmEvent) {
        if (FeatureFlagsConfiguration.isEnabled(vmEvent.getEventType())) {
            return true;
        }
        vmEvent.getEventType().subtractInFlightEventsCount(1);
        vmEvent.callOnError();
        return false;
    }

    public static EventService getInstance(Client client, ReferenceFactory referenceFactory) {
        return new EventService(client, referenceFactory);
    }

    public void add(VMEvent event) {
        VMEvent.Type eventType = event.getEventType();
        int count = eventType.incrementInFlightEventsCount();
        boolean added = this.queue.add(event);
        if (!added) {
            count = eventType.subtractInFlightEventsCount(1);
            event.callOnError();
        }
        if (Tweaks.DEBUG_EVENT_SERVICE) {
            this.logger().trace("Queue %s: Event of type %s %s added. [InFlightEventsCount=%d]", new Object[]{this.queue.serviceName(), eventType, added ? "was" : "was not", count});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSynchronously(VMEvent event) {
        if (this.vmStart == null) {
            throw new RuntimeException("Too early... vmCreate should be scheduled!");
        }
        if (this.fullyStarted) {
            this.queue.skipOverQueue(event);
        } else {
            EventService eventService = this;
            synchronized (eventService) {
                if (this.fullyStarted) {
                    this.queue.skipOverQueue(event);
                } else {
                    this.eventsToBeSentSynchronously.add(event);
                }
            }
        }
    }

    public void addVmStart(VMEvent event) {
        VMEvent.Type eventType = event.getEventType();
        if (eventType != VMEvent.Type.VM_CREATE) {
            throw new RuntimeException("addVmStart - incorrect event type: " + (Object)((Object)event.getEventType()));
        }
        if (this.fullyStarted) {
            throw new RuntimeException("addVmStart - must be called before the queue is started");
        }
        if (this.vmStart != null) {
            throw new RuntimeException("addVmStart - can not be called twice");
        }
        eventType.incrementInFlightEventsCount();
        this.vmStart = event;
    }

    public void addAll(Collection<VMEvent> events) {
        events.forEach(this::add);
    }

    @Override
    public String serviceName() {
        return "client.service.Events";
    }

    @Override
    public void start() {
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.queue.stop(deadline);
    }

    @Override
    public void terminate() {
        this.cancel();
    }

    public void cancel() {
        this.queue.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionEstablished() {
        if (this.vmStart != null) {
            this.queue.skipOverQueue(this.vmStart);
        }
        this.sendAllSynchronousEvents();
        this.queue.start();
        EventService eventService = this;
        synchronized (eventService) {
            this.fullyStarted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllSynchronousEvents() {
        if (this.vmStart == null) {
            throw new RuntimeException("Too early... vmCreate should be scheduled!");
        }
        EventService eventService = this;
        synchronized (eventService) {
            for (VMEvent e : this.eventsToBeSentSynchronously) {
                this.queue.skipOverQueue(e);
            }
            this.eventsToBeSentSynchronously.clear();
        }
    }

    private void callSafe(VMEvent e, boolean succeed) {
        try {
            if (Tweaks.DEBUG_EVENT_SERVICE) {
                System.out.println(">>> call on succeed=" + succeed + ", e=" + e);
            }
            if (succeed) {
                e.callOnSuccess();
            } else {
                e.callOnError();
            }
        }
        catch (Throwable t) {
            LoggingHelper.logUnhandledException(this.logger(), Logger.Level.ERROR, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postWithRetries(String workerId, Collection<VMEvent> batch) {
        this.logger().trace("event worker tries to post batch of %,d VM events", batch.size());
        boolean succeed = false;
        try {
            InterfaceConnectionManager cm = this.client.getConnectionManager();
            succeed = cm.requestWithRetries(() -> cm.sendVMEventBatch(batch), "postEventBatch", Tweaks.EVENT_MAX_RETRIES, Tweaks.EVENT_RETRY_SLEEP);
        }
        finally {
            batch.stream().collect(Collectors.groupingBy(e -> e.getEventType(), Collectors.counting())).forEach((t, c) -> t.subtractInFlightEventsCount(c.intValue()));
            boolean finalSucceed = succeed;
            batch.forEach(e -> this.callSafe((VMEvent)e, finalSucceed));
        }
    }

    private void discard(String workerId, Collection<VMEvent> batch) {
        batch.forEach(e -> this.callSafe((VMEvent)e, false));
    }
}

