/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.service;

import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.eventconsumer.VmEventConsumer;
import com.azul.crs.javaagent.client.models.VMEvent;
import com.azul.crs.javaagent.client.service.FirstCallInterface;
import com.azul.crs.javaagent.util.logging.Logger;
import java.util.HashMap;

public class FirstCallMonitor
implements FirstCallInterface {
    private final VmEventConsumer eventConsumer;

    public FirstCallMonitor(VmEventConsumer eventConsumer) {
        this.eventConsumer = eventConsumer;
    }

    private static VMEvent methodEntryEvent(int classId, String methodName, long eventTime) {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("classId", Integer.toString(classId));
        payload.put("methodName", methodName);
        return new VMEvent().eventType(VMEvent.Type.VM_METHOD_FIRST_CALLED).eventTime(eventTime).eventPayload(payload);
    }

    @Override
    public void notifyMethodFirstCalled(int classId, String methodName) {
        Logger.getLogger(FirstCallMonitor.class).trace("Entered " + methodName, new Object[0]);
        long eventTime = Utils.currentTimeMillis();
        this.eventConsumer.consumeVMEvent(FirstCallMonitor.methodEntryEvent(classId, methodName, eventTime));
    }
}

