/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.service;

import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.eventconsumer.VmEventConsumer;
import com.azul.crs.javaagent.client.models.VMEvent;
import com.azul.crs.javaagent.client.safeguards.InsufficientMemoryException;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.service.ClientService;
import java.util.concurrent.TimeUnit;

public class HeartbeatService
implements ClientService {
    private static final long HEARTBEAT_SLEEP = 60000L;
    private static final int HEARTBEAT_LOG_COUNT = 300;
    private static final long HEARTBEAT_STOP = 60000L;
    private static final HeartbeatService instance = new HeartbeatService();
    private VmEventConsumer vmEventConsumer;
    private ReferenceFactory referenceFactory;
    private Thread thread;
    private volatile boolean running;

    private HeartbeatService() {
    }

    public static HeartbeatService getInstance(ReferenceFactory referenceFactory, VmEventConsumer vmEventConsumer) {
        HeartbeatService.instance.vmEventConsumer = vmEventConsumer;
        HeartbeatService.instance.referenceFactory = referenceFactory;
        return instance;
    }

    private void run() {
        long heartbeatCount = 0L;
        while (this.running) {
            try {
                Thread.sleep(60000L);
                long lastHeardTime = Utils.currentTimeMillis();
                this.vmEventConsumer.consumeVMEvent(new VMEvent().randomEventId().eventType(VMEvent.Type.VM_HEARTBEAT).eventTime(lastHeardTime));
                if (++heartbeatCount % 300L != 0L) continue;
                this.logger().info("CRS client heartbeats: lastHeardTime=%s, count=%,d\n", lastHeardTime, heartbeatCount);
            }
            catch (InsufficientMemoryException | OutOfMemoryError ex) {
                throw ex;
            }
            catch (InterruptedException ex) {
            }
            catch (Throwable th) {
                this.logger().error("Internal error or unexpected problem. CRS defunct. %s", th);
            }
        }
    }

    @Override
    public synchronized void start() {
        this.logger().trace("start", new Object[0]);
        if (!Tweaks.HEARTBEAT_ENABLE) {
            return;
        }
        if (this.running) {
            throw new IllegalStateException(this.serviceName() + " is running already");
        }
        this.thread = new Thread(this.referenceFactory.getThreadGroup(), this::run);
        this.thread.setDaemon(true);
        this.thread.setName("CRSHeartbeat");
        this.running = true;
        this.thread.start();
    }

    @Override
    public synchronized void stop(Utils.Deadline deadline) {
        this.logger().trace("stop", new Object[0]);
        if (!this.running) {
            return;
        }
        try {
            this.running = false;
            this.thread.interrupt();
            this.thread.join(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void terminate() {
        this.stop(Utils.Deadline.in(0L, TimeUnit.MILLISECONDS));
    }
}

