/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.service;

import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.classLoad.ClassLoaderWrapper;
import com.azul.crs.javaagent.client.service.JarLoadReporterInterface;
import com.azul.crs.javaagent.client.service.JarLoadService;
import com.azul.crs.javaagent.client.util.LRUCache;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

public class JarLoadReporter
implements JarLoadReporterInterface {
    private boolean unexpectedExceptionNotSent = true;
    private final JarLoadService jarLoadService;
    private static final Logger logger = Logger.getLogger(JarLoadReporter.class);
    private final LRUCache<ClassLoaderWrapper> knownLoaders = new LRUCache(Tweaks.dedupSize);

    public JarLoadReporter(JarLoadService jarLoadService) {
        this.jarLoadService = jarLoadService;
    }

    private void handleWrapper(ClassLoaderWrapper clw) throws IOException, URISyntaxException {
        if (clw.isHandled) {
            logger.trace("Skipping already handled CLW: " + clw, new Object[0]);
            return;
        }
        URL[] urls = clw.getURLs();
        if (urls == null) {
            logger.trace("ClassLoadWrapper.getURLs returned null", new Object[0]);
        } else if (clw.getURLs().length == 0) {
            logger.trace("ClassLoadWrapper.getURLs returned empty array", new Object[0]);
        } else {
            for (URL url : urls) {
                logger.trace("Handling JAR for URL: %s", url);
                this.jarLoadService.notifyJarLoad(url);
            }
        }
        clw.isHandled = true;
    }

    @Override
    public void notifyWith(String source, ClassLoaderWrapper classLoaderWrapper) {
        this.jarLoadService.notifyClassSourceSeen(source);
        this.add(classLoaderWrapper);
    }

    private synchronized void add(ClassLoaderWrapper classLoaderWrapper) {
        if (Tweaks.enableJarsFromClassLoaders && !this.knownLoaders.contains(classLoaderWrapper)) {
            this.knownLoaders.put(classLoaderWrapper);
            try {
                this.handleWrapper(classLoaderWrapper);
            }
            catch (IOException | URISyntaxException e) {
                if (this.unexpectedExceptionNotSent) {
                    logger.error("Unexpected exception during CLW handling: " + e, new Object[0]);
                    this.unexpectedExceptionNotSent = false;
                } else {
                    logger.debug("Unexpected exception during CLW handling: " + e, new Object[0]);
                }
                classLoaderWrapper.isHandled = true;
            }
        }
    }
}

