/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.service;

import com.azul.crs.javaagent.client.Options;
import com.azul.crs.javaagent.client.PerformanceMetrics;
import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.eventconsumer.VmEventConsumer;
import com.azul.crs.javaagent.client.featureflags.FeatureFlagsConfiguration;
import com.azul.crs.javaagent.client.jars.ClassPathToSource;
import com.azul.crs.javaagent.client.jars.CountdownRunnable;
import com.azul.crs.javaagent.client.jars.JarAccess;
import com.azul.crs.javaagent.client.jars.JarAccessFactory;
import com.azul.crs.javaagent.client.jars.JarSource;
import com.azul.crs.javaagent.client.jars.SourceCache;
import com.azul.crs.javaagent.client.jars.VMEventHelper;
import com.azul.crs.javaagent.client.jars.VmJarInfoRequestSupport;
import com.azul.crs.javaagent.client.jars.tracker.JarDetailsEnum;
import com.azul.crs.javaagent.client.jars.tracker.JarTrackerEnum;
import com.azul.crs.javaagent.client.models.VMEvent;
import com.azul.crs.javaagent.client.safeguards.Reference;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.service.InsufficientTempfsLimitException;
import com.azul.crs.javaagent.client.service.JarDetailsRequestMonitor;
import com.azul.crs.javaagent.client.service.MonitorService;
import com.azul.crs.javaagent.client.service.MonitorServiceException;
import com.azul.crs.javaagent.client.service.TempFilesMonitor;
import com.azul.crs.javaagent.client.util.LRU;
import com.azul.crs.javaagent.client.util.LRUCache;
import com.azul.crs.javaagent.client.util.MyAtomicLongDebuggable;
import com.azul.crs.javaagent.client.util.MySetDebuggable;
import com.azul.crs.javaagent.client.util.Utils;
import com.azul.crs.javaagent.client.util.async.AsyncPipeline;
import com.azul.crs.javaagent.client.util.async.AsyncResourceHandler;
import com.azul.crs.javaagent.jar.ZipTools;
import com.azul.crs.javaagent.runtime.utils.TempFilesFactory;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.jar.JarFile;

public final class JarLoadService
extends MonitorService {
    private VmEventConsumer eventConsumer;
    private ReferenceFactory referenceFactory;
    private final AtomicBoolean started = new AtomicBoolean();
    private final ExecutorService executorService;
    private final BlockingQueue<Runnable> executorServiceQueue;
    private volatile Utils.Deadline deadline;
    private volatile boolean terminated = false;
    private final Logger logger = Logger.getLogger(this.getClass());
    private final JarAccessFactory jarAccessFactory;
    private final TempFilesMonitor tempFilesMonitor;
    private final JarDetailsRequestMonitor jarDetailsRequestMonitor;
    private final SourceCache sourceCache;
    private final AtomicLong tasksInProgressCounter = new AtomicLong();
    private final AtomicLong tasksCompletedCounter = new AtomicLong();
    private final AtomicLong jarFilesCanceledDueToTempfsLimit = new AtomicLong();
    private final AtomicLong jarFilesCanceledTotal = new AtomicLong();
    private final AtomicLong unhandledExceptions = new AtomicLong();
    private final Reference<Set<JarAccess>> jarsInProgress;
    private final Reference<MySetDebuggable<Object>> eventsProcessingInProgress;
    private final Reference<MyAtomicLongDebuggable> eventsSendingInProgress;
    private boolean unhandledExceptionNotSent = true;
    private static volatile JarLoadService instance;

    private JarLoadService(VmEventConsumer eventConsumer, final ReferenceFactory referenceFactory) {
        this.eventConsumer = eventConsumer;
        this.referenceFactory = referenceFactory;
        this.eventsProcessingInProgress = referenceFactory.createNewReference(new MySetDebuggable("eventsProcessingInProgress"));
        this.eventsSendingInProgress = referenceFactory.createNewReference(new MyAtomicLongDebuggable("eventsSendingInProgress"));
        this.jarsInProgress = referenceFactory.createNewReference(ConcurrentHashMap.newKeySet());
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("Failed to initialize SHA-256 MessageDigest: %s", e);
            this.stop(Utils.Deadline.in(0L, TimeUnit.MILLISECONDS));
        }
        this.sourceCache = new SourceCache(referenceFactory, Tweaks.jarCacheSize);
        this.jarAccessFactory = new JarAccessFactory(referenceFactory, Tweaks.jarCacheSize, ZipTools.createDefault(), digest);
        this.executorServiceQueue = referenceFactory.createNewBlockingQueue();
        this.executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.executorServiceQueue, referenceFactory.createThreadFactory()){

            @Override
            public Future<?> submit(Runnable r) {
                if (JarLoadService.this.executorServiceQueue.size() > Tweaks.jarLoadMonitorTaskQueueSize) {
                    throw new RuntimeException("TaskQueue size limit has been reached: " + Tweaks.jarLoadMonitorTaskQueueSize);
                }
                referenceFactory.ensureIsAlive();
                JarLoadService.this.tasksInProgressCounter.incrementAndGet();
                return super.submit(() -> {
                    try {
                        referenceFactory.oomSafeRun(r);
                    }
                    catch (Throwable e) {
                        JarLoadService.this.unhandledExceptions.incrementAndGet();
                        if (JarLoadService.this.unhandledExceptionNotSent) {
                            JarLoadService.this.logger.error("Exception while processing JarLoadMonitor task: %s", e);
                            JarLoadService.this.unhandledExceptionNotSent = false;
                        } else {
                            JarLoadService.this.logger.debug("Exception while processing JarLoadMonitor task: %s", e);
                        }
                    }
                    finally {
                        JarLoadService.this.tasksCompletedCounter.incrementAndGet();
                        JarLoadService.this.tasksInProgressCounter.decrementAndGet();
                    }
                });
            }
        };
        this.jarDetailsRequestMonitor = new JarDetailsRequestMonitor();
        long fileCacheSize = 1024L * Options.maxJarFileCacheSize.getLong();
        long maxQueueSize = Tweaks.jarLoadMonitorTaskQueueSize;
        boolean waitAllJarRequests = Tweaks.WAIT_ALL_JAR_REQUESTS;
        this.tempFilesMonitor = new TempFilesMonitor(this.executorService, referenceFactory, fileCacheSize, maxQueueSize, waitAllJarRequests);
    }

    @Override
    public void start() {
        this.logger.trace("start", new Object[0]);
        this.tempFilesMonitor.start();
        this.jarDetailsRequestMonitor.start();
        this.reportClassPathJars();
        this.terminated = false;
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.logger.trace("stop started, deadline=%s", deadline);
        int cnt = 0;
        boolean cont = false;
        do {
            long mec = this.eventsProcessingInProgress.get().size();
            long tc = this.tasksInProgressCounter.get();
            long tcc = this.tasksCompletedCounter.get();
            boolean jdc = this.jarDetailsRequestMonitor.expectingRequests();
            boolean tfc = this.tempFilesMonitor.expectingRequests();
            long eip = this.eventsSendingInProgress.get().get();
            cont = !Utils.Deadline.hasExpired(deadline) && (mec > 0L || tc > 0L || eip > 0L || jdc || tfc);
            try {
                if (this.terminated) {
                    this.logger.trace("cancel => break from stop method loop", new Object[0]);
                    break;
                }
                if (0 == (cnt = (cnt + 1) % 500) || !cont) {
                    this.logger.trace("stop in progress: deadline=%d, eventsProcessingInProgress=%d,  tasksInProgressCounter=%d, eventsSendingInProgress=%d, tasksCompletedCounter=%d, expectingDetails=%s:%s", deadline.remainder(TimeUnit.MILLISECONDS), mec, tc, eip, tcc, jdc, tfc);
                }
                if (!cont) continue;
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                break;
            }
        } while (cont);
        this.jarDetailsRequestMonitor.stop(deadline);
        this.tempFilesMonitor.stop(deadline);
        this.executorService.shutdownNow();
        this.logger.trace("stop finished, exiting, deadline=%s, unhandledExceptions=%d", deadline, this.unhandledExceptions.get());
        for (JarAccess jarAccess : this.jarsInProgress.get()) {
            jarAccess.getTracker().info();
        }
        if (Tweaks.DEBUG_JARLOAD) {
            this.logger.trace("unfinished work: ", new Object[0]);
            this.jarDetailsRequestMonitor.stop(deadline);
            this.tempFilesMonitor.stop(deadline);
            this.eventsSendingInProgress.get().dump();
            this.eventsProcessingInProgress.get().dump();
            AsyncResourceHandler.dump();
            LRU.dump();
            LRUCache.dump();
            this.logger.debug("canceled jars due to tempfs limit: %d", this.jarFilesCanceledDueToTempfsLimit.get());
            this.logger.debug("canceled jars in total: %d", this.jarFilesCanceledTotal.get());
        }
    }

    @Override
    public void terminate() {
        this.cancel();
        this.executorService.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JarLoadService getInstance(VmEventConsumer eventConsumer, ReferenceFactory referenceFactory) {
        if (instance != null) return instance;
        Class<JarLoadService> clazz = JarLoadService.class;
        synchronized (JarLoadService.class) {
            if (instance != null) return instance;
            instance = new JarLoadService(eventConsumer, referenceFactory);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private void postEvent(VMEvent event) {
        this.eventsSendingInProgress.get().incrementAndGet(event);
        event.onSuccessAppend(r -> () -> {
            try {
                if (r != null) {
                    r.run();
                }
            }
            finally {
                this.eventsSendingInProgress.get().decrementAndGet(event);
            }
        }).onErrorAppend(r -> () -> {
            try {
                if (r != null) {
                    r.run();
                }
            }
            finally {
                this.eventsSendingInProgress.get().decrementAndGet(event);
            }
        });
        try {
            VMEventHelper.postVMJarLoadedEvent(this.eventConsumer, event);
        }
        catch (Throwable t) {
            this.eventsSendingInProgress.get().decrementAndGet(event);
            this.logger.trace("failed to post VMEvent: %s", t);
            event.callOnError();
        }
    }

    public void notifyJarLoad(URL url, JarFile jar) {
        block5: {
            if (!FeatureFlagsConfiguration.notifyJarLoaded()) {
                return;
            }
            if (!Tweaks.ENABLE_NOTIFY_JAR_LOAD_CALLBACK) {
                return;
            }
            try {
                this.logger.trace("notifyJarLoad: url(%s), jar(%s)", url, Utils.toStringWithIdentityHash(jar));
                JarSource jarSource = new JarSource.Builder().fromUrl(url).withCache(this.sourceCache).build();
                if (jarSource != null) {
                    this.logger.debug("Creating pipeline for url=%s and jar=%s ... %s", url, jar, jarSource.toString());
                    this.processJarLoad(AsyncPipeline.first(() -> this.jarAccessFactory.create(jarSource, jar)));
                }
            }
            catch (Throwable e0) {
                System.err.println("error: unexpected exception in CRS: " + e0);
                if (!Tweaks.DEBUG_JARLOAD) break block5;
                e0.printStackTrace();
            }
        }
    }

    public void notifyJarLoad(URL url) {
        block5: {
            if (!FeatureFlagsConfiguration.notifyJarLoaded()) {
                return;
            }
            if (!Tweaks.ENABLE_NOTIFY_JAR_LOAD_CALLBACK) {
                return;
            }
            try {
                this.logger.trace("notifyJarLoad: url(%s)", url);
                JarSource jarSource = new JarSource.Builder().fromUrl(url).withCache(this.sourceCache).build();
                if (jarSource != null) {
                    this.logger.debug("Creating pipeline for url=%s ... %s", url, jarSource.toString());
                    this.processJarLoad(AsyncPipeline.first(() -> this.jarAccessFactory.create(jarSource, JarAccess.InitiatedBy.CLASS_LOADING)));
                }
            }
            catch (Throwable e0) {
                System.err.println("error: unexpected exception in CRS: " + e0);
                if (!Tweaks.DEBUG_JARLOAD) break block5;
                e0.printStackTrace();
            }
        }
    }

    private void notifyClassPathEntryOrSourceSeen(String source, JarAccess.InitiatedBy initiatedBy) {
        block4: {
            if (!FeatureFlagsConfiguration.notifyJarLoaded()) {
                return;
            }
            try {
                this.logger.trace("notifyClassPathEntryOrSourceSeen: source(%s), initiatedBy(%s)", new Object[]{source, initiatedBy});
                JarSource jarSource = new JarSource.Builder().fromSource(source).withCache(this.sourceCache).build();
                if (jarSource != null) {
                    this.logger.debug("Creating pipeline for source=%s ... %s", source, jarSource.toString());
                    this.processJarLoad(AsyncPipeline.first(() -> this.jarAccessFactory.create(jarSource, initiatedBy)));
                }
            }
            catch (Throwable e0) {
                System.err.println("error: unexpected exception in CRS: " + e0);
                if (!Tweaks.DEBUG_JARLOAD) break block4;
                e0.printStackTrace();
            }
        }
    }

    public void notifyClassSourceSeen(String source) {
        if (!FeatureFlagsConfiguration.notifyJarLoaded()) {
            return;
        }
        if (!Tweaks.ENABLE_NOTIFY_JAR_LOAD_BY_CLASSLOAD) {
            return;
        }
        this.notifyClassPathEntryOrSourceSeen(source, JarAccess.InitiatedBy.CLASS_LOADING);
    }

    public void notifyClassPathEntrySeen(String source) {
        if (!FeatureFlagsConfiguration.notifyJarLoaded()) {
            return;
        }
        if (!Tweaks.ENABLE_NOTIFY_JAR_LOAD_CLASS_PATH) {
            return;
        }
        this.notifyClassPathEntryOrSourceSeen(source, JarAccess.InitiatedBy.CLASS_PATH_ENTRY);
    }

    public void notifyClassPathEntryByManifestSeen(String source) {
        if (!FeatureFlagsConfiguration.notifyJarLoaded()) {
            return;
        }
        if (!Tweaks.ENABLE_NOTIFY_JAR_LOAD_CLASS_PATH) {
            return;
        }
        this.notifyClassPathEntryOrSourceSeen(source, JarAccess.InitiatedBy.CLASS_PATH_ENTRY_BY_MANIFEST);
    }

    @Override
    public void cancel() {
        this.terminated = true;
    }

    private void postJarError(JarAccess jarAccess, VMEventHelper.JarLoadProcessingError je, Exception e) {
        if (je == VMEventHelper.JarLoadProcessingError.TEMPFS_LIMIT) {
            this.jarFilesCanceledDueToTempfsLimit.incrementAndGet();
        }
        VMEvent eventWithError = VMEventHelper.jarLoadEventWithError(null, jarAccess, je, e);
        this.postEvent(eventWithError);
    }

    private Function<AsyncResourceHandler<JarAccess>, AsyncResourceHandler<JarAccess>> allocateTempFile(AsyncPipeline<JarAccess> context) {
        return holder -> {
            JarAccess ja = (JarAccess)holder.getObject();
            ja.getTracker().trace(JarTrackerEnum.BEFORE_TEMP_ALLOCATION);
            this.logger.trace("requesting temp file for jarAccess=%s; holder=%s", ja, holder);
            this.tempFilesMonitor.allocate(ja.requiredTempfsSpace()).whenComplete((tmp, throwable) -> {
                if (throwable != null) {
                    if (throwable instanceof CancellationException) {
                        ((JarAccess)holder.getObject()).getTracker().cancel((Exception)throwable);
                        holder.cancel((Exception)throwable);
                        return;
                    }
                    if (throwable instanceof InsufficientTempfsLimitException) {
                        this.logger.trace("temp file allocation failure for jarAccess=%s, => not enough space (%s[Kb] limit); holder=%s", ja, Options.maxJarFileCacheSize.getLong(), holder);
                        ja.getTracker().trace(JarTrackerEnum.ON_NOT_ENOUGH_TEMPFS_LIMIT);
                        this.postJarError((JarAccess)holder.getObject(), VMEventHelper.JarLoadProcessingError.TEMPFS_LIMIT, (InsufficientTempfsLimitException)throwable);
                        ((JarAccess)holder.getObject()).getTracker().traceError((InsufficientTempfsLimitException)throwable);
                        holder.cancel((InsufficientTempfsLimitException)throwable);
                    } else if (throwable instanceof MonitorServiceException) {
                        ((JarAccess)holder.getObject()).getTracker().traceError((Exception)throwable);
                        holder.cancel(new RuntimeException((Throwable)throwable));
                    } else {
                        ((JarAccess)holder.getObject()).getTracker().traceError((Exception)throwable);
                        holder.cancel(new RuntimeException((Throwable)throwable));
                    }
                    return;
                }
                this.logger.trace("temp file allocated jarAccess=%s, tempFile=%s; holder=%s", ja, tmp, holder);
                if (tmp != null) {
                    ja.getTracker().trace(JarTrackerEnum.TEMPFILE_ALLOCATED);
                    holder.finalizer = () -> {
                        this.logger.trace("[allocateTempFile$finalizer] deleting temp file[%s] associated with jarAccess=%s; holder=%s", tmp, ja, holder);
                        tmp.delete();
                    };
                } else {
                    this.logger.trace("temp file is not required for jarAccess=%s; holder=%s", ja, holder);
                    ja.getTracker().trace(JarTrackerEnum.TEMPFILE_IS_NOT_REQUIRED);
                }
                try {
                    ja.acquireResources((TempFilesFactory.TempFile)tmp);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                holder.next().accept(ja);
            });
            return holder.next();
        };
    }

    private Function<AsyncResourceHandler<JarAccess>, AsyncResourceHandler<JarAccess>> reportClassPathEntriesByManifest(AsyncPipeline<JarAccess> context) {
        return holder -> {
            ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.BEFORE_REPORT_CLASS_PATH_ATTRIBUTE);
            this.logger.trace("reporting jars initiated by class-path properties from manifest file for jarAccess=%s; holder=%s", holder, holder.getObject(), holder);
            ((JarAccess)holder.getObject()).forEachManifestClassPathEntry(s -> this.notifyClassPathEntryByManifestSeen((String)s));
            holder.next().accept(holder.getObject());
            return holder.next();
        };
    }

    private Function<AsyncResourceHandler<JarAccess>, AsyncResourceHandler<JarAccess>> reportMinimalEventAndWaitDetails(AsyncPipeline<JarAccess> context) {
        return holder -> {
            ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.BEFORE_REPORT_MINIMAL_EVENT);
            PerformanceMetrics.logJarLoadEventReported();
            holder.finalizer = () -> {
                ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.MINIMAL_EVENT_FINALIZER);
                PerformanceMetrics.logJarLoadEventConfirmed();
            };
            CountdownRunnable cr = new CountdownRunnable(2, h -> {
                ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.MINIMAL_EVENT_ON_COUNTDOWN);
                h.next().accept(h.getObject());
            }, (h, e) -> {
                ((JarAccess)h.getObject()).getTracker().cancel((Exception)e);
                h.next().cancel((Exception)e);
            });
            VMEvent minimal = VMEventHelper.prepareMinimalEvent((JarAccess)holder.getObject());
            minimal.onSuccess(() -> {
                ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.MINIMAL_EVENT_SENT_SUCCESSFULLY);
                this.logger.trace("(check if called) onSuccess: %s; holder=%s", holder.getObject(), holder);
                cr.runOrDecrement((AsyncResourceHandler)holder);
            });
            minimal.onError(() -> {
                ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.MINIMAL_EVENT_WAS_NOT_SENT_DUE_TO_ERROR);
                this.jarDetailsRequestMonitor.cancel((JarAccess)holder.getObject());
                cr.cancel((AsyncResourceHandler)holder, new RuntimeException("event for " + holder.getObject() + " was not sent."));
            });
            this.jarDetailsRequestMonitor.waitFor(this.executorService, (JarAccess)holder.getObject(), (details, exception) -> {
                DetailsRequestInfo detailsForDebug = new DetailsRequestInfo((VmJarInfoRequestSupport.VmJarInfoRequest.DetailsLevel)((Object)((Object)details)), (JarAccess)holder.getObject(), (Exception)exception);
                AsyncPipeline.first(() -> holder).next(AsyncPipeline::notNull).step(h -> {
                    h.finalizer = () -> this.eventsProcessingInProgress.get().remove(detailsForDebug);
                    this.eventsProcessingInProgress.get().add(detailsForDebug);
                }).step(h -> {
                    ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.JAR_DETAILS_RECEIVED);
                    this.logger.trace("(on response) jarAccess=%s, detailsLevel=%s, cause=%s; holder=%s", holder.getObject(), details, exception, holder);
                    if (exception != null) {
                        cr.cancel((AsyncResourceHandler)holder, new RuntimeException("wrap: ", (Throwable)exception));
                        return;
                    }
                    if (details == VmJarInfoRequestSupport.VmJarInfoRequest.DetailsLevel.NONE) {
                        ((JarAccess)holder.getObject()).getTracker().traceDetails(JarDetailsEnum.NOT_NEEDED);
                        ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.JAR_DETAILS_NONE);
                        holder.finalize();
                        return;
                    }
                    assert (details == VmJarInfoRequestSupport.VmJarInfoRequest.DetailsLevel.ALL_HASHES);
                    ((JarAccess)holder.getObject()).getTracker().traceDetails(JarDetailsEnum.REQUESTED);
                    ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.JAR_DETAILS_ALL_HASHES);
                    cr.runOrDecrement((AsyncResourceHandler)holder);
                }).start(this.executorService);
            });
            this.postEvent(minimal);
            return holder.next();
        };
    }

    private Function<AsyncResourceHandler<JarAccess>, AsyncResourceHandler<JarAccess>> reportAllNestedJars(AsyncPipeline<JarAccess> context) {
        return holder -> {
            ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.BEFORE_REPORTING_NESTED);
            JarAccess jarAccess = (JarAccess)holder.getObject();
            this.logger.trace("report nested jars: jarAccess=%s; holder=%s", jarAccess, holder);
            ArrayList jars = new ArrayList();
            jarAccess.forEachJarEntry(je -> jars.add(je));
            this.logger.trace("report nested jars: jarAccess=%s, children-N=%d; holder=%s", jarAccess, jars.size(), holder);
            VMEventHelper.prepareMinimalEvent(jarAccess);
            int triggerAfter = Tweaks.forceFullJarLoadedEvents && !Tweaks.keepNestedToParentOrderOnForceFull ? 1 : 1 + jars.size();
            CountdownRunnable cr = new CountdownRunnable(triggerAfter, ja -> {
                ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.ALL_NESTED_REPORTED);
                holder.next().accept(holder.getObject());
            }, (ja, e) -> {
                ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.NESTED_JAR_REPORTING_ERROR);
                this.postJarError(jarAccess, VMEventHelper.JarLoadProcessingError.NESTED_JAR, (Exception)e);
                ((JarAccess)holder.getObject()).getTracker().cancel((Exception)e);
                holder.cancel((Exception)e);
            });
            cr.runOrDecrement(null);
            for (JarAccess je2 : jars) {
                this.logger.trace("report nested entry (parent:%s)->(nested:%s); holder=%s", jarAccess, je2, holder);
                this.processJarLoad(AsyncPipeline.first(() -> je2).next(p -> h -> {
                    h.finalizer = () -> cr.runOrDecrement(je2);
                    h.errorHandler = e -> cr.cancel(h.getObject(), new RuntimeException("nested jar processing exception", (Throwable)e));
                    h.next().accept(h.getObject());
                    return h.next();
                }));
            }
            return holder.next();
        };
    }

    private Function<AsyncResourceHandler<JarAccess>, AsyncResourceHandler<JarAccess>> reportFullEvent(AsyncPipeline<JarAccess> context) {
        return holder -> {
            ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.BEFORE_REPORT_FULL_EVENT);
            JarAccess jarAccess = (JarAccess)holder.getObject();
            this.logger.trace("postFull after all children, jarAccess=%s; holder=%s", jarAccess, holder);
            VMEventHelper.prepareDetailed(jarAccess.getCache().vmEvent, jarAccess);
            jarAccess.getCache().vmEvent.onSuccess(() -> {
                ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.FULL_EVENT_SENT_SUCCESFULLY);
                holder.next().accept(holder.getObject());
            }).onError(() -> ((JarAccess)holder.getObject()).getTracker().trace(JarTrackerEnum.FULL_EVENT_WAS_NOT_SENT_DUE_TO_ERROR));
            this.postEvent(jarAccess.getCache().vmEvent);
            return holder.next();
        };
    }

    public void processJarLoad(AsyncPipeline<JarAccess> pipeline) {
        if (Tweaks.forceFullJarLoadedEvents) {
            pipeline.next(AsyncPipeline::notNull).step(h -> {
                h.errorHandler = e -> ((JarAccess)h.getObject()).getTracker().traceError((Exception)e);
            }).step(h -> ((JarAccess)h.getObject()).getTracker().traceDetails(JarDetailsEnum.FORCED)).step(h -> {
                h.errorHandler = e -> this.jarFilesCanceledTotal.incrementAndGet();
            }).step(h -> {
                h.finalizer = () -> {
                    ((JarAccess)h.getObject()).getTracker().assertStatusIn(String.format("after processing jarAccess=(%s); holder=%s", Utils.toStringWithIdentityHash(h.getObject()), h), JarTrackerEnum.FULL_EVENT_SENT_SUCCESFULLY);
                    ((JarAccess)h.getObject()).getTracker().finish();
                    ((JarAccess)h.getObject()).getTracker().info();
                };
            }).step(h -> {
                h.finalizer = () -> this.jarsInProgress.get().remove(h.getObject());
                this.jarsInProgress.get().add((JarAccess)h.getObject());
            }).step(h -> {
                h.finalizer = () -> this.eventsProcessingInProgress.get().remove(h.getObject());
                this.eventsProcessingInProgress.get().add(h.getObject());
            }).next(this::allocateTempFile).next(this::reportClassPathEntriesByManifest).next(this::reportAllNestedJars).next(this::reportFullEvent).start(this.executorService);
            return;
        }
        pipeline.next(AsyncPipeline::notNull).step(h -> {
            h.errorHandler = e -> ((JarAccess)h.getObject()).getTracker().traceError((Exception)e);
        }).step(h -> {
            h.errorHandler = e -> this.jarFilesCanceledTotal.incrementAndGet();
        }).step(h -> {
            h.finalizer = () -> {
                ((JarAccess)h.getObject()).getTracker().assertStatusIn(String.format("after processing jarAccess=(%s); holder=%s", Utils.toStringWithIdentityHash(h.getObject()), h), JarTrackerEnum.FULL_EVENT_SENT_SUCCESFULLY, JarTrackerEnum.JAR_DETAILS_NONE, JarTrackerEnum.MINIMAL_EVENT_FINALIZER);
                ((JarAccess)h.getObject()).getTracker().finish();
                ((JarAccess)h.getObject()).getTracker().info();
            };
        }).step(h -> {
            h.finalizer = () -> this.jarsInProgress.get().remove(h.getObject());
            this.jarsInProgress.get().add((JarAccess)h.getObject());
        }).step(h -> {
            h.finalizer = () -> this.eventsProcessingInProgress.get().remove(h.getObject());
            this.eventsProcessingInProgress.get().add(h.getObject());
        }).next(this::allocateTempFile).next(this::reportClassPathEntriesByManifest).next(this::reportMinimalEventAndWaitDetails).step(h -> {
            if (!Tweaks.postponeExitUntilNoUnconfirmedJars) {
                this.eventsProcessingInProgress.get().remove(h.getObject());
            }
        }).next(this::reportAllNestedJars).next(this::reportFullEvent).start(this.executorService);
    }

    private void reportClassPathJars(Collection<String> jars) {
        for (String jar : jars) {
            try {
                this.notifyClassPathEntrySeen(jar);
            }
            catch (Exception e) {
                this.logger.warning("unexpected problem handling ClassPath entry %s: %s", jar, e);
            }
        }
    }

    private void reportClassPathJars() {
        this.reportClassPathJars(JarLoadService.getClassPathJarList());
    }

    private static List<String> getClassPathJarList() {
        return ClassPathToSource.process(System.getProperty("java.class.path"));
    }

    private class DetailsRequestInfo {
        private final VmJarInfoRequestSupport.VmJarInfoRequest.DetailsLevel details;
        private final JarAccess jarAccess;
        private final Exception exception;

        public DetailsRequestInfo(VmJarInfoRequestSupport.VmJarInfoRequest.DetailsLevel details, JarAccess jarAccess, Exception exception) {
            this.details = details;
            this.jarAccess = jarAccess;
            this.exception = exception;
        }

        public String toString() {
            return "DetailsRequestInfo[details=" + (Object)((Object)this.details) + ", exception=" + this.exception + ", jarAccess=" + this.jarAccess + "]";
        }
    }
}

