/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.service;

import com.azul.crs.javaagent.client.PerformanceMetrics;
import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.agent.MainMethodDetectionInterface;
import com.azul.crs.javaagent.client.agent.VmMessage;
import com.azul.crs.javaagent.client.classLoad.ClassLoadMessage;
import com.azul.crs.javaagent.client.classLoad.ClassLoaderWrapper;
import com.azul.crs.javaagent.client.firstCall.FirstMethodCallMessage;
import com.azul.crs.javaagent.client.safeguards.InsufficientMemoryException;
import com.azul.crs.javaagent.client.safeguards.Reference;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.service.ClassLoadInterface;
import com.azul.crs.javaagent.client.service.ClientService;
import com.azul.crs.javaagent.client.service.FirstCallInterface;
import com.azul.crs.javaagent.client.service.JarLoadReporterInterface;
import com.azul.crs.javaagent.client.service.MessageQueueServiceInterface;
import com.azul.crs.javaagent.util.logging.Logger;
import java.net.URL;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProtectionDomain;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;

public final class MessageQueueService
implements ClientService,
MessageQueueServiceInterface {
    private final Logger logger = Logger.getLogger(MessageQueueService.class);
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.CREATED);
    private final Reference<ConcurrentLinkedQueue<VmMessage>> vmMessages;
    private final boolean notifyJarLoad;
    private final boolean notifyClassLoad;
    private final boolean notifyFirstCall;
    private final int maxQueueSize;
    private final ReferenceFactory referenceFactory;
    private FirstCallInterface firstCallMonitor;
    private ClassLoadInterface classLoadMonitor;
    private JarLoadReporterInterface jarLoadReporter;
    private Utils.Deadline deadline;
    private MessageDigest digest;
    private Processor processor;
    private MainMethodDetectionInterface mainMethodDetector;
    private boolean fullQueueWarning = false;

    private MessageQueueService(ReferenceFactory referenceFactory, boolean notifyJarLoad, boolean notifyClassLoad, boolean notifyFirstCall, int maxQueueSize) {
        this.notifyJarLoad = notifyJarLoad;
        this.notifyClassLoad = notifyClassLoad;
        this.notifyFirstCall = notifyFirstCall;
        this.maxQueueSize = maxQueueSize;
        this.referenceFactory = referenceFactory;
        this.vmMessages = this.referenceFactory.createNewReference(new ConcurrentLinkedQueue());
        this.status.set(Status.CREATED);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void init(FirstCallInterface firstCallMonitor, ClassLoadInterface classLoadMonitor, JarLoadReporterInterface jarLoadReporter, MainMethodDetectionInterface mainMethodDetector) {
        this.firstCallMonitor = firstCallMonitor;
        this.classLoadMonitor = classLoadMonitor;
        this.jarLoadReporter = jarLoadReporter;
        this.processor = new Processor();
        this.mainMethodDetector = mainMethodDetector;
        try {
            this.digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.status.set(Status.INITIALIZED);
    }

    @Override
    public void notifyWith(VmMessage message) {
        if (this.status.get() == Status.STOPPED || this.status.get() == Status.TERMINATED) {
            return;
        }
        try {
            if (this.maxQueueSize <= this.vmMessages.get().size()) {
                PerformanceMetrics.logSkippedClassLoadEvent();
                if (this.fullQueueWarning) {
                    return;
                }
                this.fullQueueWarning = true;
                this.logger.error("Event queue is full (limit=%d), the current incoming event %s is skipped.", this.maxQueueSize, message);
                return;
            }
            this.vmMessages.get().add(message);
        }
        catch (InsufficientMemoryException | OutOfMemoryError e) {
            this.referenceFactory.notifyWithException(e);
            this.logger.error("Failed to enqueue message %s due to %s", message, e);
            this.terminate();
        }
    }

    @Override
    public void start() {
        this.processor.start();
        this.status.set(Status.STARTED);
    }

    @Override
    public void terminate() {
        this.status.set(Status.TERMINATED);
        if (this.processor != null) {
            try {
                this.processor.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(Utils.Deadline deadline) {
        this.logger.debug("Service receives stop instruction. ", new Object[0]);
        if (this.status.get() != Status.STARTED) {
            this.status.set(Status.STOPPED);
            return;
        }
        MessageQueueService messageQueueService = this;
        synchronized (messageQueueService) {
            this.deadline = deadline;
            this.status.set(Status.STOPPED);
        }
        try {
            this.processor.join();
        }
        catch (InterruptedException e) {
            this.logger.debug("Unexpected termination.", new Object[0]);
        }
    }

    private void process(VmMessage message) {
        if (message instanceof FirstMethodCallMessage) {
            if (this.notifyFirstCall) {
                FirstMethodCallMessage firstCallMessage = (FirstMethodCallMessage)message;
                this.firstCallMonitor.notifyMethodFirstCalled(firstCallMessage.classId, firstCallMessage.name);
            }
            return;
        }
        if (message instanceof ClassLoadMessage) {
            ClassLoadMessage classLoadMessage = (ClassLoadMessage)message;
            this.mainMethodDetector.detect(classLoadMessage.className, classLoadMessage.loader);
            String source = Optional.ofNullable(classLoadMessage.protectionDomain).map(ProtectionDomain::getCodeSource).map(CodeSource::getLocation).map(URL::toString).orElse(null);
            if (this.notifyClassLoad) {
                this.classLoadMonitor.notifyClassLoad(classLoadMessage.className, this.digest.digest(classLoadMessage.classfileBuffer), null, classLoadMessage.classId, 0, source, classLoadMessage.firstCallPatchingResult);
            }
            if (this.notifyJarLoad) {
                this.jarLoadReporter.notifyWith(source, new ClassLoaderWrapper(classLoadMessage.loader));
            }
            return;
        }
        throw new RuntimeException("Unexpected type of message: " + message);
    }

    private synchronized boolean hardstop() {
        return this.deadline == null || this.deadline.hasExpired();
    }

    int queueSize() {
        return this.vmMessages.get().size();
    }

    public static final class Builder {
        private ReferenceFactory referenceFactory;
        private boolean notifyJarLoad = true;
        private boolean notifyClassLoad = true;
        private boolean notifyFirstCall = false;
        private int maxQueueSize = Tweaks.MAX_QUEUE_SIZE;

        public Builder withNotifyJarLoad(boolean allow) {
            this.notifyJarLoad = allow;
            return this;
        }

        public Builder withNotifyClassLoad(boolean allow) {
            this.notifyClassLoad = allow;
            return this;
        }

        public Builder withNotifyFirstCall(boolean allow) {
            this.notifyFirstCall = allow;
            return this;
        }

        public Builder withMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Builder withReferenceFactory(ReferenceFactory referenceFactory) {
            this.referenceFactory = referenceFactory;
            return this;
        }

        public MessageQueueService build() {
            if (!(this.notifyFirstCall || this.notifyClassLoad || this.notifyJarLoad)) {
                return null;
            }
            return new MessageQueueService(this.referenceFactory, this.notifyJarLoad, this.notifyClassLoad, this.notifyFirstCall, this.maxQueueSize);
        }
    }

    private class Processor
    extends Thread {
        private Processor() {
        }

        @Override
        public void run() {
            VmMessage message;
            MessageQueueService.this.logger.debug("Service starts.", new Object[0]);
            while (MessageQueueService.this.status.get() != Status.STOPPED && MessageQueueService.this.status.get() != Status.TERMINATED) {
                message = (VmMessage)((ConcurrentLinkedQueue)MessageQueueService.this.vmMessages.get()).poll();
                if (message != null) {
                    MessageQueueService.this.process(message);
                    continue;
                }
                try {
                    Thread.sleep(Tweaks.POLL_TIMEOUT);
                }
                catch (InterruptedException e) {
                    MessageQueueService.this.logger.error("Unexpected interrupt for class load event service!", new Object[0]);
                    MessageQueueService.this.status.set(Status.STOPPED);
                    throw new RuntimeException(e);
                }
            }
            while (!MessageQueueService.this.hardstop() && (message = (VmMessage)((ConcurrentLinkedQueue)MessageQueueService.this.vmMessages.get()).poll()) != null) {
                MessageQueueService.this.process(message);
            }
            if (!((ConcurrentLinkedQueue)MessageQueueService.this.vmMessages.get()).isEmpty()) {
                MessageQueueService.this.logger.info("UNSENT DATA AFTER TERMINATION:  %d  class load events not sent. You may want to increase delayTermination.", ((ConcurrentLinkedQueue)MessageQueueService.this.vmMessages.get()).size());
            }
            MessageQueueService.this.logger.debug("Service terminated.", new Object[0]);
        }
    }

    private static enum Status {
        CREATED,
        INITIALIZED,
        STARTED,
        STOPPED,
        TERMINATED;

    }
}

