/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.service;

import com.azul.crs.javaagent.client.PerformanceMetrics;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.safeguards.InsufficientMemoryException;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.service.ClientService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class QueueService<T>
implements ClientService {
    private static final int DEFAULT_MAX_SEND_DELAY = 5000;
    private static final int DEFAULT_MAX_QUEUE_SIZE = 5000;
    private static final int DEFAULT_MAX_WORKERS = 3;
    private static final int DEFAULT_MAX_BATCH_SIZE = 1000;
    private static final long DEFAULT_ADD_TIMEOUT = 500L;
    private final BlockingQueue<Object> queue;
    private final List<WorkerThread> workerThreads;
    private final AtomicReference<Utils.Deadline> stopDeadline = new AtomicReference();
    private volatile boolean stopAcceptingItems;
    private final AtomicInteger declinedEvents = new AtomicInteger();
    private final int maxQueueSize;
    private final int maxWorkers;
    private final int maxBatchSize;
    private final long addTimeout;
    private final long maxSendDelay;
    private final ProcessBatch<T> postBatch;
    private final ProcessBatch<T> cancelBatch;
    private final Function<T, Boolean> filter;
    private final String name;
    private final ReferenceFactory referenceFactory;
    private final AtomicInteger recursionCounter = new AtomicInteger();

    private QueueService(int maxQueueSize, int maxWorkers, int maxBatchSize, long addTimeout, long maxSendDelay, ProcessBatch<T> postBatch, ProcessBatch<T> cancelBatch, Function<T, Boolean> filter, String name, ReferenceFactory referenceFactory) {
        this.maxQueueSize = maxQueueSize;
        this.maxWorkers = maxWorkers;
        this.maxBatchSize = maxBatchSize;
        this.addTimeout = addTimeout;
        this.maxSendDelay = maxSendDelay;
        this.postBatch = postBatch;
        this.cancelBatch = cancelBatch;
        this.filter = filter;
        this.queue = referenceFactory.createNewBlockingQueue(maxQueueSize);
        this.workerThreads = new LinkedList<WorkerThread>();
        this.name = name;
        this.referenceFactory = referenceFactory;
    }

    @Override
    public String serviceName() {
        return ClientService.super.serviceName() + " [" + this.name + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        List<WorkerThread> list = this.workerThreads;
        synchronized (list) {
            if (this.stopDeadline.get() != null) {
                return;
            }
            if (!this.workerThreads.isEmpty()) {
                throw new IllegalStateException(this.serviceName() + " has been started already");
            }
            for (int i = 0; i < this.maxWorkers; ++i) {
                WorkerThread w = new WorkerThread(String.valueOf(i));
                this.workerThreads.add(w);
                w.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(Utils.Deadline deadline) {
        if (deadline == null) {
            throw new NullPointerException();
        }
        if (this.stopDeadline.compareAndSet(null, deadline)) {
            List<WorkerThread> list = this.workerThreads;
            synchronized (list) {
                this.sync(true);
                this.stopAcceptingItems = true;
                this.workerThreads.forEach(t -> ((WorkerThread)t).join(deadline));
                this.workerThreads.forEach(t -> t.interrupt());
            }
            if (this.cancelBatch != null) {
                this.cancelBatch.process(this.queue.stream().filter(o -> !(o instanceof Marker)).map(o -> o).collect(Collectors.toList()));
            }
            if (!this.queue.isEmpty() || this.declinedEvents.get() != 0) {
                this.logger().info("UNSENT DATA AFTER TERMINATION:  %d  items not sent. You may want to increase delayTermination.", this.queue.size() + this.declinedEvents.get());
            }
        }
    }

    @Override
    public void terminate() {
        this.cancel();
    }

    public void cancel() {
        this.stopAcceptingItems = true;
        this.stop(Utils.Deadline.in(0L, TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T item) {
        Utils.Deadline deadline = this.stopDeadline.get();
        if (deadline != null && this.stopAcceptingItems) {
            this.declinedEvents.getAndIncrement();
            return false;
        }
        long timeout = deadline == null ? this.addTimeout : deadline.remainder(TimeUnit.MILLISECONDS);
        try {
            if (this.queue.offer(item, timeout, TimeUnit.MILLISECONDS)) {
                boolean bl = true;
                return bl;
            }
            if (this.cancelBatch != null) {
                this.cancelBatch.process(Collections.singleton(item));
            }
            try {
                if (this.recursionCounter.getAndIncrement() == 0) {
                    this.logger().error(String.format("QueueService %s: failed to enqueue an item. queueSize=%d, maxQueueSize=%d, timeout=%d, item=%s", this.name, this.queue.size(), this.maxQueueSize, timeout, item), new Object[0]);
                }
            }
            finally {
                this.recursionCounter.decrementAndGet();
            }
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
        finally {
            PerformanceMetrics.logEventQueueLength(this.queue.size());
        }
        PerformanceMetrics.logSkippedSendingEvent();
        return false;
    }

    public void skipOverQueue(T item) {
        this.postBatch.process("CRSQW" + this.name + "VMStart", Collections.singleton(item));
    }

    public void sync() {
        this.sync(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(boolean stop) {
        List<WorkerThread> list = this.workerThreads;
        synchronized (list) {
            Marker marker = new Marker(this.workerThreads.size(), stop);
            try {
                for (WorkerThread wt : this.workerThreads) {
                    this.queue.put(marker);
                }
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
            }
        }
    }

    private static final class Marker
    extends CountDownLatch {
        private final boolean stop;

        public Marker(int count, boolean stop) {
            super(count);
            this.stop = stop;
        }
    }

    private final class WorkerThread
    extends Thread {
        private final String id;
        private final List<T> batch;
        private boolean throwableErrorNotSent;

        public WorkerThread(String workerId) {
            super("CRSQW-" + QueueService.this.name + workerId);
            this.batch = new ArrayList(QueueService.this.maxBatchSize);
            this.throwableErrorNotSent = false;
            this.setDaemon(true);
            this.id = workerId;
        }

        @Override
        public void run() {
            Utils.Deadline sendDeadline = Utils.Deadline.in(QueueService.this.maxSendDelay, TimeUnit.MILLISECONDS);
            block4: while (true) {
                try {
                    while (true) {
                        boolean deadlineExpired;
                        Object item;
                        if ((item = QueueService.this.queue.poll(sendDeadline.remainder(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS)) instanceof Marker) {
                            Marker marker = (Marker)item;
                            marker.countDown();
                            this.postBatch();
                            if (marker.stop) break block4;
                            marker.await();
                            continue;
                        }
                        if (item != null) {
                            if (QueueService.this.filter == null || ((Boolean)QueueService.this.filter.apply(item)).booleanValue()) {
                                this.batch.add(item);
                            } else {
                                QueueService.this.logger().debug("QueueService filters out the item ...", new Object[0]);
                                QueueService.this.cancelBatch.process(Collections.singleton(item));
                            }
                        }
                        if ((deadlineExpired = sendDeadline.hasExpired()) || this.batch.size() >= QueueService.this.maxBatchSize) {
                            this.postBatch();
                        }
                        if (!deadlineExpired) continue;
                        sendDeadline = Utils.Deadline.in(QueueService.this.maxSendDelay, TimeUnit.MILLISECONDS);
                    }
                }
                catch (InsufficientMemoryException | OutOfMemoryError e) {
                    QueueService.this.logger().error("QueueService Worker [%s:%s] - internal error or unexpected problem. %s", QueueService.this.name, this.id, e);
                    QueueService.this.cancel();
                }
                catch (InterruptedException th) {
                    Thread.interrupted();
                }
                catch (Throwable th) {
                    if (this.throwableErrorNotSent) {
                        QueueService.this.logger().error("QueueService Worker [%s:%s] - internal error or unexpected problem. %s", QueueService.this.name, this.id, th);
                        this.throwableErrorNotSent = true;
                        continue;
                    }
                    QueueService.this.logger().warning("QueueService Worker [%s:%s] - internal error or unexpected problem. %s", QueueService.this.name, this.id, th);
                    continue;
                }
                break;
            }
            QueueService.this.logger().debug("QueueService Worker [%s:%s] has exited", QueueService.this.name, this.id);
        }

        private void postBatch() {
            if (!this.batch.isEmpty()) {
                QueueService.this.postBatch.process(this.id, this.batch);
                this.batch.clear();
            }
        }

        private void join(Utils.Deadline deadline) {
            try {
                this.join(Math.max(1L, deadline.remainder(TimeUnit.MILLISECONDS)));
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
            }
        }
    }

    public static class Builder<T> {
        private int maxQueueSize = 5000;
        private int maxWorkers = 3;
        private int maxBatchSize = 1000;
        private long addTimeout = 500L;
        private long maxSendDelay = 5000L;
        private ProcessBatch<T> postBatch;
        private ProcessBatch<T> cancelBatch;
        private String name = "<unnamed>";
        private Function<T, Boolean> filter;
        private ReferenceFactory referenceFactory;

        public Builder<T> maxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Builder<T> maxWorkers(int maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        public Builder<T> maxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder<T> addTimeout(long duration, TimeUnit units) {
            this.addTimeout = units.toMillis(duration);
            return this;
        }

        public Builder<T> maxSendDelay(long duration, TimeUnit units) {
            this.maxSendDelay = units.toMillis(duration);
            return this;
        }

        public Builder<T> postBatch(ProcessBatch<T> postBatch) {
            this.postBatch = postBatch;
            return this;
        }

        public Builder<T> cancelBatch(ProcessBatch<T> cancelBatch) {
            this.cancelBatch = cancelBatch;
            return this;
        }

        public Builder<T> filter(Function<T, Boolean> filter) {
            this.filter = filter;
            return this;
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> referenceFactory(ReferenceFactory referenceFactory) {
            this.referenceFactory = referenceFactory;
            return this;
        }

        private void notNull(Object o) {
            o.getClass();
        }

        QueueService<T> build() {
            this.notNull(this.postBatch);
            return new QueueService(this.maxQueueSize, this.maxWorkers, this.maxBatchSize, this.addTimeout, this.maxSendDelay, this.postBatch, this.cancelBatch, this.filter, this.name, this.referenceFactory);
        }
    }

    public static interface ProcessBatch<T> {
        public void process(String var1, Collection<T> var2);

        default public void process(Collection<T> batch) {
            this.process(null, batch);
        }
    }
}

