/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.service;

import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.models.ServerRequest;
import com.azul.crs.javaagent.client.safeguards.InsufficientMemoryException;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.service.ClientService;
import com.azul.crs.javaagent.util.logging.Logger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class ServerRequestsService
implements ClientService {
    private static final boolean disableServerRequests = Boolean.getBoolean("com.azul.crs.javaagent.client.service.disableServerRequests");
    private static final Object requestsCountLock = new Object();
    private static final BlockingDeque<ServerRequest> requests = new LinkedBlockingDeque<ServerRequest>();
    private static final Logger log = Logger.getLogger(ServerRequestsService.class);
    private static final ServerRequest stopRequest = new ServerRequest(){

        public String toString() {
            return "StopServerRequestsServiceRequest";
        }
    };
    private static Thread queueProcessingThread = null;
    private static int requestsCount;
    private final ReferenceFactory referenceFactory;
    private boolean isRunning;
    private static final Map<Class<? extends ServerRequest>, List<Consumer>> listeners;

    public ServerRequestsService(ReferenceFactory referenceFactory) {
        this.referenceFactory = referenceFactory;
    }

    @Override
    public String serviceName() {
        return "requests.processor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addServiceRequest(ServerRequest request) {
        log.debug("Adding ServiceRequest: %s", request);
        if (disableServerRequests) {
            log.debug("ServiceRequest: %s was ignored because com.azul.crs.client.service.disableServerRequests was set", request);
            return;
        }
        Object object = requestsCountLock;
        synchronized (object) {
            ++requestsCount;
            requests.add(request);
        }
    }

    @Override
    public synchronized void start() {
        if (this.isRunning) {
            return;
        }
        if (!disableServerRequests) {
            queueProcessingThread = new Thread(this.referenceFactory.getThreadGroup(), new ServerRequestsProcessor(), "ServerRequestsProcessor");
            queueProcessingThread.setDaemon(true);
            queueProcessingThread.start();
        } else {
            log.debug("ServiceRequestService was disabled by com.azul.crs.client.service.disableServerRequests property", new Object[0]);
        }
        this.isRunning = true;
    }

    @Override
    public synchronized void stop(Utils.Deadline deadline) {
        if (!this.isRunning) {
            return;
        }
        ServerRequestsService.addServiceRequest(stopRequest);
        try {
            if (null != queueProcessingThread) {
                queueProcessingThread.join(Math.max(1L, deadline.remainder(TimeUnit.MILLISECONDS)));
            }
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
        }
        if (queueProcessingThread != null && queueProcessingThread.isAlive()) {
            log.debug("Failed to stop ServerRequestsService::queueProcessingThread in time", new Object[0]);
        }
        this.isRunning = false;
    }

    @Override
    public void terminate() {
        this.stop(Utils.Deadline.in(0L, TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRequestsCount() {
        Object object = requestsCountLock;
        synchronized (object) {
            return requestsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitAllRequestsProcessed(Utils.Deadline deadline) {
        long startTime = Utils.currentTimeCount();
        Object object = requestsCountLock;
        synchronized (object) {
            while (!deadline.hasExpired() && ServerRequestsService.getRequestsCount() > 0) {
                try {
                    requestsCountLock.wait(Math.max(1L, deadline.remainder(TimeUnit.MILLISECONDS)));
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                    break;
                }
            }
        }
        log.debug("waitAllRequestsProcessed complete%s", Utils.elapsedTimeString(startTime));
    }

    public void cancel() {
        this.stop(Utils.Deadline.in(0L, TimeUnit.MILLISECONDS));
    }

    public static <T extends ServerRequest> void addListener(Class<T> type, Consumer<T> consumer) {
        listeners.computeIfAbsent(type, t -> new LinkedList()).add(consumer);
    }

    public static boolean isDisabled() {
        return disableServerRequests;
    }

    static {
        listeners = new HashMap<Class<? extends ServerRequest>, List<Consumer>>();
    }

    private static class ServerRequestsProcessor
    implements Runnable {
        private ServerRequestsProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    ServerRequest request = (ServerRequest)requests.takeFirst();
                    if (stopRequest == request) {
                        log.debug("Stop processing ServerRequests", new Object[0]);
                        break;
                    }
                    listeners.entrySet().stream().filter(e -> request.getClass().isAssignableFrom((Class)e.getKey())).forEachOrdered(e -> ((List)e.getValue()).forEach(c -> this.process((Consumer)c, request)));
                    continue;
                }
                catch (InsufficientMemoryException | OutOfMemoryError ex) {
                    throw ex;
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                }
                catch (Throwable t) {
                    log.error("Unexpected error during the processing of server request.", t);
                    continue;
                }
                finally {
                    Object object = requestsCountLock;
                    synchronized (object) {
                        requestsCount--;
                        requestsCountLock.notify();
                    }
                    continue;
                }
                break;
            }
        }

        private void process(Consumer c, ServerRequest r) {
            log.debug("Processing server request: %s", r);
            c.accept(r);
        }
    }
}

