/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.service;

import com.azul.crs.javaagent.client.PerformanceMetrics;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.safeguards.Reference;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.service.InsufficientTempfsLimitException;
import com.azul.crs.javaagent.client.service.MonitorService;
import com.azul.crs.javaagent.client.service.MonitorServiceException;
import com.azul.crs.javaagent.runtime.utils.TempFilesFactory;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;

public class TempFilesMonitor
extends MonitorService {
    private final ExecutorService executorService;
    private final long maxLimit;
    private final long maxQueueSize;
    private final boolean waitAllJarRequests;
    private final AtomicLong currentLimit;
    private final TempFilesFactory.TempFile dummy = null;
    private final Reference<Queue<TempFileRequest>> queue;
    private final Logger logger = Logger.getLogger(this.getClass());
    private boolean fullQueueErrorSent = false;

    public TempFilesMonitor(ExecutorService executorService, ReferenceFactory referenceFactory, long fileCacheSize, long maxQueueSize, boolean waitAllJarRequests) {
        this.executorService = executorService;
        this.maxLimit = fileCacheSize;
        this.maxQueueSize = maxQueueSize;
        this.waitAllJarRequests = waitAllJarRequests;
        this.currentLimit = new AtomicLong(this.maxLimit);
        this.queue = referenceFactory.createNewReference(new ConcurrentLinkedQueue());
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void stop(Utils.Deadline deadline) {
        this.logger.trace("stop (ntd) finished, exiting, deadline=%s, unfinished temp file requests=%d, current limit=%d", deadline, this.queue.get().size(), this.currentLimit.get());
        for (TempFileRequest request : this.queue.get()) {
            request.completeExceptionally(new CancellationException("TempFileRequest has been cancelled because of the stop"));
        }
        this.queue.get().clear();
    }

    @Override
    public void terminate() {
        this.cancel();
    }

    @Override
    public void cancel() {
    }

    private TempFilesFactory.TempFile createTempFile(long size) throws IOException {
        long cl = this.currentLimit.addAndGet(-size);
        if (cl < 0L) {
            this.currentLimit.addAndGet(size);
            return null;
        }
        TempFilesFactory.TempFile tempFile = TempFilesFactory.createTempJarFile(t -> {
            this.logger.trace("on tempfile delete: %s [%d]", Objects.toString(t), size);
            PerformanceMetrics.logJarCacheDeleted(size);
            this.currentLimit.addAndGet(size);
            try {
                if (this.executorService != null) {
                    this.executorService.execute(() -> this.retryPostponed());
                } else {
                    this.retryPostponed();
                }
            }
            catch (Exception e) {
                this.logger.error("onRelease method failed: %s", e);
            }
        });
        if (tempFile != null) {
            PerformanceMetrics.logJarCacheCreated(size);
        } else {
            this.currentLimit.addAndGet(size);
        }
        return tempFile;
    }

    public synchronized boolean expectingRequests() {
        return this.waitAllJarRequests && this.queue.get().size() > 0;
    }

    public long getCurrentLimit() {
        return this.currentLimit.get();
    }

    private synchronized void retryPostponed() {
        TempFileRequest te = null;
        ArrayList<TempFileRequest> postponed = new ArrayList<TempFileRequest>();
        while (null != (te = this.queue.get().poll())) {
            try {
                TempFilesFactory.TempFile tempFile = this.createTempFile(te.size);
                if (tempFile != null) {
                    te.complete(tempFile);
                    continue;
                }
                postponed.add(te);
            }
            catch (IOException e) {
                te.completeExceptionally(new MonitorServiceException("can not allocate tmpFile (size=" + te.size + "): ", e));
            }
        }
        this.queue.get().addAll(postponed);
    }

    public synchronized CompletableFuture<TempFilesFactory.TempFile> allocate(long size) {
        this.logger.trace("requested temp file with size %d", size);
        if (size == 0L) {
            return CompletableFuture.completedFuture(this.dummy);
        }
        CompletableFuture<TempFilesFactory.TempFile> future = new CompletableFuture<TempFilesFactory.TempFile>();
        if (size > this.maxLimit) {
            future.completeExceptionally(new InsufficientTempfsLimitException("Requested size=" + size + " is bigger than max limit=" + this.maxLimit));
            return future;
        }
        TempFileRequest request = new TempFileRequest(size, future);
        try {
            TempFilesFactory.TempFile tempFile = this.createTempFile(size);
            if (tempFile != null) {
                request.complete(tempFile);
            } else if ((long)this.queue.get().size() >= this.maxQueueSize) {
                if (!this.fullQueueErrorSent) {
                    this.logger.error("TempFilesMonitor queue limit has been reached (%d)", this.maxQueueSize);
                    this.fullQueueErrorSent = true;
                }
                request.completeExceptionally(new MonitorServiceException("limit reached: TempFilesMontor.queue.size[" + this.queue.get().size() + "] > maxQueueSize[" + this.maxQueueSize + "]"));
            } else {
                PerformanceMetrics.logJarLoadPostponedDueToNoSpaceYet();
                this.queue.get().add(request);
            }
        }
        catch (IOException e) {
            request.completeExceptionally(new MonitorServiceException("can not allocate tmpFile (size=" + size + "): ", e));
        }
        return future;
    }

    private static class TempFileRequest {
        public final long size;
        public final long ms;
        private final CompletableFuture<TempFilesFactory.TempFile> future;

        public TempFileRequest(long size, CompletableFuture<TempFilesFactory.TempFile> future) {
            this.size = size;
            this.future = future;
            this.ms = Utils.currentTimeMillis();
        }

        public String toString() {
            return "TempFileRequest[" + this.size + "]";
        }

        public void complete(TempFilesFactory.TempFile tempFile) {
            PerformanceMetrics.logJarWaitingTime(Utils.currentTimeMillis() - this.ms);
            this.future.complete(tempFile);
        }

        public void completeExceptionally(Throwable throwable) {
            PerformanceMetrics.logJarWaitingTime(Utils.currentTimeMillis() - this.ms);
            this.future.completeExceptionally(throwable);
        }
    }
}

