/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.service;

import com.azul.crs.javaagent.client.Client;
import com.azul.crs.javaagent.client.PerformanceMetrics;
import com.azul.crs.javaagent.client.Response;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.models.VMArtifactChunk;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.service.ClientService;
import com.azul.crs.javaagent.client.service.DataWriter;
import com.azul.crs.javaagent.client.service.QueueService;
import java.io.IOException;
import java.util.Collection;

public class UploadService
implements ClientService {
    private static final int MAX_QUEUE_SIZE = 50000;
    private static final int MAX_WORKERS = 1;
    private static final int BATCH_SIZE = 1;
    private final QueueService<Job> queue;
    private final Client client;

    public UploadService(Client client, ReferenceFactory referenceFactory) {
        this.queue = new QueueService.Builder().maxQueueSize(50000).maxBatchSize(1).maxWorkers(1).postBatch(this::send).cancelBatch(this::discard).name("UPLOAD").referenceFactory(referenceFactory).build();
        this.client = client;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.queue.stop(deadline);
    }

    public void cancel() {
        this.queue.cancel();
    }

    @Override
    public void terminate() {
        this.cancel();
    }

    public void connectionEstablished() {
        this.logger().trace("connection established, sending artifact data to the cloud", new Object[0]);
        this.queue.start();
    }

    public void post(VMArtifactChunk chunk, DataWriter dataWriter) {
        boolean added = this.queue.add(new Job(chunk, dataWriter));
        if (!added) {
            dataWriter.handleException(new RuntimeException("canceled"));
        }
    }

    public void sync() {
        this.logger().trace("syncing artifact data to the cloud", new Object[0]);
        this.queue.sync();
    }

    private void send(String workerId, Collection<Job> jobs) {
        Job job = jobs.iterator().next();
        VMArtifactChunk chunk = job.chunk;
        DataWriter writer = job.writer;
        try {
            this.logger().trace("Uploading Artifact Chunk: " + chunk, new Object[0]);
            Response<String[]> result = this.client.getConnectionManager().sendVMArtifactChunk(chunk, output -> writer.writeData(new Utils.CountingOutputStream(output, PerformanceMetrics::logArtifactBytes)));
            this.logger().trace("Upload finished " + (result.successful() ? "successfully" : "abnormally"), new Object[0]);
            if (!result.successful()) {
                throw new IOException("Failed to upload Artifact Chunk: " + chunk + ", with error: " + result.getError());
            }
        }
        catch (IOException e) {
            this.logger().error("An error occurred while uploading data: %s", e);
            writer.handleException(e);
        }
    }

    private void discard(String workerId, Collection<Job> jobs) {
        jobs.forEach(j -> ((Job)j).writer.handleException(new RuntimeException("canceled")));
    }

    private static class Job {
        private final VMArtifactChunk chunk;
        private final DataWriter writer;

        public Job(VMArtifactChunk chunk, DataWriter writer) {
            this.chunk = chunk;
            this.writer = writer;
        }
    }
}

