/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.service;

import com.azul.crs.javaagent.client.models.ServerRequest;

public final class VmJarInfoRequestSupport {
    private VmJarInfoRequestSupport() {
    }

    static VmJarInfoRequest decodeVmJarInfoRequest(String data) {
        String[] parts = data.split("\\|");
        VmJarInfoRequestCookie cookie = null;
        VmJarInfoRequest.DetailsLevel detailsLevel = VmJarInfoRequest.DetailsLevel.ALL_HASHES;
        for (String part : parts) {
            String[] chunks = part.split("=", 2);
            try {
                if (chunks.length != 2) continue;
                switch (chunks[0]) {
                    case "cookie": {
                        cookie = (VmJarInfoRequestCookie)new VmJarInfoRequestCookie().decode(chunks[1]);
                        break;
                    }
                    case "detailsLevel": {
                        detailsLevel = VmJarInfoRequest.DetailsLevel.valueOf(chunks[1]);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cookie == null ? null : new VmJarInfoRequest(cookie, detailsLevel);
    }

    public static final class VmJarInfoRequestCookie
    extends ServerRequest.RequestCookie<VmJarInfoRequestCookie> {
        static final int COOKIE_PROPERTIES_NUMBER = 3;
        static final int PATH_POS = 0;
        static final int URL_POS = 1;
        static final int HASH_POS = 2;

        public VmJarInfoRequestCookie(String path, String url, String hash) {
            super(new String[]{path, url, hash});
            assert (this.data.length == 3);
            assert (this.data[0] == path);
            assert (this.data[1] == url);
            assert (this.data[2] == hash);
        }

        private VmJarInfoRequestCookie() {
            super(new String[3]);
            assert (this.data.length == 3);
        }

        public String getPath() {
            return this.data[0];
        }

        public String getUrl() {
            return this.data[1];
        }

        public String getCDHash() {
            return this.data[2];
        }

        static {
            VmJarInfoRequest.registerDecoder();
        }
    }

    public static final class VmJarInfoRequest
    extends ServerRequest {
        private final DetailsLevel detailsLevel;
        private final VmJarInfoRequestCookie cookie;

        private static void registerDecoder() {
            ServerRequest.registerDecoder("VmJarInfoRequest", VmJarInfoRequestSupport::decodeVmJarInfoRequest);
        }

        private VmJarInfoRequest(VmJarInfoRequestCookie cookie, DetailsLevel detailsLevel) {
            this.cookie = cookie;
            this.detailsLevel = detailsLevel;
        }

        public String getUrl() {
            return this.cookie.getUrl();
        }

        public String getPath() {
            return this.cookie.getPath();
        }

        public String getCDHash() {
            return this.cookie.getCDHash();
        }

        public DetailsLevel getDetailsLevel() {
            return this.detailsLevel;
        }

        public String toString() {
            return "VmJarInfoRequest: " + String.join((CharSequence)"|", this.getPath(), this.getUrl(), this.getCDHash(), this.detailsLevel.name());
        }

        public static enum DetailsLevel {
            NONE,
            ALL_HASHES;

        }
    }
}

