/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.sysinfo;

import com.azul.crs.javaagent.client.sysinfo.SystemInfoProvider;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

final class LinuxSystemInfoProvider
extends SystemInfoProvider.SystemInfoProviderImpl {
    LinuxSystemInfoProvider() {
    }

    @Override
    protected void initProps() throws IOException, InterruptedException {
        String value;
        String key;
        int colon = 0;
        int idx = 0;
        String packages = "";
        String physicalcpu = "";
        String ncpu = "";
        String frequency = "";
        try (BufferedReader br = new BufferedReader(new FileReader("/proc/cpuinfo"));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) {
                    ++idx;
                    continue;
                }
                if (idx == 0) {
                    if ((colon >= line.length() || line.charAt(colon) != ':') && (colon = line.indexOf(58)) < 0) {
                        colon = 0;
                        continue;
                    }
                    key = "proc.cpuinfo." + line.substring(0, colon).trim();
                    value = line.substring(colon + 1).trim();
                    this.machdepProps.set(key, value);
                    if (!line.startsWith("cpu MHz")) continue;
                    frequency = value;
                    continue;
                }
                if (line.startsWith("processor")) {
                    ncpu = line;
                    continue;
                }
                if (line.startsWith("physical id")) {
                    packages = line;
                    continue;
                }
                if (!line.startsWith("core id")) continue;
                physicalcpu = line;
            }
        }
        br = new BufferedReader(new FileReader("/proc/meminfo"));
        var8_8 = null;
        try {
            while ((line = br.readLine()) != null) {
                colon = line.indexOf(58);
                if (colon < 0) {
                    break;
                }
                key = "proc.meminfo." + line.substring(0, colon).trim();
                value = line.substring(colon + 1).trim();
                this.machdepProps.set(key, value);
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var8_8 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.PROCESSOR_COUNT, 1 + this.parseIntOrZero(ncpu.substring(1 + ncpu.lastIndexOf(32))));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.VENDOR, this.machdepProps.strValue("proc.cpuinfo.vendor_id"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.MODEL_NAME, this.machdepProps.strValue("proc.cpuinfo.model name"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.PHYSICAL_CORE_COUNT, 1 + this.parseIntOrZero(physicalcpu.substring(1 + physicalcpu.lastIndexOf(32))));
    }

    private static String firstLine(String path) {
        try {
            return Files.readAllLines(Paths.get(path, new String[0])).get(0);
        }
        catch (IOException | RuntimeException ex) {
            return "";
        }
    }

    private String cacheSize(String val) {
        try {
            if (val.endsWith("K")) {
                int kb = Integer.parseInt(val.substring(0, val.length() - 1));
                return "" + (kb << 10);
            }
            return val.trim();
        }
        catch (NumberFormatException ex) {
            return "";
        }
    }

    private String frequency(String frequency) {
        try {
            return "" + (Long.parseLong(frequency.replace(".", "").trim()) << 10);
        }
        catch (NumberFormatException ex) {
            return "";
        }
    }
}

