/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.sysinfo;

import com.azul.crs.javaagent.client.sysinfo.SystemInfoProvider;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

final class MacOSXSystemInfoProvider
extends SystemInfoProvider.SystemInfoProviderImpl {
    private static final String SYSCTL_PROGRAM_LOCATION = "/usr/sbin/sysctl";
    private static final String SYSCTL_PROGRAM_FALLBACK_LOCATION = "/sbin/sysctl";

    MacOSXSystemInfoProvider() {
    }

    @Override
    protected void initProps() throws IOException, InterruptedException {
        String sysctlProgram;
        if (this.isSysctlAvailableAndExecutable(SYSCTL_PROGRAM_LOCATION)) {
            sysctlProgram = SYSCTL_PROGRAM_LOCATION;
        } else if (this.isSysctlAvailableAndExecutable(SYSCTL_PROGRAM_FALLBACK_LOCATION)) {
            sysctlProgram = SYSCTL_PROGRAM_FALLBACK_LOCATION;
        } else {
            return;
        }
        ProcessBuilder pb = new ProcessBuilder(sysctlProgram, "-a");
        Process p = pb.start();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line;
            while ((line = br.readLine()) != null) {
                int colon = line.indexOf(58);
                if (colon < 0) continue;
                String key = line.substring(0, colon).trim();
                String value = line.substring(colon + 1).trim();
                this.machdepProps.set("sysctl." + key, value);
            }
        }
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.PROCESSOR_COUNT, this.machdepProps.intValue("sysctl.hw.ncpu"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.VENDOR, this.machdepProps.strValue("sysctl.machdep.cpu.vendor"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.MODEL_NAME, this.machdepProps.strValue("sysctl.machdep.cpu.brand_string"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.PHYSICAL_CORE_COUNT, this.machdepProps.intValue("sysctl.hw.physicalcpu"));
        p.waitFor();
    }

    private boolean isSysctlAvailableAndExecutable(String sysctlLocation) {
        File programFile = new File(sysctlLocation);
        if (!programFile.exists()) {
            Logger.getLogger(MacOSXSystemInfoProvider.class).warning("sysctl is not available under path: %s", sysctlLocation);
            return false;
        }
        if (!programFile.canExecute()) {
            Logger.getLogger(MacOSXSystemInfoProvider.class).warning("sysctl is not executable", new Object[0]);
            return false;
        }
        return true;
    }
}

