/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.util;

import com.azul.crs.javaagent.client.JDKAccessFactory;
import com.azul.crs.javaagent.client.JDKAccessor;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public final class DnsDetect {
    private final List<String> searchlist;
    private final String postfix;

    public DnsDetect(String stackUuid) throws IOException {
        List<String> _searchlist;
        this.postfix = stackUuid == null ? "" : "_" + stackUuid;
        try {
            _searchlist = JDKAccessFactory.getAccessor().getDnsResolverSearchList();
        }
        catch (IllegalAccessError modularityHappens) {
            Logger.getLogger(JDKAccessor.class).error("Cannot access JDK DNS resolver configuration: %s", modularityHappens);
            _searchlist = new LinkedList<String>();
        }
        _searchlist.add(0, "");
        this.searchlist = _searchlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String query(String name, String type) {
        try (InitialDirContext context = new InitialDirContext();){
            context.addToEnvironment("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            Iterator<String> iterator = this.searchlist.iterator();
            while (iterator.hasNext()) {
                String domain = iterator.next();
                String qname = domain.isEmpty() ? name : name + "." + domain;
                try {
                    Object result;
                    Attributes attributes = context.getAttributes(qname, new String[]{type});
                    Attribute attribute = attributes.get(type);
                    if (attribute == null || (result = attribute.get()) == null) continue;
                    String string = result.toString();
                    return string;
                }
                catch (NamingException namingException) {}
            }
            return null;
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return null;
    }

    public String queryEndpoint() throws IOException {
        String result = this.query("az-crs-endpoint" + this.postfix, "CNAME");
        return result == null ? null : (result.endsWith(".") ? result.substring(0, result.length() - 1) : result);
    }

    @Deprecated
    public String queryMailbox() throws IOException {
        return this.query("az-crs-mailbox" + this.postfix, "TXT");
    }

    public String getRecordNamePostfix() {
        return this.postfix;
    }
}

