/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.util;

import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.jars.JarAccess;
import com.azul.crs.javaagent.jar.ZipTools;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicReference;

public class JarAccessUtils {
    private final ZipTools zt;
    private final MessageDigest digest;
    final Logger logger = Logger.getLogger(this.getClass());

    public JarAccessUtils(ZipTools zt, MessageDigest digest) {
        this.zt = zt;
        this.digest = digest;
    }

    public ZipTools.JarShortDigest calculateJarShortDigest(JarAccess jarAccess) {
        try {
            AtomicReference ref = new AtomicReference();
            jarAccess.withInputStream(is -> ref.set(this.zt.getDigest((MessageDigest)this.digest.clone(), jarAccess.getURL(), jarAccess.getJarFile(), (InputStream)is)));
            ZipTools.JarShortDigest jd = (ZipTools.JarShortDigest)ref.get();
            this.logger.trace("jar central directory signature calculated jar=%s, url=%s, digest=%s", jarAccess.getJarFile(), jarAccess.getURL(), jd);
            if (jd == null) {
                return null;
            }
            if (Tweaks.DEBUG_JARLOAD && Tweaks.TRACE_CD_CONTENT) {
                System.out.println(">>> notifyJarLoad url=" + jarAccess.getURL() + "\njar=" + jarAccess.getJarFile() + "\ncentralDirectoryHashString=" + Utils.encodeToStringOrNull(jd.getCentralDirectoryHash()) + "\nmanifestHashString=" + Utils.encodeToStringOrNull(jd.getManifestHash()));
            }
            return jd;
        }
        catch (Exception e) {
            this.logger.trace("Failed to calculate jar digest, due to exception=%s", e);
            throw new RuntimeException(e);
        }
    }
}

