/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.util;

import com.azul.crs.javaagent.client.util.LRU;
import com.azul.crs.javaagent.util.logging.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class LRUCache<E> {
    private static AtomicLong overflowCounter = new AtomicLong();
    private final int sizeLimit;
    private int size;
    private Element<E> head;
    private Element<E> tail;
    private final Map<E, Element<E>> map;

    public static void dump() {
        Logger.getLogger(LRU.class).trace("overflow counter = %d", overflowCounter.get());
    }

    public LRUCache(int sizeLimit) {
        this.sizeLimit = sizeLimit;
        this.map = new HashMap<E, Element<E>>();
    }

    private void moveToTheHead(Element<E> e) {
        Element<E> oldHead = this.head;
        Element<E> oldTail = this.tail;
        Element ePrev = e.prev;
        Element eNext = e.next;
        if (e == this.head) {
            return;
        }
        if (e == this.tail) {
            this.tail = e.prev;
            this.tail.next = this.tail;
        } else {
            e.next.prev = e.prev;
            e.prev.next = e.next;
        }
        e.prev = e;
        e.next = this.head;
        this.head.prev = e;
        this.head = e;
    }

    private void addToTheHead(E data) {
        if (this.size == 0) {
            this.tail = new Element<E>(data);
            this.head = this.tail;
            this.map.put(data, this.head);
            this.head.prev = this.head;
            this.tail.next = this.tail;
            ++this.size;
        } else if (this.size < this.sizeLimit) {
            Element<E> n = new Element<E>(data);
            this.map.put(data, n);
            n.prev = n;
            n.next = this.head;
            this.head.prev = n;
            this.head = n;
            ++this.size;
        } else {
            this.map.put(data, this.tail);
            this.map.remove(this.tail.data);
            this.tail.data = data;
            this.moveToTheHead(this.tail);
            overflowCounter.incrementAndGet();
        }
    }

    public synchronized boolean contains(E data) {
        return this.map.containsKey(data);
    }

    public synchronized void put(E data) {
        Element<E> e = this.map.get(data);
        if (e != null) {
            this.moveToTheHead(e);
        } else {
            this.addToTheHead(data);
        }
    }

    public static final class Element<E> {
        public E data;
        public Element<E> next;
        public Element<E> prev;

        public Element(E data) {
            this.data = data;
            this.next = null;
            this.prev = null;
        }
    }
}

