/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.util;

import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.util.StackTrace;
import com.azul.crs.javaagent.client.util.Utils;
import com.azul.crs.javaagent.util.logging.Logger;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class MyAtomicLongDebuggable {
    private static final Logger logger = Logger.getLogger(MyAtomicLongDebuggable.class);
    private final Map<Object, StackTrace> map = Collections.synchronizedMap(new IdentityHashMap());
    private final AtomicLong delegate = new AtomicLong();
    private final String name;

    public MyAtomicLongDebuggable(String name) {
        this.name = name;
    }

    public Long incrementAndGet(Object key) {
        if (Tweaks.DEBUG_JARLOAD) {
            StackTrace r = StackTrace.get();
            logger.trace("[%s] incrementAndGet: (%s); stack=(%s)", this.name, Utils.toStringWithIdentityHash(key), r);
            this.map.put(key, r);
        }
        return this.delegate.incrementAndGet();
    }

    public Long decrementAndGet(Object key) {
        if (Tweaks.DEBUG_JARLOAD) {
            StackTrace r = StackTrace.get();
            logger.trace("[%s] decrementAndGet: (%s) => (%s), from: (%s)", this.name, Utils.toStringWithIdentityHash(key), this.map.get(key), r);
            if (null == this.map.remove(key)) {
                logger.debug("[%s] requested not scheduled decrementAndGet: (%s) => (%s), from: (%s)", this.name, Utils.toStringWithIdentityHash(key), this.map.get(key), r);
            }
        }
        return this.delegate.decrementAndGet();
    }

    public Long get() {
        return this.delegate.get();
    }

    public void dump() {
        if (!Tweaks.DEBUG_JARLOAD) {
            return;
        }
        logger.trace("[%s] MyAtomicLongDebuggable: dump[size=%d]", this.name, this.map.size());
        for (Object key : new HashSet<Object>(this.map.keySet())) {
            logger.trace("[%s] Not decremented atomic long: (%s) => (%s)", this.name, Utils.toStringWithIdentityHash(key), this.map.get(key));
        }
    }
}

