/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.util;

import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.util.StackTrace;
import com.azul.crs.javaagent.client.util.Utils;
import com.azul.crs.javaagent.util.logging.Logger;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public final class MySetDebuggable<T> {
    private static final Logger logger = Logger.getLogger(MySetDebuggable.class);
    private final Map<T, StackTrace> map = Collections.synchronizedMap(new IdentityHashMap());
    private final Set<T> delegate = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final String name;

    public MySetDebuggable(String name) {
        this.name = name;
    }

    public boolean add(T key) {
        if (Tweaks.DEBUG_JARLOAD) {
            StackTrace r = StackTrace.get();
            logger.trace("[%s] add: (%s); stack=(%s)", this.name, Utils.toStringWithIdentityHash(key), r);
            this.map.put(key, r);
        }
        return this.delegate.add(key);
    }

    public boolean remove(T key) {
        if (Tweaks.DEBUG_JARLOAD) {
            StackTrace r = StackTrace.get();
            logger.trace("[%s] remove: (%s) => (%s), from: (%s)", this.name, Utils.toStringWithIdentityHash(key), this.map.remove(key), r);
        }
        return this.delegate.remove(key);
    }

    public int size() {
        return this.delegate.size();
    }

    public void dump() {
        if (!Tweaks.DEBUG_JARLOAD) {
            return;
        }
        logger.trace("[%s] MySetDebuggable: dump[size=%d]", this.name, this.map.size());
        for (T key : new HashSet<T>(this.map.keySet())) {
            logger.trace("[%s] Not removed atomic long: (%s) => (%s)", this.name, Utils.toStringWithIdentityHash(key), this.map.get(key));
        }
    }
}

