/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.util.async;

import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.util.async.AsyncResourceHandler;
import com.azul.crs.javaagent.util.logging.Logger;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AsyncPipeline<T> {
    private static final Logger logger = Logger.getLogger(AsyncPipeline.class);
    private AsyncResourceHandler<T> first = null;
    private AsyncResourceHandler<T> last = null;

    private AsyncPipeline() {
    }

    public static <T> AsyncPipeline<T> first(Supplier<T> supplier) {
        AsyncPipeline<T> pipeline = new AsyncPipeline<T>();
        AsyncResourceHandler<T> arh = new AsyncResourceHandler<T>(pipeline);
        arh.allocator = holder -> {
            assert (holder.getObject() == null);
            holder.next().accept(supplier.get());
            return holder.next();
        };
        pipeline.first = arh;
        pipeline.last = arh;
        return pipeline;
    }

    public AsyncPipeline<T> next(Function<AsyncPipeline<T>, Function<AsyncResourceHandler<T>, AsyncResourceHandler<T>>> resourceAllocator) {
        AsyncResourceHandler arh = new AsyncResourceHandler(this);
        AsyncResourceHandler<T> prev = this.last;
        arh.allocator = resourceAllocator.apply(this);
        this.last = arh;
        arh.outer = prev;
        prev.inner = arh;
        return this;
    }

    public AsyncPipeline<T> step(Consumer<AsyncResourceHandler<T>> simpleStep) {
        return this.next(p -> h -> {
            simpleStep.accept((AsyncResourceHandler)h);
            if (Tweaks.DEBUG_ASYNC_UTILS && h.errorHandler != null) {
                Consumer<Exception> heh = h.errorHandler;
                h.errorHandler = e -> {
                    logger.trace("errorHandler.accept(%s) context (%s)", e, h.getObject());
                    heh.accept((Exception)e);
                };
            }
            h.next().accept(h.getObject());
            return h.next();
        });
    }

    public void start() {
        this.next(pipeline -> holder -> {
            holder.finalize();
            return null;
        });
        this.first.accept(null);
    }

    public void start(ExecutorService executor) {
        this.next(pipeline -> holder -> {
            holder.finalize();
            return null;
        });
        executor.submit(() -> this.first.accept(null));
    }

    public static <T> Function<AsyncResourceHandler<T>, AsyncResourceHandler<T>> notNull(AsyncPipeline<T> context) {
        return holder -> {
            if (holder.getObject() == null) {
                holder.finalize();
                return null;
            }
            holder.next().accept(holder.getObject());
            return holder.next();
        };
    }
}

