/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.utils;

import java.util.ArrayList;

public class VersionHelper {
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final int JAVA_MAJOR_VERSION;
    public static final int JAVA_MINOR_VERSION;
    public static final int JAVA_SUB_VERSION;
    public static final boolean JAVA_IS_EA_VERSION;
    public static final boolean JAVA_IS_BETA_VERSION;

    public static int getClassFileVersion(byte[] c) {
        if (c.length < 8) {
            throw new RuntimeException("bad classfile: size(" + c.length + ") < 8");
        }
        long magic = (c[0] & 0xFF) << 24 | (c[1] & 0xFF) << 16 | (c[2] & 0xFF) << 8 | c[3] & 0xFF;
        if (magic != -889275714L) {
            throw new RuntimeException("bad classfile: magic " + String.format("0x%X", magic) + " != 0xCAFEBABE");
        }
        int minor = (c[4] & 0xFF) << 8 | c[5] & 0xFF;
        int major = (c[6] & 0xFF) << 8 | c[7] & 0xFF;
        return major;
    }

    public static int normalizeClassVersion(int version) {
        if (version == 196653) {
            return 45;
        }
        return version;
    }

    static {
        int javaMajorVersion = 0;
        int javaMinorVersion = 0;
        int javaSubVersion = 0;
        ArrayList<Integer> versionParts = new ArrayList<Integer>();
        if (JAVA_VERSION != null) {
            for (String versionPart : JAVA_VERSION.split("[^0-9]+")) {
                try {
                    versionParts.add(Integer.parseInt(versionPart));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!versionParts.isEmpty() && (Integer)versionParts.get(0) == 1) {
                versionParts.remove(0);
            }
            if (versionParts.isEmpty()) {
                throw new RuntimeException("Could not determine Java version: " + JAVA_VERSION);
            }
            javaMajorVersion = (Integer)versionParts.get(0);
            if (versionParts.size() > 1) {
                javaMinorVersion = (Integer)versionParts.get(1);
            }
            if (versionParts.size() > 2) {
                javaSubVersion = (Integer)versionParts.get(2);
            }
        }
        JAVA_MAJOR_VERSION = javaMajorVersion;
        JAVA_MINOR_VERSION = javaMinorVersion;
        JAVA_SUB_VERSION = javaSubVersion;
        JAVA_IS_EA_VERSION = JAVA_VERSION != null && JAVA_VERSION.endsWith("-ea");
        JAVA_IS_BETA_VERSION = JAVA_VERSION != null && JAVA_VERSION.endsWith("-beta");
    }
}

