/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.datafilter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SensitiveDataFilterFactory {
    private static final String INV_ENV_ALLOW = "inventory.environment.allow";
    private static final String INV_ENV_DENY = "inventory.environment.deny";
    private static final String INV_SYS_PROPS_ALLOW = "inventory.system.properties.allow";
    private static final String INV_SYS_PROPS_DENY = "inventory.system.properties.deny";
    private final Properties props = new Properties();

    public SensitiveDataFilterFactory() {
        String propertiesFileName = "data-filter.properties";
        try (InputStream is = SensitiveDataFilterFactory.class.getResourceAsStream("data-filter.properties");){
            if (is == null) {
                throw new IllegalStateException("File not found: data-filter.properties");
            }
            this.props.load(is);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public Predicate<String> createSystemPropertyFilter() {
        return new PropertiesFilter((String)this.props.get(INV_SYS_PROPS_ALLOW), (String)this.props.get(INV_SYS_PROPS_DENY));
    }

    public Predicate<String> createEnvironmentFilter() {
        return new PropertiesFilter((String)this.props.get(INV_ENV_ALLOW), (String)this.props.get(INV_ENV_DENY));
    }

    private static class PropertiesFilter
    implements Predicate<String> {
        private final Set<String> allow;
        private final Set<String> deny;

        private PropertiesFilter(String allowList, String denyList) {
            this.allow = Arrays.stream(allowList.split("\\|")).map(String::trim).collect(Collectors.toSet());
            this.deny = Arrays.stream(denyList.split("\\|")).map(String::trim).collect(Collectors.toSet());
        }

        @Override
        public boolean test(String key) {
            return this.allow.contains(key) && !this.deny.contains(key);
        }
    }
}

