/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.digest;

import com.azul.crs.javaagent.digest.ConstantPool;
import com.azul.crs.javaagent.digest.CountingInputStream;
import com.azul.crs.javaagent.digest.Digest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;

final class ByteCodeProcessor {
    private final ByteBuffer buffer = ByteBuffer.allocate(20);
    private final ConstantPoolMapper cp;
    private boolean wide = false;
    private static final T[] NONE = new T[0];

    ByteCodeProcessor(ConstantPool constantPool) {
        this.cp = new ConstantPoolMapper(constantPool);
    }

    void processMethodByteCode(CountingInputStream bytes, Digest hash) throws IOException {
        OpCode opcode = OpCode.getOpCode(bytes.readUnsignedByte());
        this.buffer.clear();
        this.buffer.putShort((short)opcode.replaceWith.ordinal());
        if (opcode == OpCode.TABLESWITCH || opcode == OpCode.LOOKUPSWITCH) {
            int remainder = bytes.position() % 4;
            int no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
            for (int i = 0; i < no_pad_bytes; ++i) {
                byte b = bytes.readByte();
                if (b == 0) continue;
                System.err.println("Warning: Padding byte != 0 in " + (Object)((Object)opcode) + ":" + b);
            }
            bytes.readInt();
        }
        switch (opcode.switchCase) {
            case TABLESWITCH: {
                int i;
                int low = bytes.readInt();
                int high = bytes.readInt();
                this.buffer.putInt(low);
                this.buffer.putInt(high);
                for (i = 0; i < high - low + 1 << 2; ++i) {
                    bytes.read();
                }
                break;
            }
            case LOOKUPSWITCH: {
                int i;
                int npairs = bytes.readInt();
                this.buffer.putInt(npairs);
                for (i = 0; i < npairs << 3; ++i) {
                    bytes.read();
                }
                break;
            }
            case DISCARD_SHORT_IMMEDIATE: {
                bytes.readShort();
                break;
            }
            case DISCARD_INT_IMMEDIATE: {
                bytes.readInt();
                break;
            }
            case DISCARD_IMMEDIATE_REF: {
                if (this.wide) {
                    bytes.readUnsignedShort();
                    this.wide = false;
                    break;
                }
                bytes.readUnsignedByte();
                break;
            }
            case WIDE: {
                this.wide = true;
                break;
            }
            case NEWARRAY: {
                this.buffer.put(bytes.readByte());
                break;
            }
            case CONSTANT_FIELDREF: {
                int index = bytes.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(index));
                break;
            }
            case CONSTANT_CLASS: {
                int index = bytes.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(index));
                break;
            }
            case INVOKESPECIAL: {
                int index = bytes.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(index));
                break;
            }
            case INVOKEVIRTUAL: {
                int index = bytes.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(index));
                break;
            }
            case INVOKEINTERFACE: {
                int index = bytes.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(index));
                this.buffer.putInt(bytes.readUnsignedByte());
                this.buffer.putInt(bytes.readUnsignedByte());
                break;
            }
            case INVOKEDYNAMIC: {
                int index = bytes.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(index));
                this.buffer.putInt(bytes.readUnsignedByte());
                this.buffer.putInt(bytes.readUnsignedByte());
                break;
            }
            case LDC_W: {
                int index = bytes.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(index));
                break;
            }
            case LDC: {
                int index = bytes.readUnsignedByte();
                this.buffer.putInt(this.cp.mapIndex(index));
                break;
            }
            case ANEWARRAY: {
                int index = bytes.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(index));
                break;
            }
            case MULTIANEWARRAY: {
                int index = bytes.readUnsignedShort();
                this.buffer.putInt(bytes.readUnsignedByte());
                this.buffer.putInt(this.cp.mapIndex(index));
                break;
            }
            case IINC: {
                short constant;
                if (this.wide) {
                    bytes.readUnsignedShort();
                    constant = bytes.readShort();
                    this.wide = false;
                } else {
                    bytes.readUnsignedByte();
                    constant = bytes.readByte();
                }
                this.buffer.putInt(constant);
                break;
            }
            case NO_ARG: {
                break;
            }
            default: {
                block29: for (T operand : opcode.operandTypes) {
                    switch (operand) {
                        case BYTE: {
                            this.buffer.put(bytes.readByte());
                            continue block29;
                        }
                        case SHORT: {
                            this.buffer.putShort(bytes.readShort());
                            continue block29;
                        }
                        case INT: {
                            this.buffer.putInt(bytes.readInt());
                            continue block29;
                        }
                        default: {
                            throw new IllegalStateException("Unreachable default case reached!");
                        }
                    }
                }
            }
        }
        hash.update(this.buffer);
    }

    private static final class ConstantPoolMapper
    extends HashMap<Integer, Integer> {
        private final ConstantPool cp;
        private int counter = 0;

        public ConstantPoolMapper(ConstantPool cp) {
            this.cp = cp;
        }

        public int mapIndex(int index) {
            index = this.cp.dedup(index);
            return this.computeIfAbsent(index, k -> this.counter++);
        }
    }

    static enum OpCode {
        NOP,
        ACONST_NULL,
        ICONST_M1,
        ICONST_0,
        ICONST_1,
        ICONST_2,
        ICONST_3,
        ICONST_4,
        ICONST_5,
        LCONST_0,
        LCONST_1,
        FCONST_0,
        FCONST_1,
        FCONST_2,
        DCONST_0,
        DCONST_1,
        BIPUSH(T.BYTE),
        SIPUSH(T.SHORT),
        LDC(OpCodeCase.LDC, T.BYTE),
        LDC_W(LDC, OpCodeCase.LDC_W, T.SHORT),
        LDC2_W(LDC, OpCodeCase.LDC_W, T.SHORT),
        ILOAD(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        LLOAD(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        FLOAD(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        DLOAD(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        ALOAD(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        ILOAD_0(ILOAD, OpCodeCase.NO_ARG),
        ILOAD_1(ILOAD, OpCodeCase.NO_ARG),
        ILOAD_2(ILOAD, OpCodeCase.NO_ARG),
        ILOAD_3(ILOAD, OpCodeCase.NO_ARG),
        LLOAD_0(LLOAD, OpCodeCase.NO_ARG),
        LLOAD_1(LLOAD, OpCodeCase.NO_ARG),
        LLOAD_2(LLOAD, OpCodeCase.NO_ARG),
        LLOAD_3(LLOAD, OpCodeCase.NO_ARG),
        FLOAD_0(FLOAD, OpCodeCase.NO_ARG),
        FLOAD_1(FLOAD, OpCodeCase.NO_ARG),
        FLOAD_2(FLOAD, OpCodeCase.NO_ARG),
        FLOAD_3(FLOAD, OpCodeCase.NO_ARG),
        DLOAD_0(DLOAD, OpCodeCase.NO_ARG),
        DLOAD_1(DLOAD, OpCodeCase.NO_ARG),
        DLOAD_2(DLOAD, OpCodeCase.NO_ARG),
        DLOAD_3(DLOAD, OpCodeCase.NO_ARG),
        ALOAD_0(ALOAD, OpCodeCase.NO_ARG),
        ALOAD_1(ALOAD, OpCodeCase.NO_ARG),
        ALOAD_2(ALOAD, OpCodeCase.NO_ARG),
        ALOAD_3(ALOAD, OpCodeCase.NO_ARG),
        IALOAD,
        LALOAD,
        FALOAD,
        DALOAD,
        AALOAD,
        BALOAD,
        CALOAD,
        SALOAD,
        ISTORE(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        LSTORE(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        FSTORE(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        DSTORE(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        ASTORE(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        ISTORE_0(ISTORE, OpCodeCase.NO_ARG),
        ISTORE_1(ISTORE, OpCodeCase.NO_ARG),
        ISTORE_2(ISTORE, OpCodeCase.NO_ARG),
        ISTORE_3(ISTORE, OpCodeCase.NO_ARG),
        LSTORE_0(LSTORE, OpCodeCase.NO_ARG),
        LSTORE_1(LSTORE, OpCodeCase.NO_ARG),
        LSTORE_2(LSTORE, OpCodeCase.NO_ARG),
        LSTORE_3(LSTORE, OpCodeCase.NO_ARG),
        FSTORE_0(FSTORE, OpCodeCase.NO_ARG),
        FSTORE_1(FSTORE, OpCodeCase.NO_ARG),
        FSTORE_2(FSTORE, OpCodeCase.NO_ARG),
        FSTORE_3(FSTORE, OpCodeCase.NO_ARG),
        DSTORE_0(DSTORE, OpCodeCase.NO_ARG),
        DSTORE_1(DSTORE, OpCodeCase.NO_ARG),
        DSTORE_2(DSTORE, OpCodeCase.NO_ARG),
        DSTORE_3(DSTORE, OpCodeCase.NO_ARG),
        ASTORE_0(ASTORE, OpCodeCase.NO_ARG),
        ASTORE_1(ASTORE, OpCodeCase.NO_ARG),
        ASTORE_2(ASTORE, OpCodeCase.NO_ARG),
        ASTORE_3(ASTORE, OpCodeCase.NO_ARG),
        IASTORE,
        LASTORE,
        FASTORE,
        DASTORE,
        AASTORE,
        BASTORE,
        CASTORE,
        SASTORE,
        POP,
        POP2,
        DUP,
        DUP_X1,
        DUP_X2,
        DUP2,
        DUP2_X1,
        DUP2_X2,
        SWAP,
        IADD,
        LADD,
        FADD,
        DADD,
        ISUB,
        LSUB,
        FSUB,
        DSUB,
        IMUL,
        LMUL,
        FMUL,
        DMUL,
        IDIV,
        LDIV,
        FDIV,
        DDIV,
        IREM,
        LREM,
        FREM,
        DREM,
        INEG,
        LNEG,
        FNEG,
        DNEG,
        ISHL,
        LSHL,
        ISHR,
        LSHR,
        IUSHR,
        LUSHR,
        IAND,
        LAND,
        IOR,
        LOR,
        IXOR,
        LXOR,
        IINC(OpCodeCase.IINC, T.BYTE, T.BYTE),
        I2L,
        I2F,
        I2D,
        L2I,
        L2F,
        L2D,
        F2I,
        F2L,
        F2D,
        D2I,
        D2L,
        D2F,
        I2B,
        I2C,
        I2S,
        LCMP,
        FCMPL,
        FCMPG,
        DCMPL,
        DCMPG,
        IFEQ(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IFNE(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IFLT(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IFGE(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IFGT(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IFLE(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ICMPEQ(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ICMPNE(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ICMPLT(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ICMPGE(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ICMPGT(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ICMPLE(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ACMPEQ(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ACMPNE(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        GOTO(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        JSR(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        RET(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        TABLESWITCH(OpCodeCase.TABLESWITCH),
        LOOKUPSWITCH(OpCodeCase.LOOKUPSWITCH),
        IRETURN,
        LRETURN,
        FRETURN,
        DRETURN,
        ARETURN,
        RETURN,
        GETSTATIC(OpCodeCase.CONSTANT_FIELDREF, T.SHORT),
        PUTSTATIC(OpCodeCase.CONSTANT_FIELDREF, T.SHORT),
        GETFIELD(OpCodeCase.CONSTANT_FIELDREF, T.SHORT),
        PUTFIELD(OpCodeCase.CONSTANT_FIELDREF, T.SHORT),
        INVOKEVIRTUAL(OpCodeCase.INVOKEVIRTUAL, T.SHORT),
        INVOKESPECIAL(OpCodeCase.INVOKESPECIAL, T.SHORT),
        INVOKESTATIC(OpCodeCase.INVOKESPECIAL, T.SHORT),
        INVOKEINTERFACE(OpCodeCase.INVOKEINTERFACE, T.SHORT, T.BYTE, T.BYTE),
        INVOKEDYNAMIC(OpCodeCase.INVOKEDYNAMIC, T.SHORT, T.BYTE, T.BYTE),
        NEW(OpCodeCase.CONSTANT_CLASS, T.SHORT),
        NEWARRAY(OpCodeCase.NEWARRAY, T.BYTE),
        ANEWARRAY(OpCodeCase.ANEWARRAY, T.SHORT),
        ARRAYLENGTH,
        ATHROW,
        CHECKCAST(OpCodeCase.CONSTANT_CLASS, T.SHORT),
        INSTANCEOF(OpCodeCase.CONSTANT_CLASS, T.SHORT),
        MONITORENTER,
        MONITOREXIT,
        WIDE(OpCodeCase.WIDE),
        MULTIANEWARRAY(OpCodeCase.MULTIANEWARRAY, T.SHORT, T.BYTE),
        IFNULL(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IFNONNULL(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        GOTO_W(GOTO, OpCodeCase.DISCARD_INT_IMMEDIATE, T.INT),
        JSR_W(JSR, OpCodeCase.DISCARD_INT_IMMEDIATE, T.INT),
        BREAKPOINT,
        LDC_QUICK,
        LDC_W_QUICK(LDC_QUICK),
        LDC2_W_QUICK(LDC_QUICK),
        GETFIELD_QUICK,
        PUTFIELD_QUICK,
        GETFIELD2_QUICK,
        PUTFIELD2_QUICK,
        GETSTATIC_QUICK,
        PUTSTATIC_QUICK,
        GETSTATIC2_QUICK,
        PUTSTATIC2_QUICK,
        INVOKEVIRTUAL_QUICK,
        INVOKENONVIRTUAL_QUICK,
        INVOKESUPER_QUICK,
        INVOKESTATIC_QUICK,
        INVOKEINTERFACE_QUICK,
        INVOKEVIRTUALOBJECT_QUICK,
        RESERVED_220,
        NEW_QUICK,
        ANEWARRAY_QUICK,
        MULTIANEWARRAY_QUICK,
        CHECKCAST_QUICK,
        INSTANCEOF_QUICK,
        INVOKEVIRTUAL_QUICK_W(INVOKEVIRTUAL_QUICK),
        GETFIELD_QUICK_W(GETFIELD_QUICK),
        PUTFIELD_QUICK_W(PUTFIELD_QUICK),
        RESERVED_229,
        RESERVED_230,
        RESERVED_231,
        RESERVED_232,
        RESERVED_233,
        RESERVED_234,
        RESERVED_235,
        RESERVED_236,
        RESERVED_237,
        RESERVED_238,
        RESERVED_239,
        RESERVED_240,
        RESERVED_241,
        RESERVED_242,
        RESERVED_243,
        RESERVED_244,
        RESERVED_245,
        RESERVED_246,
        RESERVED_247,
        RESERVED_248,
        RESERVED_249,
        RESERVED_250,
        RESERVED_251,
        RESERVED_252,
        RESERVED_253,
        IMPDEP1,
        IMPDEP2;

        final OpCode replaceWith;
        final OpCodeCase switchCase;
        final T[] operandTypes;
        private static final OpCode[] opCodes;

        static OpCode getOpCode(int i) {
            return opCodes[i];
        }

        private OpCode() {
            this.replaceWith = this;
            this.switchCase = OpCodeCase.SWITCH_DEFAULT;
            this.operandTypes = NONE;
        }

        private OpCode(T ... operands) {
            this.replaceWith = this;
            this.switchCase = OpCodeCase.SWITCH_DEFAULT;
            this.operandTypes = operands;
        }

        private OpCode(OpCode replaceWith) {
            this.replaceWith = replaceWith;
            this.switchCase = OpCodeCase.SWITCH_DEFAULT;
            this.operandTypes = NONE;
        }

        private OpCode(OpCodeCase switchCase) {
            this.replaceWith = this;
            this.switchCase = switchCase;
            this.operandTypes = NONE;
        }

        private OpCode(OpCodeCase switchCase, T ... operandTypes) {
            this.replaceWith = this;
            this.switchCase = switchCase;
            this.operandTypes = operandTypes;
        }

        private OpCode(OpCode replaceWith, OpCodeCase switchCase) {
            this.replaceWith = replaceWith;
            this.switchCase = switchCase;
            this.operandTypes = NONE;
        }

        private OpCode(OpCode replaceWith, OpCodeCase switchCase, T ... operandTypes) {
            this.replaceWith = replaceWith;
            this.switchCase = switchCase;
            this.operandTypes = operandTypes;
        }

        static {
            opCodes = OpCode.values();
        }
    }

    private static enum T {
        BYTE,
        SHORT,
        INT;

    }

    private static enum OpCodeCase {
        SWITCH_DEFAULT,
        TABLESWITCH,
        LOOKUPSWITCH,
        DISCARD_SHORT_IMMEDIATE,
        DISCARD_INT_IMMEDIATE,
        DISCARD_IMMEDIATE_REF,
        WIDE,
        NEWARRAY,
        CONSTANT_FIELDREF,
        CONSTANT_CLASS,
        INVOKESPECIAL,
        INVOKEVIRTUAL,
        INVOKEINTERFACE,
        INVOKEDYNAMIC,
        LDC_W,
        LDC,
        ANEWARRAY,
        MULTIANEWARRAY,
        IINC,
        NO_ARG;

    }
}

