/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.digest;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

final class ConstantPool {
    private final Map<Integer, Integer> dedup;
    private final ConstantPoolEntry[] entries;
    private static ThreadLocal<Map<String, Integer>> tmpRef = ThreadLocal.withInitial(HashMap::new);
    private static ThreadLocal<StringBuilder> sbRef = ThreadLocal.withInitial(StringBuilder::new);

    private ConstantPool(ConstantPoolEntry[] entries) {
        this.entries = entries;
        this.dedup = new HashMap<Integer, Integer>();
        Map<String, Integer> tmp = tmpRef.get();
        tmp.clear();
        StringBuilder sb = sbRef.get();
        for (int i = 0; i < entries.length; ++i) {
            ConstantPoolEntry entry = entries[i];
            if (entry == null) continue;
            sb.setLength(0);
            entry.toString(sb, entries);
            String s = sb.toString();
            Integer idx = tmp.get(s);
            if (idx != null) {
                this.dedup.put(i, idx);
                continue;
            }
            tmp.put(s, i);
        }
    }

    public static ConstantPool readConstantPool(DataInputStream r) throws IOException {
        ConstantType type;
        ConstantPoolEntry[] cp = new ConstantPoolEntry[r.readUnsignedShort()];
        for (int slot = 1; slot < cp.length; slot += type.slots()) {
            ConstantPoolEntry cpInfo;
            type = ConstantType.values()[r.readByte()];
            if (type.supplier == null) {
                return null;
            }
            cp[slot] = cpInfo = ((ConstantPoolEntry)type.supplier.get()).read(r);
        }
        return new ConstantPool(cp);
    }

    int dedup(int index) {
        return this.dedup.getOrDefault(index, index);
    }

    public String getStringConstant(int index) {
        return ((ConstantUtf8Entry)this.entries[index]).str;
    }

    public String getClassShortName(int index) {
        if (index > 0) {
            int name_idx = ((ConstantClassEntry)this.entries[index]).name;
            String str = ((ConstantUtf8Entry)this.entries[name_idx]).str;
            int idx = str.lastIndexOf(47);
            return idx < 0 ? str : str.substring(idx + 1);
        }
        return "";
    }

    private static class ConstantPackageEntry
    extends ConstantNameEntry {
        private ConstantPackageEntry() {
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('f');
            cp[this.name_and_type_index].toString(sb, cp);
        }
    }

    private static class ConstantModuleEntry
    extends ConstantNameEntry {
        private ConstantModuleEntry() {
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('e');
            cp[this.name_and_type_index].toString(sb, cp);
        }
    }

    private static abstract class ConstantNameEntry
    extends ConstantPoolEntry {
        protected int name_and_type_index;

        private ConstantNameEntry() {
        }

        @Override
        protected void readImpl(DataInputStream r) throws IOException {
            this.name_and_type_index = r.readUnsignedShort();
        }
    }

    private static class ConstantInvokeDynamicEntry
    extends ConstantPoolEntry {
        int bootstrap_method_attr_index;
        int name_and_type_index;

        private ConstantInvokeDynamicEntry() {
        }

        @Override
        protected void readImpl(DataInputStream r) throws IOException {
            this.bootstrap_method_attr_index = r.readUnsignedShort();
            this.name_and_type_index = r.readUnsignedShort();
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('d');
            sb.append(this.bootstrap_method_attr_index);
            cp[this.name_and_type_index].toString(sb, cp);
        }
    }

    private static class ConstantMethodTypeEntry
    extends ConstantPoolEntry {
        private int descriptorIndex;

        private ConstantMethodTypeEntry() {
        }

        @Override
        protected void readImpl(DataInputStream r) throws IOException {
            this.descriptorIndex = r.readUnsignedShort();
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('c');
            cp[this.descriptorIndex].toString(sb, cp);
        }
    }

    private static class ConstantMethodHandleEntry
    extends ConstantPoolEntry {
        private MethodHandleKind reference_kind;
        private int reference_index;

        private ConstantMethodHandleEntry() {
        }

        @Override
        protected void readImpl(DataInputStream r) throws IOException {
            this.reference_kind = MethodHandleKind.values()[r.readByte()];
            this.reference_index = r.readUnsignedShort();
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('b');
            sb.append((Object)this.reference_kind);
            cp[this.reference_index].toString(sb, cp);
        }
    }

    private static class ConstantUtf8Entry
    extends ConstantPoolEntry {
        private String str;

        private ConstantUtf8Entry() {
        }

        @Override
        protected void readImpl(DataInputStream r) throws IOException {
            int size = r.readUnsignedShort();
            byte[] bytes = new byte[size];
            for (int read = 0; read != size; read += r.read(bytes, read, size - read)) {
            }
            this.str = new String(bytes);
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('a');
            sb.append(this.str);
        }
    }

    private static class ConstantNameAndTypeEntry
    extends ConstantPoolEntry {
        private int name_index;
        private int descriptor_index;

        private ConstantNameAndTypeEntry() {
        }

        @Override
        protected void readImpl(DataInputStream r) throws IOException {
            this.name_index = r.readUnsignedShort();
            this.descriptor_index = r.readUnsignedShort();
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('9');
            cp[this.name_index].toString(sb, cp);
            cp[this.descriptor_index].toString(sb, cp);
        }
    }

    private static class ConstantDoubleEntry
    extends ConstantPoolEntry {
        private double value;

        private ConstantDoubleEntry() {
        }

        @Override
        protected void readImpl(DataInputStream r) throws IOException {
            this.value = r.readDouble();
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('8');
            sb.append(this.value);
        }
    }

    private static class ConstantLongEntry
    extends ConstantPoolEntry {
        private long value;

        private ConstantLongEntry() {
        }

        @Override
        protected void readImpl(DataInputStream r) throws IOException {
            this.value = r.readLong();
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('7');
            sb.append(this.value);
        }
    }

    private static class ConstantFloatEntry
    extends ConstantPoolEntry {
        private float value;

        private ConstantFloatEntry() {
        }

        @Override
        protected void readImpl(DataInputStream r) throws IOException {
            this.value = r.readFloat();
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('6');
            sb.append(this.value);
        }
    }

    private static class ConstantIntegerEntry
    extends ConstantPoolEntry {
        private int value;

        private ConstantIntegerEntry() {
        }

        @Override
        protected void readImpl(DataInputStream r) throws IOException {
            this.value = r.readInt();
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('5');
            sb.append(this.value);
        }
    }

    private static class ConstantStringEntry
    extends ConstantPoolEntry {
        private int string_index;

        private ConstantStringEntry() {
        }

        @Override
        protected void readImpl(DataInputStream r) throws IOException {
            this.string_index = r.readUnsignedShort();
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('4');
            cp[this.string_index].toString(sb, cp);
        }
    }

    private static class ConstantInterfaceMethodRefEntry
    extends ConstantRefEntry {
        private ConstantInterfaceMethodRefEntry() {
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('3');
            cp[this.class_index].toString(sb, cp);
            cp[this.name_and_type_index].toString(sb, cp);
        }
    }

    private static class ConstantMethodRefEntry
    extends ConstantRefEntry {
        private ConstantMethodRefEntry() {
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('2');
            cp[this.class_index].toString(sb, cp);
            cp[this.name_and_type_index].toString(sb, cp);
        }
    }

    private static class ConstantFieldRefEntry
    extends ConstantRefEntry {
        private ConstantFieldRefEntry() {
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('1');
            cp[this.class_index].toString(sb, cp);
            cp[this.name_and_type_index].toString(sb, cp);
        }
    }

    private static abstract class ConstantRefEntry
    extends ConstantPoolEntry {
        protected int class_index;
        protected int name_and_type_index;

        private ConstantRefEntry() {
        }

        @Override
        protected void readImpl(DataInputStream r) throws IOException {
            this.class_index = r.readUnsignedShort();
            this.name_and_type_index = r.readUnsignedShort();
        }
    }

    private static class ConstantClassEntry
    extends ConstantPoolEntry {
        private int name;

        private ConstantClassEntry() {
        }

        @Override
        protected void readImpl(DataInputStream r) throws IOException {
            this.name = r.readUnsignedShort();
        }

        @Override
        protected void toStringImpl(StringBuilder sb, ConstantPoolEntry[] cp) {
            sb.append('0');
            cp[this.name].toString(sb, cp);
        }
    }

    private static abstract class ConstantPoolEntry {
        private ConstantPoolEntry() {
        }

        public ConstantPoolEntry read(DataInputStream r) throws IOException {
            this.readImpl(r);
            return this;
        }

        protected abstract void readImpl(DataInputStream var1) throws IOException;

        protected final void toString(StringBuilder sb, ConstantPoolEntry[] cp) {
            this.toStringImpl(sb, cp);
        }

        protected abstract void toStringImpl(StringBuilder var1, ConstantPoolEntry[] var2);
    }

    private static enum MethodHandleKind {
        RESERVED_0,
        GET_FIELD,
        GET_STATIC,
        PUT_FIELD,
        PUT_STATIC,
        INVOKE_VIRTUAL,
        INVOKE_STATIC,
        INVOKE_SPECIAL,
        NEW_INVOKE_SPECIAL,
        INVOKE_INTERFACE;

    }

    private static enum ConstantType {
        RESERVED_0,
        UTF8(() -> new ConstantUtf8Entry()),
        RESERVED_2,
        INTEGER(() -> new ConstantIntegerEntry()),
        FLOAT(() -> new ConstantFloatEntry()),
        LONG(() -> new ConstantLongEntry()),
        DOUBLE(() -> new ConstantDoubleEntry()),
        CLASS(() -> new ConstantClassEntry()),
        STRING(() -> new ConstantStringEntry()),
        FIELDREF(() -> new ConstantFieldRefEntry()),
        METHODREF(() -> new ConstantMethodRefEntry()),
        INTERFACEMETHODREF(() -> new ConstantInterfaceMethodRefEntry()),
        NAMEANDTYPE(() -> new ConstantNameAndTypeEntry()),
        RESERVED_13,
        RESERVED_14,
        METHODHANDLE(() -> new ConstantMethodHandleEntry()),
        METHODTYPE(() -> new ConstantMethodTypeEntry()),
        RESERVED_17,
        INVOKEDYNAMIC(() -> new ConstantInvokeDynamicEntry()),
        MODULE(() -> new ConstantModuleEntry()),
        PACKAGE(() -> new ConstantPackageEntry());

        private final Supplier<ConstantPoolEntry> supplier;

        private ConstantType() {
            this(null);
        }

        private ConstantType(Supplier<ConstantPoolEntry> supplier) {
            this.supplier = supplier;
        }

        public int slots() {
            return this == LONG || this == DOUBLE ? 2 : 1;
        }
    }
}

