/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.digest;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class CountingInputStream
extends DataInputStream {
    private final CountingStream stream;

    public CountingInputStream(InputStream is) {
        super(new CountingStream(is));
        this.stream = (CountingStream)this.in;
    }

    public int position() {
        return this.stream.position;
    }

    private static class CountingStream
    extends FilterInputStream {
        private int position = 0;

        public CountingStream(InputStream is) {
            super(is);
        }

        private int updatePosition(int n) {
            if (n != -1) {
                this.position += n;
            }
            return n;
        }

        @Override
        public int read() throws IOException {
            int ret = super.read();
            if (ret != -1) {
                ++this.position;
            }
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.updatePosition(super.read(b, off, len));
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.updatePosition(super.read(b));
        }
    }
}

