/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.digest;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Digest {
    private static final MessageDigest DIGEST = Digest.initDigest("SHA-256");
    private static final char[] DIGITS = "0123456789abcdef".toCharArray();
    private static final int BLOCK_SIZE = 64;
    private final MessageDigest md;
    private final ByteBuffer mdbuffer = ByteBuffer.wrap(new byte[64]);

    private Digest(MessageDigest md) {
        this.md = md;
    }

    public static Digest get() {
        return new Digest(Digest.cloneDigest(DIGEST));
    }

    private static MessageDigest initDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(Digest.class.getName()).log(Level.SEVERE, null, ex);
            System.exit(0);
            return null;
        }
    }

    private static MessageDigest cloneDigest(MessageDigest from) {
        try {
            return (MessageDigest)from.clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(Digest.class.getName()).log(Level.SEVERE, null, ex);
            System.exit(0);
            return null;
        }
    }

    private void update(byte[] data, int pos, int length) {
        int rem = this.mdbuffer.remaining();
        if (length > rem) {
            this.mdbuffer.put(data, pos, rem);
            this.md.update(this.mdbuffer.array(), 0, 64);
            pos += rem;
            length -= rem;
            this.mdbuffer.rewind();
        }
        while (length >= 64) {
            this.md.update(data, pos, 64);
            pos += 64;
            length -= 64;
        }
        if (length > 0) {
            this.mdbuffer.put(data, pos, length);
        }
    }

    private void flushMDBuffer() {
        int pos = this.mdbuffer.position();
        if (pos > 0) {
            this.md.update(this.mdbuffer.array(), 0, pos);
            this.mdbuffer.rewind();
        }
    }

    void update(ByteBuffer data) {
        this.update(data.array(), 0, data.position());
    }

    void update(short data) {
        if (this.mdbuffer.remaining() < 2) {
            this.flushMDBuffer();
        }
        this.mdbuffer.put((byte)(data & 0xFF));
        this.mdbuffer.put((byte)(data >> 8 & 0xFF));
    }

    void update(String data) {
        this.update(data.getBytes(), 0, data.length());
    }

    private static String encode(byte[] bytes) {
        int strlen = bytes.length << 1;
        char[] str = new char[strlen];
        int i = 0;
        int j = 0;
        while (i < strlen) {
            byte b = bytes[j];
            str[i++] = DIGITS[b >> 4 & 0xF];
            str[i++] = DIGITS[b & 0xF];
            ++j;
        }
        return new String(str);
    }

    public MessageDigest getMessageDigest() {
        return this.md;
    }

    public String asHexString() {
        this.flushMDBuffer();
        return Digest.encode(this.md.digest());
    }
}

