/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.digest;

import com.azul.crs.javaagent.digest.ByteCodeProcessor;
import com.azul.crs.javaagent.digest.ConstantPool;
import com.azul.crs.javaagent.digest.CountingInputStream;
import com.azul.crs.javaagent.digest.Digest;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;

public final class ShadedClassHashCalculator {
    private ShadedClassHashCalculator() {
    }

    public static void updateHash(InputStream in, Digest hash) throws IllegalAccessException, IOException {
        DataInputStream is = new DataInputStream(in);
        int magic = is.readInt();
        if (magic != -889275714) {
            throw new IllegalAccessException("Error reading class - not valid type");
        }
        hash.update(is.readShort());
        hash.update(is.readShort());
        ConstantPool cp = ConstantPool.readConstantPool(is);
        if (cp == null) {
            throw new IllegalAccessException("Error reading class - not valid class");
        }
        hash.update(is.readShort());
        hash.update(cp.getClassShortName(is.readUnsignedShort()));
        hash.update(cp.getClassShortName(is.readUnsignedShort()));
        TreeSet<String> interfaces = new TreeSet<String>();
        int count = is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            interfaces.add(cp.getClassShortName(is.readUnsignedShort()));
        }
        interfaces.forEach(hash::update);
        StringBuilder sb = new StringBuilder();
        TreeSet<String> fields = new TreeSet<String>();
        count = is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            short access_flags = is.readShort();
            int name_index = is.readUnsignedShort();
            is.readShort();
            ShadedClassHashCalculator.skipAttributes(is);
            sb.setLength(0);
            sb.append(cp.getStringConstant(name_index));
            sb.append(access_flags);
            fields.add(sb.toString());
        }
        fields.forEach(hash::update);
        TreeSet<String> method_digests = new TreeSet<String>();
        count = is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            Digest methodHash = Digest.get();
            methodHash.update(is.readShort());
            methodHash.update(cp.getStringConstant(is.readUnsignedShort()));
            is.readShort();
            ShadedClassHashCalculator.processMethodAttribures(is, cp, methodHash);
            method_digests.add(methodHash.asHexString());
        }
        method_digests.forEach(hash::update);
    }

    private static void skipAttributes(DataInputStream r) throws IOException {
        int count = r.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            r.readShort();
            r.skipBytes(r.readInt());
        }
    }

    private static void processMethodAttribures(DataInputStream r, ConstantPool cp, Digest hash) throws IOException {
        int count = r.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int name_index = r.readUnsignedShort();
            int size = r.readInt();
            if ("Code".equals(cp.getStringConstant(name_index))) {
                hash.update(r.readShort());
                r.readShort();
                int code_length = r.readInt();
                ByteCodeProcessor bcp = new ByteCodeProcessor(cp);
                CountingInputStream bytes = new CountingInputStream(r);
                while (bytes.position() < code_length) {
                    bcp.processMethodByteCode(bytes, hash);
                }
                r.skipBytes(size - 8 - code_length);
                continue;
            }
            r.skipBytes(size);
        }
    }
}

