/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.jar;

import com.azul.crs.javaagent.client.JDKAccessor;
import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public final class ZipTools {
    private static final Logger logger = Logger.getLogger(ZipTools.class);
    private static JDKAccessor jdkAccessor;
    private final boolean forceToUseGenericProvider;
    public final boolean allowAdvancedJarLoadDetection;
    private final CentralDirectoryProviderFactory jdkCentralDirectoryFactory;
    private final CentralDirectoryProviderFactory genericCentralDirectoryFactory;
    private final MultiMap<String, CentralDirectoryProviderFactory> cdTools;

    public ZipTools(boolean forceToUseGenericProvider, boolean allowAdvancedJarLoadDetection, String genericDirectoryProvider) {
        this.forceToUseGenericProvider = forceToUseGenericProvider;
        this.allowAdvancedJarLoadDetection = allowAdvancedJarLoadDetection;
        this.jdkCentralDirectoryFactory = this.getJdkCentralDirectoryFactory();
        this.genericCentralDirectoryFactory = this.getGenericCentralDirectoryFactory(genericDirectoryProvider);
        this.cdTools = new MultiMap();
        this.cdTools.put(JarFile.class.getName(), this.jdkCentralDirectoryFactory);
        this.cdTools.put("sun.net.www.protocol.jar.URLJarFile", this.jdkCentralDirectoryFactory);
        this.cdTools.put("jdk.internal.util.jar.PersistentJarFile", this.jdkCentralDirectoryFactory);
        this.cdTools.put("org.springframework.boot.loader.jar.JarFile", new Spring1xCentralDirectoryFactory());
        this.cdTools.put("org.springframework.boot.loader.jar.JarFile", new Spring2xCentralDirectoryFactory());
        this.cdTools.put("org.springframework.boot.loader.jar.JarFileWrapper", new Spring26xCentralDirectoryFactory());
    }

    public static ZipTools createDefault() {
        return new ZipTools(Boolean.getBoolean("com.azul.crs.javaagent.jarload.forceToUseGenericProvider"), Boolean.getBoolean("com.azul.crs.javaagent.jarload.allowAdvancedJarLoadDetection"), System.getProperty("com.azul.crs.javaagent.jarload.genericCentralDirectoryProvider"));
    }

    public static void setJdkAccessor(JDKAccessor jdkAccessor) {
        ZipTools.jdkAccessor = jdkAccessor;
    }

    private CentralDirectoryProviderFactory getJdkCentralDirectoryFactory() {
        if (jdkAccessor != null && jdkAccessor.supportsGetZipCentralDirectory()) {
            return new JDKCentralDirectoryFactory();
        }
        return new GenericCentralDirectoryFactory();
    }

    private CentralDirectoryProviderFactory getGenericCentralDirectoryFactory(String directoryProvider) {
        if (directoryProvider != null) {
            switch (directoryProvider) {
                case "generic": {
                    return new GenericCentralDirectoryFactory();
                }
                case "jdk": {
                    return this.getJdkCentralDirectoryFactory();
                }
                case "spring.1.x": {
                    return new Spring1xCentralDirectoryFactory();
                }
                case "spring.2.x": {
                    return new Spring2xCentralDirectoryFactory();
                }
            }
        }
        return new GenericCentralDirectoryFactory();
    }

    private CentralDirectoryProviderFactory findCentralDirectoryProviderFactoryForClass(Class klass) {
        Class c = klass;
        while (!c.equals(Object.class)) {
            CentralDirectoryProviderFactory provider = this.cdTools.get(c.getName());
            if (provider != null) {
                return provider;
            }
            c = c.getSuperclass();
        }
        return this.genericCentralDirectoryFactory;
    }

    public byte[] getManifestHash(MessageDigest digest, URL url, JarFile file) throws IOException {
        if (file == null) {
            return null;
        }
        ZipEntry entry = file.getEntry("META-INF/MANIFEST.MF");
        if (entry == null) {
            logger.trace("ZipTools.getDigest got JarFile=%s [%s] without manifest file", file, url);
            return null;
        }
        StringBuilder out = new StringBuilder();
        try (InputStream manifestInputStream = file.getInputStream(entry);){
            int numRead;
            char[] buffer = new char[Tweaks.DEFAULT_BUFFER_SIZE];
            InputStreamReader in = new InputStreamReader(manifestInputStream, StandardCharsets.UTF_8);
            while ((numRead = ((Reader)in).read(buffer, 0, buffer.length)) != -1) {
                out.append(buffer, 0, numRead);
            }
        }
        digest.reset();
        return digest.digest(out.toString().getBytes());
    }

    public static boolean isJDKNative(JarFile file) {
        return file != null && ZipTools.isKnownJarFileImplementation(file.getClass());
    }

    private static boolean isKnownJarFileImplementation(Class<? extends JarFile> c) {
        if (c == null) {
            return false;
        }
        return c.getName().equals(JarFile.class.getName()) || c.getName().equals("jdk.internal.util.jar.PersistentJarFile") || c.getName().equals("sun.net.www.protocol.jar.URLJarFile");
    }

    public static boolean isJarFile(String name) {
        return name != null && (name.endsWith(".jar") || name.endsWith(".war"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JarShortDigest getDigest(MessageDigest digest, URL url, JarFile file, InputStream is) throws IOException {
        CentralDirectoryProviderFactory providerFactory = null;
        try {
            if (url == null && file == null && is != null) {
                return this.getDigest(this.genericCentralDirectoryFactory, digest, null, null, is);
            }
            if (!this.allowAdvancedJarLoadDetection) {
                if (ZipTools.isJDKNative(file)) {
                    providerFactory = this.jdkCentralDirectoryFactory;
                    return this.getDigest(providerFactory, digest, url, file, is);
                }
                logger.debug("Unsupported jarFile type %s skip notification for %s", file.getClass().getName(), url.toString());
                return null;
            }
            Class<?> fileClass = file.getClass();
            providerFactory = this.forceToUseGenericProvider ? this.genericCentralDirectoryFactory : this.findCentralDirectoryProviderFactoryForClass(fileClass);
            this.cdTools.put(fileClass.getName(), providerFactory);
            return this.getDigest(providerFactory, digest, url, file, is);
        }
        catch (Exception ex) {
            Exception exception = ZipFileClosedException.isZipFileClosedException(ex) ? new ZipFileClosedException(ex) : ex;
            if (exception == null) return null;
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof JDKAccessor.ZipFileInconsistentException) {
                throw (RuntimeException)exception;
            }
            logger.debug("central directory sha256 calculation ended with exception (%s). url=%s, file=%s, zip-cd provider=%s", exception, url, file, providerFactory == null ? "null" : providerFactory.getClass().getName());
            if (providerFactory == null) return null;
            if (ZipTools.isJDKNative(file)) return null;
            logger.trace("Removing cached providerFactory for class %s", file.getClass().getName());
            this.cdTools.remove(file.getClass().getName(), providerFactory);
            return null;
        }
    }

    private JarShortDigest getDigest(CentralDirectoryProviderFactory providerFactory, MessageDigest digest, URL url, JarFile file, InputStream is) throws Exception {
        logger.trace("zip tools calculating sha256 of central directory: digest=%s, url=%s, file=%s, file.class=%s, ze=%s", digest.toString().trim(), url, file, file != null ? file.getClass().getName() : null, providerFactory.getClass().getName());
        DataProvider provider = providerFactory.getCentralDirectoryProvider(url, file, is);
        if (provider == null) {
            logger.trace("Failed to craete DataProvider for %s", url);
            return null;
        }
        digest.reset();
        AtomicLong centralDirectoryLength = new AtomicLong(0L);
        provider.deliver((b, off, len) -> {
            digest.update(b, off, len);
            centralDirectoryLength.getAndAdd(len);
            if (Tweaks.DEBUG_ZIPTOOLS && Tweaks.TRACE_CD_CONTENT) {
                System.out.printf(">>> += encodeToStringOrNull(%d, %d, %d);\n", b.length, off, len);
                System.out.printf(">>> += %s\n", Utils.encodeToStringOrNull(b, off, len));
            }
        });
        byte[] centralDirectoryHash = digest.digest();
        byte[] manifestHash = this.getManifestHash(digest, url, file);
        return new JarShortDigest(centralDirectoryHash, manifestHash, providerFactory.getClass().getName(), centralDirectoryLength.get());
    }

    public static final class ZipFileClosedException
    extends IOException {
        public ZipFileClosedException(Throwable cause) {
            super(cause);
        }

        public static boolean isZipFileClosedException(Throwable ex) {
            while (ex != null) {
                if (ex instanceof IllegalStateException && "zip file closed".equals(ex.getMessage())) {
                    return true;
                }
                if (ex instanceof ZipException && "ZipFile closed".equals(ex.getMessage())) {
                    return true;
                }
                ex = ex.getCause();
            }
            return false;
        }
    }

    public static final class JarShortDigest {
        public byte[] centralDirectoryHash;
        public byte[] manifestHash;
        public String provider;
        public long centralDirectoryLength;

        private JarShortDigest(byte[] centralDirectoryHash, byte[] manifestHash, String provider, long centralDirectoryLength) {
            this.centralDirectoryHash = centralDirectoryHash;
            this.manifestHash = manifestHash;
            this.provider = provider;
            this.centralDirectoryLength = centralDirectoryLength;
        }

        public byte[] getCentralDirectoryHash() {
            return this.centralDirectoryHash;
        }

        public byte[] getManifestHash() {
            return this.manifestHash;
        }

        public String getProvider() {
            return this.provider;
        }

        public long getCentralDirectoryLength() {
            return this.centralDirectoryLength;
        }

        public String toString() {
            return "JarShortDigest[hash=" + Utils.encodeToStringOrNull(this.centralDirectoryHash) + ", length=" + this.centralDirectoryLength + ", provider=" + this.provider + ", manifestHash=" + this.manifestHash + "]";
        }
    }

    public static class Spring1xCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        private boolean initialized = false;
        Class jarFile;
        Field data;
        Class randomAccessData;
        Class resourceAccess;
        Object resourceAccessOnce;
        Method getInputStream;
        Class centralDirectoryEndRecord;
        Field centralDirectoryEndRecordBlock;
        Field centralDirectoryEndRecordBlockOffset;
        Field centralDirectoryEndRecordBlockLength;
        Method getCentralDirectory;
        Constructor<Object> newCentralDirectoryEndRecord;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lazyInit(ClassLoader cl) {
            if (this.initialized) {
                return;
            }
            try {
                if (cl == null) {
                    cl = this.getClass().getClassLoader();
                }
                this.jarFile = Class.forName("org.springframework.boot.loader.jar.JarFile", true, cl);
                this.data = this.jarFile.getDeclaredField("data");
                this.data.setAccessible(true);
                this.randomAccessData = this.data.getType();
                this.resourceAccess = Class.forName("org.springframework.boot.loader.data.RandomAccessData$ResourceAccess", true, cl);
                for (Object o : this.resourceAccess.getEnumConstants()) {
                    if (!"ONCE".equals(o.toString())) continue;
                    this.resourceAccessOnce = o;
                }
                this.getInputStream = this.randomAccessData.getDeclaredMethod("getInputStream", this.resourceAccess);
                this.getInputStream.setAccessible(true);
                this.centralDirectoryEndRecord = Class.forName("org.springframework.boot.loader.jar.CentralDirectoryEndRecord", true, cl);
                this.centralDirectoryEndRecordBlock = this.centralDirectoryEndRecord.getDeclaredField("block");
                this.centralDirectoryEndRecordBlock.setAccessible(true);
                Class<?> blockType = this.centralDirectoryEndRecordBlock.getType();
                if (!blockType.equals(byte[].class)) {
                    throw new RuntimeException("CentralDirectoryEndRecord.block is not of byte[] type, as expected ==" + blockType.getName());
                }
                this.centralDirectoryEndRecordBlockOffset = this.centralDirectoryEndRecord.getDeclaredField("offset");
                this.centralDirectoryEndRecordBlockOffset.setAccessible(true);
                if (!Integer.TYPE.equals(this.centralDirectoryEndRecordBlockOffset.getType())) {
                    throw new RuntimeException("CentralDirectoryEndRecord.offset is not of int type, as expected ==" + this.centralDirectoryEndRecordBlockOffset.getType());
                }
                this.centralDirectoryEndRecordBlockLength = this.centralDirectoryEndRecord.getDeclaredField("size");
                this.centralDirectoryEndRecordBlockLength.setAccessible(true);
                if (!Integer.TYPE.equals(this.centralDirectoryEndRecordBlockLength.getType())) {
                    throw new RuntimeException("CentralDirectoryEndRecord.size is not of int type, as expected ==" + this.centralDirectoryEndRecordBlockLength.getType());
                }
                this.getCentralDirectory = this.centralDirectoryEndRecord.getDeclaredMethod("getCentralDirectory", this.randomAccessData);
                this.getCentralDirectory.setAccessible(true);
                this.newCentralDirectoryEndRecord = this.centralDirectoryEndRecord.getDeclaredConstructor(this.randomAccessData);
                this.newCentralDirectoryEndRecord.setAccessible(true);
            }
            catch (ClassNotFoundException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException ex) {
                logger.warning("%s initialization failed: %s", this.getClass().getSimpleName(), ex);
                this.jarFile = null;
                this.data = null;
                this.randomAccessData = null;
                this.resourceAccess = null;
                this.resourceAccessOnce = null;
                this.getInputStream = null;
                this.centralDirectoryEndRecord = null;
                this.centralDirectoryEndRecordBlock = null;
                this.centralDirectoryEndRecordBlockOffset = null;
                this.centralDirectoryEndRecordBlockLength = null;
                this.getCentralDirectory = null;
                this.newCentralDirectoryEndRecord = null;
            }
            finally {
                this.initialized = true;
            }
        }

        private void check(ZipFile f) throws IllegalArgumentException {
            if (!f.getClass().equals(this.jarFile)) {
                throw new IllegalArgumentException("Wrong extractor chosen");
            }
        }

        @Override
        public DataProvider getCentralDirectoryProvider(URL url, ZipFile f, InputStream is) {
            this.lazyInit(f.getClass().getClassLoader());
            assert (is == null);
            if (this.jarFile == null) {
                return null;
            }
            this.check(f);
            return consumer -> {
                Object d = this.data.get(f);
                Object end = this.newCentralDirectoryEndRecord.newInstance(d);
                Object cd = this.getCentralDirectory.invoke(end, d);
                byte[] endBlock = (byte[])this.centralDirectoryEndRecordBlock.get(end);
                int offset = (Integer)this.centralDirectoryEndRecordBlockOffset.get(end);
                int length = (Integer)this.centralDirectoryEndRecordBlockLength.get(end);
                try (InputStream is1 = (InputStream)this.getInputStream.invoke(cd, this.resourceAccessOnce);){
                    int read;
                    byte[] buffer = new byte[Tweaks.DEFAULT_BUFFER_SIZE];
                    while ((read = is1.read(buffer)) > 0) {
                        consumer.consume(buffer, 0, read);
                    }
                    consumer.consume(endBlock, offset, length);
                }
            };
        }
    }

    public static class Spring26xCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        private boolean initialized = false;
        private Field parent;
        private Class jarFileWrapper;
        private Class jarFile;
        private Spring2xCentralDirectoryFactory delegate;

        private synchronized void lazyInit(ClassLoader cl) {
            if (this.initialized) {
                return;
            }
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            try {
                this.jarFile = Class.forName("org.springframework.boot.loader.jar.JarFile", true, cl);
                this.jarFileWrapper = Class.forName("org.springframework.boot.loader.jar.JarFileWrapper", true, cl);
                this.parent = this.jarFileWrapper.getDeclaredField("parent");
                this.delegate = new Spring2xCentralDirectoryFactory();
                this.parent.setAccessible(true);
                if (!this.jarFile.equals(this.parent.getType())) {
                    throw new IllegalArgumentException(String.format("Field 'parent' expecting to have type %s, but has %s", this.jarFile.getName(), this.parent.getType()));
                }
            }
            catch (ClassNotFoundException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                logger.warning("%s initialization failed: %s", this.getClass().getSimpleName(), ex);
                this.parent = null;
                this.jarFileWrapper = null;
                this.jarFile = null;
                this.delegate = null;
            }
            finally {
                this.initialized = true;
            }
        }

        private void check(ZipFile f) throws IllegalArgumentException {
            if (!f.getClass().equals(this.jarFileWrapper)) {
                throw new IllegalArgumentException("Wrong extractor chosen");
            }
        }

        @Override
        public DataProvider getCentralDirectoryProvider(URL url, ZipFile f, InputStream is) {
            this.lazyInit(f.getClass().getClassLoader());
            assert (is == null);
            if (this.jarFile == null) {
                return null;
            }
            this.check(f);
            try {
                Object fParent = this.parent.get(f);
                return this.delegate.getCentralDirectoryProvider(url, (ZipFile)fParent, is);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                logger.warning(this.getClass().getSimpleName() + " initialization failed", ex);
                return null;
            }
        }
    }

    public static class Spring2xCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        private boolean initialized = false;
        Class jarFile;
        Field data;
        Class randomAccessData;
        Method read;
        Method getSize;
        Class centralDirectoryEndRecord;
        Field centralDirectoryEndRecordBlock;
        Field centralDirectoryEndRecordBlockOffset;
        Field centralDirectoryEndRecordBlockLength;
        Method getCentralDirectory;
        Constructor<Object> newCentralDirectoryEndRecord;

        private synchronized void lazyInit(ClassLoader cl) {
            if (this.initialized) {
                return;
            }
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            try {
                this.jarFile = Class.forName("org.springframework.boot.loader.jar.JarFile", true, cl);
                this.data = this.jarFile.getDeclaredField("data");
                this.data.setAccessible(true);
                this.randomAccessData = this.data.getType();
                this.read = this.randomAccessData.getDeclaredMethod("read", new Class[0]);
                this.read.setAccessible(true);
                this.getSize = this.randomAccessData.getDeclaredMethod("getSize", null);
                this.getSize.setAccessible(true);
                this.centralDirectoryEndRecord = Class.forName("org.springframework.boot.loader.jar.CentralDirectoryEndRecord", true, cl);
                this.centralDirectoryEndRecordBlock = this.centralDirectoryEndRecord.getDeclaredField("block");
                this.centralDirectoryEndRecordBlock.setAccessible(true);
                Class<?> blockType = this.centralDirectoryEndRecordBlock.getType();
                if (!blockType.equals(byte[].class)) {
                    throw new RuntimeException("CentralDirectoryEndRecord.block is not of byte[] type, as expected ==" + blockType.getName());
                }
                this.centralDirectoryEndRecordBlockOffset = this.centralDirectoryEndRecord.getDeclaredField("offset");
                this.centralDirectoryEndRecordBlockOffset.setAccessible(true);
                if (!Integer.TYPE.equals(this.centralDirectoryEndRecordBlockOffset.getType())) {
                    throw new RuntimeException("CentralDirectoryEndRecord.offset is not of int type, as expected ==" + this.centralDirectoryEndRecordBlockOffset.getType());
                }
                this.centralDirectoryEndRecordBlockLength = this.centralDirectoryEndRecord.getDeclaredField("size");
                this.centralDirectoryEndRecordBlockLength.setAccessible(true);
                if (!Integer.TYPE.equals(this.centralDirectoryEndRecordBlockLength.getType())) {
                    throw new RuntimeException("CentralDirectoryEndRecord.size is not of int type, as expected ==" + this.centralDirectoryEndRecordBlockLength.getType());
                }
                this.getCentralDirectory = this.centralDirectoryEndRecord.getDeclaredMethod("getCentralDirectory", this.randomAccessData);
                this.getCentralDirectory.setAccessible(true);
                this.newCentralDirectoryEndRecord = this.centralDirectoryEndRecord.getDeclaredConstructor(this.randomAccessData);
                this.newCentralDirectoryEndRecord.setAccessible(true);
            }
            catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException | SecurityException ex) {
                logger.warning("%s initialization failed: %s", this.getClass().getSimpleName(), ex);
                this.jarFile = null;
                this.data = null;
                this.randomAccessData = null;
                this.read = null;
                this.getSize = null;
                this.centralDirectoryEndRecord = null;
                this.centralDirectoryEndRecordBlock = null;
                this.centralDirectoryEndRecordBlockOffset = null;
                this.centralDirectoryEndRecordBlockLength = null;
                this.getCentralDirectory = null;
                this.newCentralDirectoryEndRecord = null;
            }
            finally {
                this.initialized = true;
            }
        }

        private void check(ZipFile f) throws IllegalArgumentException {
            if (!f.getClass().equals(this.jarFile)) {
                throw new IllegalArgumentException("Wrong extractor chosen");
            }
        }

        @Override
        public DataProvider getCentralDirectoryProvider(URL url, ZipFile f, InputStream is) {
            this.lazyInit(f.getClass().getClassLoader());
            assert (is == null);
            if (this.jarFile == null) {
                return null;
            }
            this.check(f);
            return consumer -> {
                Object d = this.data.get(f);
                Object end = this.newCentralDirectoryEndRecord.newInstance(d);
                Object cd = this.getCentralDirectory.invoke(end, d);
                byte[] res = (byte[])this.read.invoke(cd, new Object[0]);
                byte[] endBlock = (byte[])this.centralDirectoryEndRecordBlock.get(end);
                int offset = (Integer)this.centralDirectoryEndRecordBlockOffset.get(end);
                int length = (Integer)this.centralDirectoryEndRecordBlockLength.get(end);
                consumer.consume(res);
                consumer.consume(endBlock, offset, length);
            };
        }
    }

    public static class GenericCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        public InputStream getInputStream(URL url, ZipFile f, InputStream is) {
            if (is != null) {
                return is;
            }
            try {
                return url.openConnection().getInputStream();
            }
            catch (IOException e) {
                logger.trace("Failed to get inputStream by openConnection.getInputStream from url: %s", url);
                URL modifiedUrl = null;
                try {
                    modifiedUrl = new URL(Objects.toString(url).replaceAll("^jar:", "").replaceAll("!\\/$", ""));
                    return modifiedUrl.openConnection().getInputStream();
                }
                catch (IOException e2) {
                    logger.trace("Failed to get inputStream by openConnection.getInputStream from modified url: %s (original url=%s)", modifiedUrl, url);
                    String zipName = null;
                    try {
                        zipName = f.getName();
                        return new FileInputStream(new File(zipName));
                    }
                    catch (IOException e3) {
                        logger.trace("Failed to get inputStream by from zipName: %s", zipName);
                        return null;
                    }
                }
            }
        }

        @Override
        public DataProvider getCentralDirectoryProvider(URL url, ZipFile f, InputStream is) {
            return consumer -> {
                try (InputStream is1 = this.getInputStream(url, f, is);){
                    long numberOfEntries;
                    ZipInputStreamCentralDirectoryParser zis = new ZipInputStreamCentralDirectoryParser(is1);
                    zis.deliver(consumer);
                    if (Tweaks.DEBUG_ZIPTOOLS && f != null && zis.endtot != (numberOfEntries = (long)Collections.list(f.entries()).size())) {
                        throw new RuntimeException(String.format("ERROR: file=%s:%s contains %dl entries, but we calculated the number as %dl.", f, f.getClass().getName(), numberOfEntries, zis.endtot));
                    }
                }
            };
        }

        private static class ZipInputStreamCentralDirectoryParser
        implements DataProvider {
            private final RandomAccessBuffer buffer;
            public long endpos;
            public long endtot;
            public long endsiz;
            public long endoff;
            public long endcom;
            public long cenpos;
            public long locpos;
            static final int ENDTOT = 10;
            static final int ENDSIZ = 12;
            static final int ENDOFF = 16;
            static final int ENDCOM = 20;
            static final long LOCSIG = 67324752L;
            static final long CENSIG = 33639248L;
            static final long ENDSIG = 101010256L;
            static final int ENDHDR = 22;
            static final long ZIP64_MAGICVAL = 0xFFFFFFFFL;
            static final int ZIP64_LOCHDR = 20;
            static final long ZIP64_LOCSIG = 117853008L;
            static final int ZIP64_LOCOFF = 8;
            static final long ZIP64_ENDSIG = 101075792L;
            static final int ZIP64_ENDOFF = 48;
            static final int ZIP64_ENDTOT = 32;
            static final int ZIP64_MAGICCOUNT = 65535;
            static final int ZIP64_ENDSIZ = 40;

            ZipInputStreamCentralDirectoryParser(InputStream is) {
                this.buffer = new RandomAccessBuffer(is);
            }

            private void readCentralDirectory(DataConsumer consumer) throws IOException {
                long firstLOC = -1L;
                this.buffer.readNextPage();
                int i = 0;
                while (!this.buffer.meetEOF() && (long)i >= this.buffer.getStart() && (long)(i + 4) < this.buffer.getEnd()) {
                    if (this.buffer.get32(i) == 67324752L) {
                        firstLOC = i;
                    }
                    ++i;
                }
                this.buffer.readUntilEOF();
                for (long i2 = this.buffer.getEnd() - 22L; i2 > this.buffer.getStart(); --i2) {
                    long endpos64;
                    if (this.buffer.get32(i2) != 101010256L) continue;
                    long endpos = i2;
                    long endtot = this.buffer.get16(endpos + 10L);
                    long endsiz = this.buffer.get32(endpos + 12L);
                    long endoff = this.buffer.get32(endpos + 16L);
                    long endcom = this.buffer.get16(endpos + 20L);
                    long cenpos = endpos - endsiz;
                    long locpos = cenpos - endoff;
                    if (endpos + 22L + endcom != this.buffer.getEnd() && (cenpos < 0L || locpos < 0L || firstLOC != -1L && locpos != firstLOC || this.buffer.get32(cenpos) != 33639248L)) continue;
                    if (endpos >= 20L && this.buffer.get32(endpos - 20L) == 117853008L && this.buffer.get32(endpos64 = this.buffer.get64(endpos - 20L + 8L)) == 101075792L) {
                        long endsiz64 = this.buffer.get64(endpos64 + 40L);
                        long endoff64 = this.buffer.get64(endpos64 + 48L);
                        long endtot64 = this.buffer.get64(endpos64 + 32L);
                        if (!(endsiz64 != endsiz && endsiz != 0xFFFFFFFFL || endoff64 != endoff && endoff != 0xFFFFFFFFL || endtot64 != endtot && endtot != 65535L)) {
                            endsiz = endsiz64;
                            endoff = endoff64;
                            endtot = endtot64;
                            endpos = endpos64;
                            cenpos = endpos - endsiz;
                            locpos = cenpos - endoff;
                        }
                    }
                    if (Tweaks.DEBUG_ZIPTOOLS) {
                        this.endpos = endpos;
                        this.endtot = endtot;
                        this.endsiz = endsiz;
                        this.endoff = endoff;
                        this.endcom = endcom;
                        this.cenpos = cenpos;
                        this.locpos = locpos;
                    }
                    this.buffer.deliver(consumer, cenpos, endpos + 22L - cenpos);
                    return;
                }
            }

            @Override
            public void deliver(DataConsumer consumer) throws IOException {
                this.readCentralDirectory(consumer);
            }

            private static class RandomAccessBuffer {
                private final int maxChunks = Tweaks.genericCentralDirectoryMaxChunks;
                private final Queue<Chunk> queue;
                private final Chunk[] chunks;
                private final InputStream stream;
                private boolean eof;
                private long dataStartOffset;
                private long dataEndOffset;

                private void renumerate() {
                    int i = 0;
                    for (Chunk c : this.queue) {
                        this.chunks[i++] = c;
                    }
                }

                private Chunk getFreeChunk() {
                    if (this.queue.size() < this.maxChunks) {
                        Chunk c = new Chunk();
                        this.queue.add(c);
                        return c;
                    }
                    Chunk c = this.queue.remove();
                    if (c.buf.length != c.filled) {
                        throw new RuntimeException("!");
                    }
                    this.dataStartOffset += (long)c.filled;
                    c.clear();
                    this.queue.add(c);
                    this.renumerate();
                    return c;
                }

                public RandomAccessBuffer(InputStream stream) {
                    this.stream = stream;
                    this.eof = false;
                    this.dataEndOffset = 0L;
                    this.dataStartOffset = 0L;
                    this.queue = new LinkedList<Chunk>();
                    this.chunks = new Chunk[this.maxChunks];
                }

                public void deliver(DataConsumer consumer, long off, long len) throws IOException {
                    if (off < this.dataStartOffset || off + len > this.dataEndOffset) {
                        throw new RuntimeException(String.format("off=%dl, len=%dl are out of range [%dl, %dl]", off, len, this.dataStartOffset, this.dataEndOffset));
                    }
                    int firstChunk = this.getChunkNumber(off);
                    int firstOffset = this.getOffsetInsideChunk(off);
                    int lastChunk = this.getChunkNumber(off + len);
                    int lastOffset = this.getOffsetInsideChunk(off + len);
                    if (firstChunk == lastChunk) {
                        if (lastOffset < firstOffset) {
                            throw new RuntimeException(String.format("lastOffset=%dl < firstOffset=%dl", lastOffset, firstOffset));
                        }
                        consumer.consume(this.chunks[firstChunk].buf, firstOffset, lastOffset - firstOffset);
                    } else {
                        consumer.consume(this.chunks[firstChunk].buf, firstOffset, Tweaks.DEFAULT_BUFFER_SIZE - firstOffset);
                        for (int j = firstChunk + 1; j < lastChunk; ++j) {
                            consumer.consume(this.chunks[j].buf, 0, Tweaks.DEFAULT_BUFFER_SIZE);
                        }
                        consumer.consume(this.chunks[lastChunk].buf, 0, lastOffset);
                    }
                }

                public boolean meetEOF() {
                    return !this.eof;
                }

                public long getStart() {
                    return this.dataStartOffset;
                }

                public long getEnd() {
                    return this.dataEndOffset;
                }

                public boolean readNextPage() throws IOException {
                    if (this.eof) {
                        return false;
                    }
                    Chunk c = this.getFreeChunk();
                    long read = -1L;
                    while (c.buf.length - c.filled > 0 && (read = (long)this.stream.read(c.buf, c.filled, c.buf.length - c.filled)) != -1L) {
                        c.filled = (int)((long)c.filled + read);
                        this.dataEndOffset += read;
                    }
                    this.renumerate();
                    if (read == -1L) {
                        this.eof = true;
                    }
                    return !this.eof;
                }

                public void readUntilEOF() throws IOException {
                    while (this.readNextPage()) {
                    }
                }

                private int getChunkNumber(long i) {
                    if (i > this.dataEndOffset || i < this.dataStartOffset) {
                        throw new RuntimeException(String.format("i is not in range: i=%dl range=[%dl, %dl]", i, this.dataStartOffset, this.dataEndOffset));
                    }
                    return (int)((i - this.dataStartOffset) / (long)Tweaks.DEFAULT_BUFFER_SIZE);
                }

                private int getOffsetInsideChunk(long i) {
                    if (i > this.dataEndOffset || i < this.dataStartOffset) {
                        throw new RuntimeException(String.format("i is not in range: i=%dl range=[%dl, %dl]", i, this.dataStartOffset, this.dataEndOffset));
                    }
                    return (int)(i % (long)Tweaks.DEFAULT_BUFFER_SIZE);
                }

                public byte get8(long off) {
                    if (off < this.dataStartOffset || off >= this.dataEndOffset) {
                        throw new RuntimeException(String.format("RandomAccessBuffer out of index access off=%dl, expecting range: [%dl, %dl]", off, this.dataStartOffset, this.dataEndOffset));
                    }
                    return this.chunks[this.getChunkNumber((long)off)].buf[this.getOffsetInsideChunk(off)];
                }

                public int get16(long off) {
                    return this.get8(off) & 0xFF | (this.get8(off + 1L) & 0xFF) << 8;
                }

                public long get32(long off) {
                    return ((long)this.get16(off) | (long)this.get16(off + 2L) << 16) & 0xFFFFFFFFL;
                }

                public long get64(long off) {
                    return this.get32(off) | this.get32(off + 4L) << 32;
                }

                private static class Chunk {
                    public byte[] buf = new byte[Tweaks.DEFAULT_BUFFER_SIZE];
                    public int filled = 0;

                    Chunk() {
                    }

                    public void clear() {
                        this.filled = 0;
                    }
                }
            }
        }
    }

    public static class JDKCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        @Override
        public DataProvider getCentralDirectoryProvider(URL url, ZipFile f, InputStream is) {
            assert (is == null);
            return consumer -> consumer.consume(jdkAccessor.getZipFileCentralDirectory(f));
        }
    }

    public static interface CentralDirectoryProviderFactory {
        public DataProvider getCentralDirectoryProvider(URL var1, ZipFile var2, InputStream var3);
    }

    public static interface DataProvider {
        public void deliver(DataConsumer var1) throws Exception;
    }

    public static interface DataConsumer {
        public void consume(byte[] var1, int var2, int var3) throws IOException;

        default public void consume(byte[] data) throws IOException {
            this.consume(data, 0, data.length);
        }
    }

    private class MultiMap<K, V> {
        Map<K, List<V>> map = new HashMap<K, List<V>>();

        private MultiMap() {
        }

        synchronized void put(K k, V v) {
            List l = this.map.computeIfAbsent(k, kk -> new ArrayList());
            if (!l.contains(v)) {
                l.add(v);
            }
        }

        synchronized V get(K k) {
            List<V> list = this.map.get(k);
            return list == null || list.isEmpty() ? null : (V)list.get(0);
        }

        synchronized void remove(K k, V v) {
            List<V> l = this.map.get(k);
            if (l != null) {
                l.remove(v);
            }
        }
    }
}

