/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.javaagent.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.zip.ZipFile;
import javax.net.ssl.HttpsURLConnection;
import sun.net.dns.ResolverConfiguration;
import sun.net.www.http.HttpClient;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.https.HttpsURLConnectionImpl;

public class JDKAccessor {
    private static final Boolean isJDK8 = System.getProperty("java.version").startsWith("1.");
    private boolean initialized = false;
    private Field res;
    private Class cleanableResource;
    private Field zsrc;
    private Class source;
    private Field cen;
    private Method getCentralDirectory;
    private boolean canGetCentralDirectory;
    private static Field connectionHttpsDelegateField;
    private static Field connectionHttpField;

    private synchronized void lazyInit() {
        if (this.initialized) {
            return;
        }
        try {
            if (isJDK8.booleanValue()) {
                this.getCentralDirectory = ZipFile.class.getDeclaredMethod("getCentralDirectory", new Class[0]);
                this.getCentralDirectory.setAccessible(true);
            } else {
                this.res = ZipFile.class.getDeclaredField("res");
                this.res.setAccessible(true);
                this.cleanableResource = this.res.getType();
                this.zsrc = this.cleanableResource.getDeclaredField("zsrc");
                this.zsrc.setAccessible(true);
                this.source = this.zsrc.getType();
                this.cen = this.source.getDeclaredField("cen");
                this.cen.setAccessible(true);
            }
            this.canGetCentralDirectory = true;
        }
        catch (Throwable th) {
            this.res = null;
            this.cleanableResource = null;
            this.zsrc = null;
            this.source = null;
            this.cen = null;
            this.getCentralDirectory = null;
        }
        try {
            connectionHttpsDelegateField = HttpsURLConnectionImpl.class.getDeclaredField("delegate");
            connectionHttpsDelegateField.setAccessible(true);
            connectionHttpField = HttpURLConnection.class.getDeclaredField("http");
            connectionHttpField.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.initialized = true;
    }

    public byte[] getZipFileCentralDirectory(ZipFile f) throws UnsupportedOperationException, IllegalAccessException, InvocationTargetException {
        this.lazyInit();
        if (!this.canGetCentralDirectory) {
            throw new IllegalStateException("initialization failure");
        }
        Object cleanableResource1 = null;
        Object source1 = null;
        try {
            if (isJDK8.booleanValue()) {
                return (byte[])this.getCentralDirectory.invoke((Object)f, new Object[0]);
            }
            cleanableResource1 = this.res.get(f);
            source1 = this.zsrc.get(cleanableResource1);
            return (byte[])this.cen.get(source1);
        }
        catch (Exception e) {
            if (cleanableResource1 == null || source1 == null) {
                throw new ZipFileInconsistentException("cleanable resource is null");
            }
            throw new RuntimeException("Failed to access central directory due to exception (file=" + f + ", class=" + (f == null ? null : f.getClass()) + ", isJDK8=" + isJDK8 + ", getCentralDirectory=" + this.getCentralDirectory + ", res=" + this.res + ", zsrc=" + this.zsrc + ", cen=" + this.cen + ", cleanableResource=" + cleanableResource1 + ", source=" + source1, e);
        }
    }

    public boolean supportsGetZipCentralDirectory() {
        this.lazyInit();
        return this.canGetCentralDirectory;
    }

    public List<String> getDnsResolverSearchList() throws IllegalAccessError {
        ResolverConfiguration rc = ResolverConfiguration.open();
        return rc.searchlist();
    }

    public boolean isNotCachedHttpsURLConnection(HttpsURLConnection con) {
        if (connectionHttpsDelegateField != null && connectionHttpField != null) {
            try {
                HttpClient http = (HttpClient)connectionHttpField.get(connectionHttpsDelegateField.get(con));
                if (!http.isCachedConnection()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String getHostNameViaReflection() throws InternalError {
        try {
            Class<?> clazz = Class.forName("java.net.Inet4AddressImpl");
            Method method = clazz.getDeclaredMethod("getLocalHostName", new Class[0]);
            method.setAccessible(true);
            for (Constructor<?> ctor : clazz.getDeclaredConstructors()) {
                if (ctor.getParameterCount() != 0) continue;
                ctor.setAccessible(true);
                Object instance = ctor.newInstance(new Object[0]);
                Object result = method.invoke(instance, new Object[0]);
                if (result instanceof String) {
                    return (String)result;
                }
                throw new InternalError("internal error " + (result == null ? null : result.getClass()));
            }
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new InternalError(e);
        }
        return null;
    }

    public class ZipFileInconsistentException
    extends RuntimeException {
        ZipFileInconsistentException(String s) {
            super(s);
        }
    }
}

