/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.json;

import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.json.JSONSerializer;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DummyJSONSerializer
implements JSONSerializer {
    private final int tabs = 2;
    private boolean doFormat = Tweaks.PRETTY_PRINT_JSON;
    private int level = 0;
    private static final String escape3Text = "\"\\/\b\f\n\r\t";
    private static final Pattern escape3Pattern = Pattern.compile("[\"\\\\/\b\f\n\r\t\u0000-\u001f]");
    private static final String[] escape3Replacement = new String[]{"\\\\\"", "\\\\\\\\", "\\\\/", "\\\\b", "\\\\f", "\\\\n", "\\\\r", "\\\\t"};

    public DummyJSONSerializer() {
    }

    public DummyJSONSerializer(boolean prettyPrint) {
        this.doFormat |= prettyPrint;
    }

    void formatEnter(PrintStream output) {
        if (!this.doFormat) {
            return;
        }
        ++this.level;
    }

    void formatMid(PrintStream output) throws IOException {
        if (!this.doFormat) {
            return;
        }
        output.append("\n");
        for (int i = 0; i < 2 * this.level; ++i) {
            output.append(' ');
        }
    }

    void formatLeave(PrintStream output) {
        if (!this.doFormat) {
            return;
        }
        --this.level;
    }

    private static boolean fieldFilter(Field field) {
        if (Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        return !"hash".equals(field.getName()) || !"java.lang.String".equals(field.getDeclaringClass().getName());
    }

    void serializeEnum(PrintStream output, Enum e) throws IOException {
        output.append('\"').append(e.name()).append('\"');
    }

    private static boolean isNumberOrBoolean(Object o) {
        return o instanceof Number || o instanceof Boolean;
    }

    void serializeNumberOrBoolean(PrintStream output, Object o) throws IOException {
        output.append(o.toString());
    }

    void serializeString(PrintStream output, String o) throws IOException {
        Matcher m = escape3Pattern.matcher(o);
        StringBuffer sb = new StringBuffer();
        output.append('\"');
        while (m.find()) {
            char c = m.group().charAt(0);
            int index = escape3Text.indexOf(c);
            sb.setLength(0);
            m.appendReplacement(sb, index >= 0 ? escape3Replacement[index] : String.format("\\\\u%04x", c));
            output.append(sb);
        }
        sb.setLength(0);
        m.appendTail(sb);
        output.append(sb);
        output.append('\"');
    }

    void serializeMap(PrintStream output, Map m) throws IOException {
        output.append('{');
        this.formatEnter(output);
        int count = 0;
        for (Object key : m.keySet()) {
            Object value = m.get(key);
            if (value == null) continue;
            if (count > 0) {
                output.append(',');
            }
            this.formatMid(output);
            ++count;
            this.serialize(output, key);
            output.append(':');
            this.serialize(output, value);
        }
        this.formatLeave(output);
        if (count > 0) {
            this.formatMid(output);
        }
        output.append('}');
    }

    void serializeCollection(PrintStream output, Collection c) throws IOException {
        output.append('[');
        this.formatEnter(output);
        int count = 0;
        for (Object o : c) {
            if (count > 0) {
                output.append(',');
            }
            this.formatMid(output);
            ++count;
            this.serialize(output, o);
        }
        this.formatLeave(output);
        if (count > 0) {
            this.formatMid(output);
        }
        output.append(']');
    }

    private void printFieldName(PrintStream output, Field field) throws IOException {
        this.serializeString(output, field.getName());
    }

    void serializeObject(PrintStream output, Object o) throws IOException {
        if (null == o) {
            output.append("null");
            return;
        }
        output.append('{');
        this.formatEnter(output);
        Class<?> oc = o.getClass();
        int count = 0;
        for (Field field : oc.getDeclaredFields()) {
            if (!DummyJSONSerializer.fieldFilter(field)) continue;
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.get(o);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace(System.err);
                throw new RuntimeException("Tykwa: ", e);
            }
            if (value == null) continue;
            if (count > 0) {
                output.append(',');
            }
            this.formatMid(output);
            this.printFieldName(output, field);
            output.append(':');
            this.serialize(output, value);
            ++count;
        }
        this.formatLeave(output);
        if (count > 0) {
            this.formatMid(output);
        }
        output.append('}');
    }

    @Override
    public void serialize(PrintStream output, Object obj) throws IOException {
        if (null == obj) {
            return;
        }
        if (obj instanceof String) {
            this.serializeString(output, (String)obj);
        } else if (obj instanceof Enum) {
            this.serializeEnum(output, (Enum)obj);
        } else if (DummyJSONSerializer.isNumberOrBoolean(obj)) {
            this.serializeNumberOrBoolean(output, obj);
        } else if (obj instanceof Map) {
            this.serializeMap(output, (Map)obj);
        } else if (obj instanceof Collection) {
            this.serializeCollection(output, (Collection)obj);
        } else {
            this.serializeObject(output, obj);
        }
    }
}

