/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.runtime.utils;

import com.azul.crs.javaagent.runtime.utils.PackedDataEntriesMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DataEntriesMap<T extends Enum<T>> {
    private final DirNode<T> root = new DirNode("");
    private final Class<T> dataKindsEnum;
    private final Enum[] usedKinds;
    private DirNode<T> cache = this.root;

    public DataEntriesMap(Class<T> dataKindsEnum) {
        this.dataKindsEnum = dataKindsEnum;
        this.usedKinds = new Enum[((Enum[])dataKindsEnum.getEnumConstants()).length];
    }

    public void put(String path, T kind, String data) throws IllegalArgumentException {
        this.getEntry(path).put(kind, data);
    }

    public void put(PackedDataEntriesMap.Entry<T> packedEntry) {
        this.getEntry((String)packedEntry.getKey()).put(packedEntry);
    }

    public DataEntry getEntry(String path) throws IllegalArgumentException {
        DirNode<T> node;
        if (path == null || path.endsWith("/")) {
            throw new IllegalArgumentException();
        }
        int idx = path.lastIndexOf(47);
        String name = path.substring(idx + 1);
        String dir = path.substring(0, idx + 1);
        if (((DirNode)this.cache).path.equals(dir)) {
            node = this.cache;
        } else {
            this.cache = node = this.findOrCreateDirNode(this.root, 0, dir);
        }
        return new DataEntry(((DirNode)node).files.computeIfAbsent(name, n -> new String[((Enum[])this.dataKindsEnum.getEnumConstants()).length]));
    }

    public PackedDataEntriesMap<T> pack() {
        ArrayList<String> output = new ArrayList<String>();
        output.add("PEM01" + Arrays.stream(this.usedKinds).filter(Objects::nonNull).map(Enum::name).collect(Collectors.joining(":")));
        this.pack(this.root, output);
        return PackedDataEntriesMap.fromExternalForm(output, this.dataKindsEnum);
    }

    private <K extends Enum<K>> void pack(DirNode<K> node, List<String> result) {
        if (!((DirNode)node).path.isEmpty()) {
            result.add(((DirNode)node).path);
        }
        int idx = result.size();
        result.add(((DirNode)node).files.size() + ":");
        ((DirNode)node).files.forEach((name, data) -> result.add(name + "|" + this.encode((String[])data)));
        ((DirNode)node).dirs.forEach(dir -> this.pack((DirNode)dir, result));
        result.set(idx, result.get(idx) + (result.size() - idx - 1));
    }

    private DirNode<T> findOrCreateDirNode(DirNode<T> node, int idx, String dir) {
        if (idx == dir.length()) {
            return node;
        }
        idx = dir.indexOf(47, idx);
        String dirname = dir.substring(0, idx + 1);
        for (DirNode d : ((DirNode)node).dirs) {
            if (!d.path.equals(dirname)) continue;
            return this.findOrCreateDirNode(d, idx + 1, dir);
        }
        DirNode newNode = new DirNode(dirname);
        ((DirNode)node).dirs.add(newNode);
        return this.findOrCreateDirNode(newNode, idx + 1, dir);
    }

    private String encode(String[] data) {
        StringBuilder sb = new StringBuilder();
        for (Enum usedKind : this.usedKinds) {
            if (usedKind == null) continue;
            String val = data[usedKind.ordinal()];
            if (val != null) {
                sb.append(val);
            }
            sb.append(':');
        }
        int idx = sb.length();
        while (idx > 0 && sb.charAt(--idx) == ':') {
            sb.setLength(idx);
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return ((DirNode)this.root).dirs.isEmpty() && ((DirNode)this.root).files.isEmpty();
    }

    public int size() {
        return ((DirNode)this.root).dirs.size() + ((DirNode)this.root).files.size();
    }

    public Stream<PackedDataEntriesMap.Entry<T>> stream() {
        return this.pack().stream();
    }

    public final class DataEntry {
        private final String[] data;

        private DataEntry(String[] data) {
            this.data = data;
        }

        public boolean isEmpty() {
            if (this.data != null) {
                for (String d : this.data) {
                    if (d == null) continue;
                    return false;
                }
            }
            return true;
        }

        public void put(T kind, String data) {
            int kindIdx = ((Enum)kind).ordinal();
            if (DataEntriesMap.this.usedKinds[kindIdx] == null) {
                ((DataEntriesMap)DataEntriesMap.this).usedKinds[kindIdx] = kind;
            }
            this.data[kindIdx] = data;
        }

        public void put(PackedDataEntriesMap.Entry<T> packedEntry) {
            Arrays.stream(DataEntriesMap.this.dataKindsEnum.getEnumConstants()).forEach(k -> this.put(k, packedEntry.getValue(k)));
        }
    }

    private static class DirNode<K extends Enum<K>>
    implements Comparable<DirNode<K>> {
        private final String path;
        private final TreeMap<String, String[]> files = new TreeMap();
        private final TreeSet<DirNode<K>> dirs = new TreeSet();

        private DirNode(String path) {
            this.path = path;
        }

        @Override
        public int compareTo(DirNode o) {
            return this.path.compareTo(o.path);
        }
    }
}

