/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.runtime.utils;

import java.util.HashSet;
import java.util.Set;

public final class KnownAzulRuntimeContainers {
    private KnownAzulRuntimeContainers() {
    }

    public static Set<String> get(String javaHome, String javaSpecificationVersion) {
        int specVersionNumber;
        HashSet<String> result = new HashSet<String>();
        if (javaSpecificationVersion == null || javaHome == null) {
            return result;
        }
        if (javaSpecificationVersion.startsWith("1.")) {
            javaSpecificationVersion = javaSpecificationVersion.substring(2);
        }
        try {
            specVersionNumber = Integer.parseInt(javaSpecificationVersion);
        }
        catch (NumberFormatException ex) {
            return result;
        }
        javaHome = ("/" + javaHome).replace('\\', '/').replaceAll("/+", "/");
        if (specVersionNumber <= 8) {
            for (String fname : new String[]{"cat.jar", "charsets.jar", "crs-agent.jar", "jce.jar", "jfr.jar", "jsse.jar", "management-agent.jar", "resources.jar", "rt.jar", "sunrsasign.jar"}) {
                KnownAzulRuntimeContainers.add(result, javaHome, "lib", fname);
            }
            for (String fname : new String[]{"access-bridge.jar", "access-bridge-32.jar", "access-bridge-64.jar", "cldrdata.jar", "crs-agent.jar", "dnsns.jar", "jaccess.jar", "legacy8ujsse.jar", "localedata.jar", "nashorn.jar", "openeddsa.jar", "openjsse.jar", "sunec.jar", "sunjce_provider.jar", "sunmscapi.jar", "sunpkcs11.jar", "zipfs.jar"}) {
                KnownAzulRuntimeContainers.add(result, javaHome, "lib/ext", fname);
            }
            String jdkHome = javaHome.endsWith("/jre") ? javaHome.substring(0, javaHome.length() - 4) : javaHome;
            for (String fname : new String[]{"dt.jar", "jconsole.jar", "sa-jdi.jar", "tools.jar"}) {
                KnownAzulRuntimeContainers.add(result, jdkHome, "lib", fname);
            }
        } else {
            for (String fname : new String[]{"modules", "jrt-fs.jar"}) {
                KnownAzulRuntimeContainers.add(result, javaHome, "lib", fname);
            }
            for (String fname : new String[]{"modified_inputstreams.jar", "modified_rule_based_collator.jar", "readynow_extensions.jar", "standard_threadlocal.jar"}) {
                KnownAzulRuntimeContainers.add(result, javaHome, "etc/extensions/jdk", fname);
            }
        }
        return result;
    }

    private static void add(Set<String> result, String javaHome, String dir, String fname) {
        try {
            result.add(String.join((CharSequence)"/", javaHome, dir, fname));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

