/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.runtime.utils;

import java.lang.invoke.LambdaMetafactory;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class PackedDataEntriesMap<T extends Enum<T>>
implements Iterable<Entry<T>> {
    static final String MAGIC = "PEM01";
    private final List<T> dataFieldKinds;
    private final List<String> packedList;

    private PackedDataEntriesMap(List<String> packedList, List<T> dataFieldKinds) {
        this.packedList = packedList;
        this.dataFieldKinds = dataFieldKinds;
    }

    public static boolean isPackedDataEntriesMap(List<String> packedList) {
        return packedList.size() > 1 && packedList.get(0).startsWith(MAGIC);
    }

    public static int getNumberOfEntries(List<String> packedList) {
        if (!PackedDataEntriesMap.isPackedDataEntriesMap(packedList)) {
            throw new IllegalArgumentException();
        }
        String[] secondLineData = packedList.get(1).split(":");
        if (secondLineData.length != 2) {
            throw new IllegalArgumentException();
        }
        return Integer.parseInt(secondLineData[1]);
    }

    public static <T extends Enum<T>> PackedDataEntriesMap<T> fromExternalForm(List<String> packedList, Class<T> kindsEnum) {
        if (packedList.isEmpty()) {
            return new PackedDataEntriesMap(Collections.emptyList(), Collections.emptyList());
        }
        String descr = packedList.get(0);
        if (!descr.startsWith(MAGIC)) {
            throw new IllegalArgumentException();
        }
        descr = descr.substring(MAGIC.length());
        descr = descr.replace("ENRTY", "ENTRY");
        String[] kinds = descr.split(":");
        ArrayList<T> dataFieldKinds = new ArrayList<T>();
        for (String kind : kinds) {
            try {
                dataFieldKinds.add(Enum.valueOf(kindsEnum, kind));
            }
            catch (IllegalArgumentException ex) {
                dataFieldKinds.add(null);
            }
        }
        return new PackedDataEntriesMap(packedList, dataFieldKinds);
    }

    private static <T> String extractField(String data, T kind, List<T> dataFieldKinds) {
        int p2;
        if (data == null || kind == null) {
            return data;
        }
        int idx = dataFieldKinds.indexOf(kind);
        if (idx < 0) {
            return null;
        }
        int p1 = -1;
        for (int i = 0; i < idx; ++i) {
            if ((p1 = data.indexOf(58, p1 + 1)) >= 0) continue;
            return null;
        }
        if (++p1 == (p2 = data.indexOf(58, p1))) {
            return null;
        }
        return p2 < 0 ? data.substring(p1) : data.substring(p1, p2);
    }

    public List<String> toExternalForm() {
        return Collections.unmodifiableList(this.packedList);
    }

    public List<T> dataFieldKinds() {
        return this.dataFieldKinds;
    }

    /*
     * Unable to fully structure code
     */
    private int indexOf(String path) {
        currentIndex = 1;
        lastSlash = path.lastIndexOf(47) + 1;
        entryDir = path.substring(0, lastSlash);
        entryName = path.substring(lastSlash) + "|";
        str = this.packedList.get(currentIndex++);
        if (!entryDir.isEmpty()) {
            currentIndex += Integer.parseInt(str.substring(0, str.indexOf(58)));
            str = this.packedList.get(currentIndex++);
            block0: while (true) {
                if (!entryDir.startsWith(str)) {
                    if ((currentIndex += Integer.parseInt((str = this.packedList.get(currentIndex++)).substring(str.indexOf(58) + 1))) == this.packedList.size()) {
                        return -1;
                    }
                    str = this.packedList.get(currentIndex++);
                    continue;
                }
                while (true) {
                    if (entryDir.startsWith(str)) ** break;
                    continue block0;
                    if (str.equals(entryDir)) break block0;
                    if ((currentIndex += Integer.parseInt((str = this.packedList.get(currentIndex++)).substring(0, str.indexOf(58)))) == this.packedList.size()) {
                        return -1;
                    }
                    str = this.packedList.get(currentIndex++);
                }
                break;
            }
            str = this.packedList.get(currentIndex++);
        }
        return (idx = Collections.binarySearch(this.packedList.subList(currentIndex, lastIndex = currentIndex + Integer.parseInt(str.substring(0, str.indexOf(58)))), entryName, (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$indexOf$0(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)I)())) < 0 ? idx : idx + currentIndex;
    }

    public boolean contains(String path) {
        return this.indexOf(path) > 0;
    }

    public String getData(String path) {
        int index = this.indexOf(path);
        String entry = index > 0 ? this.packedList.get(index) : null;
        return entry == null ? null : entry.substring(entry.indexOf(124) + 1);
    }

    public String getData(String path, T kind) {
        return PackedDataEntriesMap.extractField(this.getData(path), kind, this.dataFieldKinds);
    }

    @Override
    public Iterator<Entry<T>> iterator() {
        return this.iterator(null);
    }

    public Stream<Entry<T>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<Entry<T>> stream(T kind) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(kind), 16), false);
    }

    public Iterator<Entry<T>> iterator(T kind) {
        return new Iterator<Entry<T>>((Enum)kind){
            private final ListIterator<String> it;
            private String prefix;
            final /* synthetic */ Enum val$kind;
            {
                this.val$kind = enum_;
                this.it = PackedDataEntriesMap.this.packedList.listIterator();
                this.prefix = "";
                if (this.hasNext()) {
                    this.it.next();
                }
                if (this.hasNext()) {
                    this.it.next();
                }
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Entry<T> next() {
                try {
                    String s = this.it.next();
                    while (s.endsWith("/")) {
                        this.prefix = s;
                        this.it.next();
                        s = this.it.next();
                    }
                    int idx = s.indexOf(124);
                    String path = this.prefix + s.substring(0, idx);
                    String value = PackedDataEntriesMap.extractField(s.substring(idx + 1), this.val$kind, PackedDataEntriesMap.this.dataFieldKinds);
                    return this.val$kind == null ? new Entry(path, value, PackedDataEntriesMap.this.dataFieldKinds) : new SingleFieldEntry(path, value, this.val$kind);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Format error", ex);
                }
            }
        };
    }

    public boolean isEmpty() {
        return PackedDataEntriesMap.getNumberOfEntries(this.packedList) == 0;
    }

    private static /* synthetic */ int lambda$indexOf$0(String s1, String s2) {
        return s1.startsWith(s2) ? 0 : s1.compareTo(s2);
    }

    public static class Entry<T>
    extends AbstractMap.SimpleEntry<String, String> {
        private final List<T> dataFieldKinds;

        private Entry(String path, String value, List<T> dataFieldKinds) {
            super(path, value);
            this.dataFieldKinds = dataFieldKinds;
        }

        public String getValue(T kind) {
            return PackedDataEntriesMap.extractField((String)this.getValue(), kind, this.dataFieldKinds);
        }
    }

    private static class SingleFieldEntry<T>
    extends Entry<T> {
        private final T kind;

        private SingleFieldEntry(String path, String value, T kind) {
            super(path, value, null);
            this.kind = kind;
        }

        @Override
        public String getValue(T kind) {
            return this.kind == kind ? (String)this.getValue() : null;
        }
    }
}

