/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.runtime.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;

public final class TempFilesFactory {
    private static final String tempJarFileNamePrefix = "jar_cache";
    private static final String tempJarFileNameSuffix = ".jar";
    private static Timer timer;
    private static boolean shutdownStarted;
    private static final Map<File, TempFileDeletionTimerTask> map;

    private TempFilesFactory() {
    }

    public static TempFile createTempJarFile(Consumer<TempFile> onDeleteAction) throws IOException {
        return new TempFile(Files.createTempFile(tempJarFileNamePrefix, tempJarFileNameSuffix, new FileAttribute[0]).toFile(), onDeleteAction);
    }

    public static synchronized void shutdown() {
        shutdownStarted = true;
        timer.cancel();
        map.forEach((f, t) -> {
            try {
                t.cancel();
                f.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        map.clear();
        timer.purge();
    }

    private static synchronized Timer getTimer() {
        if (timer == null) {
            timer = new Timer("CRSTempFilesExpirationTimer", true);
        }
        return timer;
    }

    public static synchronized void scheduleDeletion(TempFile file, long delay) {
        if (shutdownStarted) {
            file.delete();
            throw new IllegalStateException("Too late to schedule deletion: shutdown in progress");
        }
        TempFileDeletionTimerTask task = new TempFileDeletionTimerTask(file);
        map.put(file, task);
        TempFilesFactory.getTimer().schedule((TimerTask)task, delay);
    }

    public static synchronized boolean deleteIfScheduled(File file) {
        TempFileDeletionTimerTask task = map.remove(file);
        if (task != null) {
            task.cancel();
            return task.file.delete();
        }
        return false;
    }

    static {
        shutdownStarted = false;
        map = new HashMap<File, TempFileDeletionTimerTask>();
    }

    private static final class TempFileDeletionTimerTask
    extends TimerTask {
        public final TempFile file;

        public TempFileDeletionTimerTask(TempFile file) {
            this.file = file;
        }

        @Override
        public void run() {
            TempFilesFactory.deleteIfScheduled(this.file);
        }
    }

    public static class TempFile
    extends File {
        final Consumer<TempFile> onDeleteAction;

        private TempFile(File f, Consumer<TempFile> onDeleteAction) {
            super(f.toURI());
            this.onDeleteAction = onDeleteAction;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public boolean delete() {
            if (super.delete()) {
                if (this.onDeleteAction != null) {
                    try {
                        this.onDeleteAction.accept(this);
                    }
                    catch (Throwable t) {
                        System.err.println("Unhandled exception: " + t);
                        t.printStackTrace();
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

