/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.runtime.utils;

import java.util.Arrays;
import java.util.List;

public final class URLHelper {
    private static final List<String> containerExtensions = Arrays.asList(".jar", ".war", ".ear");
    private static final List<String> remoteLocation = Arrays.asList("http://", "https://");
    private static final List<String> containerProtos = Arrays.asList("jar:", "file:");
    private static final String containerProtoPattern = "^[a-z]{3,}:.+";

    private URLHelper() {
    }

    public static String toNormalizedURL(String pathOrURL) {
        if (pathOrURL == null) {
            return null;
        }
        if (!pathOrURL.contains("/") && !pathOrURL.contains("\\")) {
            return pathOrURL;
        }
        if (pathOrURL.contains("http://") || pathOrURL.contains("https://")) {
            return pathOrURL;
        }
        boolean startsWithProto = pathOrURL.matches(containerProtoPattern);
        return (startsWithProto ? pathOrURL : "file:/" + pathOrURL).replace('\\', '/').replaceAll("/+", "/").replace(" ", "%20");
    }

    public static String toNormalizedJarURL(String pathOrURL) {
        int idx;
        if (!(pathOrURL = URLHelper.toNormalizedURL(pathOrURL)).startsWith("jar:")) {
            pathOrURL = "jar:" + pathOrURL;
        }
        if ((idx = pathOrURL.lastIndexOf(".jar")) > 0 && !pathOrURL.endsWith(".jar!/")) {
            pathOrURL = pathOrURL.substring(0, idx) + ".jar!/";
        }
        return pathOrURL;
    }

    public static String extractContainerPathFromURL(String url) {
        int pos;
        if (url == null) {
            return null;
        }
        int s = 0;
        int e = url.length();
        block0: while (true) {
            for (String proto : containerProtos) {
                int pl;
                if (!url.regionMatches(s, proto, 0, pl = proto.length())) continue;
                s += pl;
                continue block0;
            }
            break;
        }
        if (s == 0) {
            return url;
        }
        if (url.regionMatches(e - 2, "!/", 0, 2)) {
            e -= 2;
        }
        int tmp = e;
        boolean endsWithKnownExtension = containerExtensions.stream().anyMatch(ext -> {
            int el = ext.length();
            return url.regionMatches(tmp - el, (String)ext, 0, el);
        });
        int tmps = s;
        boolean startsWithRemoteLocation = remoteLocation.stream().anyMatch(rl -> url.startsWith((String)rl, tmps));
        if (!endsWithKnownExtension && (pos = containerExtensions.stream().mapToInt(ext -> {
            int idx = url.lastIndexOf(ext + "!/");
            return idx > 0 ? idx + ext.length() : idx;
        }).max().orElse(-1)) > 0) {
            e = pos;
        }
        if (startsWithRemoteLocation) {
            return url.substring(s, e);
        }
        return ("/" + url.substring(s, e)).replaceAll("/+", "/").replace("%20", " ");
    }
}

