/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.util.logging;

import com.azul.crs.javaagent.util.logging.Logger;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class Config {
    private final AtomicReference<Logger.Level> upstream;
    private final AtomicReference<Logger.Level> downstream;
    private final AtomicBoolean upstreamStacktrace;
    private final AtomicBoolean downstreamStacktrace;

    public Config(Logger.Level upstream, Logger.Level downstream, boolean upstreamStacktrace, boolean downstreamStacktrace) {
        this.upstream = new AtomicReference<Logger.Level>(upstream);
        this.downstream = new AtomicReference<Logger.Level>(downstream);
        this.upstreamStacktrace = new AtomicBoolean(upstreamStacktrace);
        this.downstreamStacktrace = new AtomicBoolean(downstreamStacktrace);
    }

    public Logger.Level getUpstreamLevel() {
        return this.upstream.get();
    }

    public Logger.Level getDownstreamLevel() {
        return this.downstream.get();
    }

    public boolean showUpstreamStacktrace() {
        return this.upstreamStacktrace.get();
    }

    public boolean showDownstreamStacktrace() {
        return this.downstreamStacktrace.get();
    }

    public void reconfigure(Map.Entry<Logger.Level, Boolean> downstream, Map.Entry<Logger.Level, Boolean> upstream) {
        if (downstream != null) {
            this.downstream.set(downstream.getKey());
            this.downstreamStacktrace.set(downstream.getValue());
        }
        if (upstream != null) {
            this.upstream.set(upstream.getKey());
            this.upstreamStacktrace.set(upstream.getValue());
        }
    }
}

