/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.util.logging;

import com.azul.crs.javaagent.util.logging.Config;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class LogConfiguration {
    private static final String REGISTRY = "META-INF/crslog.channels.cfg";
    static final Logger.Level downstreamDefaultLevel = Logger.Level.ERROR;
    static final Logger.Level upstreamDefaultLevel = Logger.Level.ERROR;
    private static final Set<String> localStreamAliases = new HashSet<String>(Arrays.asList("", "stderr", "downstream"));
    private static final Set<String> remoteStreamAliases = new HashSet<String>(Arrays.asList("remote", "upstream"));
    boolean showTimestamp = false;
    private final Map<String, String> classToTag = new HashMap<String, String>();
    private final Map<String, Config> tagsConfiguration = new HashMap<String, Config>();
    private Config nonTaggedClasses;

    public LogConfiguration(Collection<Map.Entry<String, String>> options) {
        Map<String, Logger.Level> tags = this.readRegistry();
        StreamConfiguration localStreamConfiguration = new StreamConfiguration(localStreamAliases);
        StreamConfiguration remoteStreamConfiguration = new StreamConfiguration(remoteStreamAliases);
        this.parseOptions(localStreamConfiguration, remoteStreamConfiguration, options);
        this.merge(tags, localStreamConfiguration, remoteStreamConfiguration);
    }

    public void reconfigure(Collection<Map.Entry<String, String>> options) {
        StreamConfiguration localStreamConfiguration = new StreamConfiguration(localStreamAliases);
        StreamConfiguration remoteStreamConfiguration = new StreamConfiguration(remoteStreamAliases);
        this.parseOptions(localStreamConfiguration, remoteStreamConfiguration, options);
        this._reconfigure(localStreamConfiguration, remoteStreamConfiguration);
    }

    public String getTagForClass(String forClass) {
        return this.classToTag.get(forClass);
    }

    public Config getConfig(String tag) {
        if (tag == null) {
            return this.nonTaggedClasses;
        }
        return this.tagsConfiguration.get(tag);
    }

    private void _reconfigure(StreamConfiguration localStreamConfiguration, StreamConfiguration remoteStreamConfiguration) {
        for (Map.Entry<String, Config> entry : this.tagsConfiguration.entrySet()) {
            String tag = entry.getKey();
            Map.Entry downstream = localStreamConfiguration.getConfig(tag);
            Map.Entry upstream = remoteStreamConfiguration.getConfig(tag);
            entry.getValue().reconfigure(downstream, upstream);
        }
        this.nonTaggedClasses.reconfigure(localStreamConfiguration.streamConfig, remoteStreamConfiguration.streamConfig);
    }

    private void merge(Map<String, Logger.Level> tags, StreamConfiguration localStreamConfiguration, StreamConfiguration remoteStreamConfiguration) {
        for (Map.Entry<String, Logger.Level> entry : tags.entrySet()) {
            AbstractMap.SimpleEntry<Logger.Level, Boolean> upstream;
            String tag = entry.getKey();
            AbstractMap.SimpleEntry<Logger.Level, Boolean> downstream = localStreamConfiguration.getConfig(tag);
            if (downstream == null) {
                downstream = new AbstractMap.SimpleEntry<Logger.Level, Boolean>(downstreamDefaultLevel, false);
            }
            if ((upstream = remoteStreamConfiguration.getConfig(tag)) == null) {
                upstream = new AbstractMap.SimpleEntry<Logger.Level, Boolean>(entry.getValue(), false);
            }
            this.tagsConfiguration.put(tag, new Config((Logger.Level)((Object)upstream.getKey()), (Logger.Level)((Object)downstream.getKey()), (Boolean)upstream.getValue(), (Boolean)downstream.getValue()));
        }
        this.nonTaggedClasses = this.createDefault(remoteStreamConfiguration.streamConfig, localStreamConfiguration.streamConfig);
    }

    private Config createDefault(Map.Entry<Logger.Level, Boolean> remote, Map.Entry<Logger.Level, Boolean> local) {
        Logger.Level remoteLevel = upstreamDefaultLevel;
        Logger.Level localLevel = downstreamDefaultLevel;
        boolean remoteStacktrace = false;
        boolean localStacktrace = false;
        if (remote != null) {
            remoteLevel = remote.getKey();
            remoteStacktrace = remote.getValue();
        }
        if (local != null) {
            localLevel = local.getKey();
            localStacktrace = local.getValue();
        }
        return new Config(remoteLevel, localLevel, remoteStacktrace, localStacktrace);
    }

    public boolean showTimestamp() {
        return this.showTimestamp;
    }

    private void parseOptions(StreamConfiguration localStreamConfiguration, StreamConfiguration remoteStreamConfiguration, Collection<Map.Entry<String, String>> options) {
        for (Map.Entry<String, String> option : options) {
            StreamConfiguration streamConfiguration;
            Logger.Level level;
            String name = option.getKey();
            if (!this.isValid(name)) continue;
            String value = option.getValue();
            boolean showStacktrace = false;
            while (true) {
                int len;
                if (value.endsWith("+stack")) {
                    showStacktrace = true;
                    len = 6;
                } else {
                    if (!value.endsWith("+time")) break;
                    this.showTimestamp = true;
                    len = 5;
                }
                value = value.substring(0, value.length() - len);
            }
            try {
                level = Logger.Level.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                System.err.println("[CRS.log][error] unsupported log level '" + value + "'");
                continue;
            }
            int tagIndex = name.indexOf("+");
            String tags = null;
            if (tagIndex > 0) {
                tags = name.substring(tagIndex + 1);
                name = name.substring(0, tagIndex);
            }
            if ((streamConfiguration = this.getCorrectStream(localStreamConfiguration, remoteStreamConfiguration, name)) == null) {
                System.err.println("[CRS.log][error] unsupported stream in log option '" + name + "'");
                continue;
            }
            if (tags == null || tags.isEmpty()) {
                streamConfiguration.add(level, showStacktrace);
                continue;
            }
            for (String tag : this.getTags(tags)) {
                if ("vm".equals(tags)) continue;
                streamConfiguration.add(tag, level, showStacktrace);
            }
        }
    }

    private boolean isValid(String name) {
        return name != null && (name.equals("log") || name.startsWith("log:") || name.startsWith("log+"));
    }

    private String[] getTags(String tags) {
        return tags.split(",");
    }

    private StreamConfiguration getCorrectStream(StreamConfiguration lowStreamConfiguration, StreamConfiguration upStreamConfiguration, String name) {
        int index = name.indexOf(":");
        String stream = "";
        if (index > 0) {
            stream = name.substring(index + 1);
        }
        if (lowStreamConfiguration.support(stream)) {
            return lowStreamConfiguration;
        }
        if (upStreamConfiguration.support(stream)) {
            return upStreamConfiguration;
        }
        return null;
    }

    private Map<String, Logger.Level> readRegistry() {
        HashMap<String, Logger.Level> tagToLevel = new HashMap<String, Logger.Level>();
        String prefix = LogConfiguration.class.getName().replace(".util.logging.LogConfiguration", "");
        int stockPrefixLength = 12;
        int prefixLength = prefix.length();
        boolean shouldRenameClass = prefixLength > 12;
        try {
            HashSet<URL> urls = new HashSet<URL>();
            ClassLoader classLoader = Logger.class.getClassLoader();
            if (classLoader != null) {
                urls.addAll(Collections.list(classLoader.getResources(REGISTRY)));
            }
            urls.addAll(Collections.list(ClassLoader.getSystemResources(REGISTRY)));
            for (URL url : urls) {
                Properties props = new Properties();
                InputStream is = url.openStream();
                Throwable throwable = null;
                try {
                    props.load(is);
                    Enumeration<?> names = props.propertyNames();
                    while (names.hasMoreElements()) {
                        String tag;
                        String className = names.nextElement().toString();
                        String cfg = props.getProperty(className);
                        Logger.Level lowestUpstreamLevel = upstreamDefaultLevel;
                        int delim = cfg.lastIndexOf(58);
                        if (delim > 0) {
                            tag = cfg.substring(0, delim);
                            lowestUpstreamLevel = Logger.Level.valueOf(cfg.substring(delim + 1));
                        } else {
                            tag = cfg;
                        }
                        tagToLevel.put(tag, lowestUpstreamLevel);
                        if (shouldRenameClass) {
                            className = prefix + className.substring(12);
                        }
                        this.classToTag.put(className, tag);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (Throwable th) {
            java.util.logging.Logger.getLogger(Logger.class.getName()).log(Level.SEVERE, null, th);
        }
        return tagToLevel;
    }

    private class StreamConfiguration {
        private final Set<String> aliases;
        private Map.Entry<Logger.Level, Boolean> streamConfig = null;
        private Map<String, Map.Entry<Logger.Level, Boolean>> tagToConfig = new HashMap<String, Map.Entry<Logger.Level, Boolean>>();

        public StreamConfiguration(Set<String> aliases) {
            this.aliases = aliases;
        }

        public boolean support(String name) {
            return this.aliases.contains(name);
        }

        public void add(Logger.Level level, boolean showStacktrace) {
            this.streamConfig = new AbstractMap.SimpleEntry<Logger.Level, Boolean>(level, showStacktrace);
        }

        public void add(String tag, Logger.Level level, boolean showStacktrace) {
            this.tagToConfig.put(tag, new AbstractMap.SimpleEntry<Logger.Level, Boolean>(level, showStacktrace));
        }

        public Map.Entry getConfig(String tag) {
            Map.Entry<Logger.Level, Boolean> config = this.tagToConfig.get(tag);
            if (config == null) {
                return this.streamConfig;
            }
            return config;
        }
    }
}

