/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.util.logging;

import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.util.logging.Config;
import com.azul.crs.javaagent.util.logging.LogConfiguration;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public final class Logger {
    private static final Map<String, Logger> TAG_TO_LOGGER = new HashMap<String, Logger>();
    private static final String NO_TAG_LOGGER_IDENTIFICATION = "default";
    private static final List<PrintWriter> writers = new CopyOnWriteArrayList<PrintWriter>();
    private static final long vmStartTime = System.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getUptime();
    private static final AtomicBoolean notInitialized = new AtomicBoolean(true);
    private static LogConfiguration logConfiguration;
    private final String tag;
    private final Config config;

    static void reset() {
        TAG_TO_LOGGER.clear();
        notInitialized.set(true);
    }

    private Logger(String tag, Config config) {
        this.tag = tag;
        this.config = config;
    }

    private static Logger loggerForTag(String tag) {
        if (tag == null) {
            Logger logger = TAG_TO_LOGGER.get(NO_TAG_LOGGER_IDENTIFICATION);
            if (logger == null) {
                Config config = logConfiguration.getConfig(null);
                logger = new Logger(NO_TAG_LOGGER_IDENTIFICATION, config);
                TAG_TO_LOGGER.put(NO_TAG_LOGGER_IDENTIFICATION, logger);
            }
            return logger;
        }
        Logger logger = TAG_TO_LOGGER.get(tag);
        if (logger == null) {
            Config config = logConfiguration.getConfig(tag);
            logger = new Logger(tag, config);
            TAG_TO_LOGGER.put(tag, logger);
        }
        return logger;
    }

    public static void addOutputStream(OutputStream handler) {
        writers.add(new PrintWriter(handler));
    }

    public static Logger getLogger(Class klass) {
        if (notInitialized.get()) {
            Logger.init(Collections.EMPTY_LIST);
        }
        String name = klass.getCanonicalName();
        String tag = logConfiguration.getTagForClass(name);
        return Logger.loggerForTag(tag);
    }

    public static void parseOptions(Collection<Map.Entry<String, String>> options) {
        Logger.init(options);
    }

    private static synchronized void init(Collection<Map.Entry<String, String>> options) {
        if (notInitialized.get()) {
            logConfiguration = new LogConfiguration(options);
        } else {
            logConfiguration.reconfigure(options);
        }
        notInitialized.set(false);
    }

    public void trace(String format, Object ... args) {
        this.log(Level.TRACE, format, args);
    }

    public void debug(String format, Object ... args) {
        this.log(Level.DEBUG, format, args);
    }

    public void info(String format, Object ... args) {
        this.log(Level.INFO, format, args);
    }

    public void warning(String format, Object ... args) {
        this.log(Level.WARNING, format, args);
    }

    public void error(String format, Object ... args) {
        this.log(Level.ERROR, format, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Level level, String format, Object ... args) {
        try {
            StackTraceElement e;
            Object t;
            StringBuilder sb;
            boolean upstreamLevelEnabled = this.isUpstreamLevelEnabled(level);
            boolean downstreamLevelEnabled = this.isDownstreamLevelEnabled(level);
            if (!upstreamLevelEnabled && !downstreamLevelEnabled) {
                return;
            }
            StringBuilder prefix = new StringBuilder();
            if (this.showTimestamp()) {
                prefix.append(this.elapsedTime());
            }
            prefix.append("[CRS.").append(this.tag).append("][").append(level.n).append("] ");
            if (downstreamLevelEnabled) {
                sb = new StringBuilder(prefix);
                if (this.config.getDownstreamLevel() == Level.TRACE) {
                    t = new Throwable();
                    e = ((Throwable)t).getStackTrace()[2];
                    prefix.append(e.getClassName()).append('.').append(e.getMethodName()).append(": ");
                }
                t = this;
                synchronized (t) {
                    this.logDecoratedLines(level, this.config.showDownstreamStacktrace(), new PrintWriter(System.err), sb, format, args);
                }
            }
            if (upstreamLevelEnabled) {
                if (!this.showTimestamp()) {
                    prefix.insert(0, this.elapsedTime());
                }
                sb = new StringBuilder(prefix);
                if (this.config.getUpstreamLevel() == Level.TRACE) {
                    t = new Throwable();
                    e = ((Throwable)t).getStackTrace()[2];
                    prefix.append(e.getClassName()).append('.').append(e.getMethodName()).append(": ");
                }
                for (PrintWriter out : writers) {
                    this.logDecoratedLines(level, this.config.showUpstreamStacktrace(), out, sb, format, args);
                }
            }
        }
        catch (Throwable th) {
            java.util.logging.Logger.getLogger(Logger.class.getName()).log(java.util.logging.Level.SEVERE, null, th);
        }
    }

    boolean showTimestamp() {
        return logConfiguration.showTimestamp();
    }

    boolean isDownstreamLevelEnabled(Level level) {
        return this.config.getDownstreamLevel().ordinal() <= level.ordinal();
    }

    boolean isUpstreamLevelEnabled(Level level) {
        return this.config.getUpstreamLevel().ordinal() <= level.ordinal();
    }

    Config getConfig() {
        return this.config;
    }

    public boolean isEnabled(Level level) {
        return this.config.getUpstreamLevel().ordinal() <= level.ordinal() || this.config.getDownstreamLevel().ordinal() <= level.ordinal();
    }

    private CharSequence elapsedTime() {
        long delta = System.currentTimeMillis() - vmStartTime;
        long sec = delta / 1000L;
        long ms = delta % 1000L;
        CharSequence millis = Long.toString(1000L + ms).subSequence(1, 4);
        return sec + "." + millis + ": ";
    }

    private String newLineIndentation(StringBuilder sb, int n, String prefix) {
        sb.append("\n");
        sb.append(prefix);
        for (int i = 0; i < n; ++i) {
            sb.append("    ");
        }
        return sb.toString();
    }

    private String prettyPrint(String s) {
        return this.prettyPrint(s, "");
    }

    private String prettyPrint(String s, String prefix) {
        if (!Tweaks.UGLY_PRETTY_PRINT_FOR_DEBUG || s == null || s.length() < 80) {
            return s;
        }
        int indentationLevel = 0;
        StringBuilder sb = new StringBuilder();
        char[] charArray = s.toCharArray();
        boolean noFormat = false;
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (i < charArray.length - 4 && charArray[i] == '\t' && charArray[i + 1] == 'a' && charArray[i + 2] == 't' && charArray[i + 3] == ' ') {
                noFormat = true;
            }
            if (!noFormat) {
                String openParentheses = "([{";
                String closeParentheses = ")]}";
                String separators1 = "([{)]},";
                if (c == '(' || c == '[' || c == '{') {
                    int j;
                    for (j = i + 1; j < charArray.length - 1 && "([{)]},".indexOf(charArray[j]) == -1; ++j) {
                    }
                    if (j < charArray.length - 1 && "([{".indexOf(c) == ")]}".indexOf(charArray[j])) {
                        while (i <= j) {
                            sb.append(charArray[i]);
                            ++i;
                        }
                        i = j;
                        continue;
                    }
                    this.newLineIndentation(sb, indentationLevel, prefix);
                    sb.append(c);
                    this.newLineIndentation(sb, ++indentationLevel, prefix);
                    continue;
                }
                if (c == ')' || c == ']' || c == '}') {
                    this.newLineIndentation(sb, --indentationLevel, prefix);
                    sb.append(c);
                    this.newLineIndentation(sb, indentationLevel, prefix);
                    continue;
                }
                if (c == ',') {
                    sb.append(c);
                    this.newLineIndentation(sb, indentationLevel, prefix);
                    continue;
                }
            }
            if (i != charArray.length - 1 && c == '\n') {
                this.newLineIndentation(sb, indentationLevel, prefix);
                noFormat = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void logDecoratedLines(Level level, boolean showStacktrace, PrintWriter out, StringBuilder prefix, String format, Object ... args) {
        boolean forceStackTrace;
        out.append(prefix);
        for (char c : this.prettyPrint(String.format(format, args)).toCharArray()) {
            out.append(c);
            if (c != '\n') continue;
            out.append(prefix);
        }
        out.println();
        boolean bl = forceStackTrace = level == Level.ERROR && Tweaks.FORCE_PRINT_STACKTRACE_IN_ERROR;
        if (showStacktrace || forceStackTrace) {
            for (Object arg : args) {
                if (!(arg instanceof Throwable)) continue;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ((Throwable)arg).printStackTrace(pw);
                String prettyTrace = Arrays.stream(this.prettyPrint(sw.toString(), " >> ").split("\n")).map(s -> "" + prefix.toString() + s).collect(Collectors.joining("\n"));
                out.append(prettyTrace);
            }
        }
        out.flush();
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        OFF;

        private final String n = this.name().toLowerCase();
    }
}

