/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.util.logging;

import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.util.logging.Logger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class LoggingHelper {
    private static AtomicInteger unhandledExceptionsCounter = new AtomicInteger();
    private static Set<String> knownExceptions = Collections.synchronizedSet(new HashSet());

    public static void logUnhandledException(Logger logger, Logger.Level level, Throwable t) {
        unhandledExceptionsCounter.incrementAndGet();
        if (logger == null || level == null || knownExceptions.size() >= Tweaks.dedupSize) {
            return;
        }
        try {
            String exceptionFingerprints = Objects.toString(t) + Arrays.stream(t.getStackTrace()).map(e -> Objects.toString(e)).collect(Collectors.joining(","));
            if (knownExceptions.contains(exceptionFingerprints)) {
                return;
            }
            knownExceptions.add(exceptionFingerprints);
            logger.log(level, "Unexpected exception %s", t);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    public static void logStatistics(Logger logger, Logger.Level level) {
        try {
            int amount = unhandledExceptionsCounter.get();
            if (amount == 0) {
                return;
            }
            logger.log(level, "%d exceptions were unhandled", amount);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

