/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.accessibility.SimpleTraverseListener;

public class MCToolBarManager {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER_LEFT = 10;
    public static final int ALIGN_CENTER = 20;
    public static final int ALIGN_CENTER_RIGHT = 30;
    public static final int ALIGN_RIGHT = 40;
    private final IPropertyChangeListener actionListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            Control[] controls;
            if (MCToolBarManager.this.getToolBar().isDisposed()) {
                return;
            }
            String property = event.getProperty();
            IAction action = (IAction)event.getSource();
            Control[] controlArray = controls = MCToolBarManager.this.getToolBar().getChildren();
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                ToolbarItem tbi = (ToolbarItem)control.getData();
                if (tbi.getAction() == action) {
                    ImageHyperlink imageHyperlink = (ImageHyperlink)control;
                    if ("enabled".equals(property)) {
                        MCToolBarManager.this.updateImage(imageHyperlink, action);
                    } else if ("toolTipText".equals(property)) {
                        imageHyperlink.setToolTipText(action.getToolTipText());
                    } else if ("text".equals(property)) {
                        MCToolBarManager.this.updateText(imageHyperlink, action);
                    }
                    return;
                }
                ++n2;
            }
        }
    };
    private final Composite m_parent;
    private final ArrayList<ToolbarItem> m_list = new ArrayList();
    private Composite m_toolbar;
    private LocalResourceManager m_localResourceManager;

    public MCToolBarManager(Composite parent) {
        this.m_parent = parent;
    }

    public Composite getParent() {
        return this.m_parent;
    }

    public void dispose() {
        if (this.m_toolbar != null && !this.m_toolbar.isDisposed()) {
            this.m_toolbar.dispose();
        }
        if (this.m_localResourceManager != null) {
            this.m_localResourceManager.dispose();
        }
        if (this.m_list != null) {
            for (ToolbarItem tbi : this.m_list) {
                tbi.getAction().removePropertyChangeListener(this.actionListener);
            }
            this.m_list.clear();
        }
        this.m_localResourceManager = null;
    }

    public List<IAction> getActions() {
        ArrayList<IAction> list = new ArrayList<IAction>();
        for (ToolbarItem item : this.m_list) {
            list.add(item.getAction());
        }
        return Collections.unmodifiableList(list);
    }

    public void update() {
        Composite layoutRoot = this.getToolBar().getParent();
        layoutRoot.setLayoutDeferred(true);
        try {
            this.disposeToolbarItems();
            Iterator<ToolbarItem> iterator = this.m_list.iterator();
            while (iterator.hasNext()) {
                ToolbarItem element;
                ToolbarItem item = element = iterator.next();
                this.createWidget(item, this.getToolBar());
            }
        }
        finally {
            layoutRoot.setLayoutDeferred(false);
        }
    }

    public Composite getToolBar() {
        if (this.m_toolbar == null) {
            this.m_toolbar = new Composite(this.getParent(), 0);
            RowLayout layout = new RowLayout(256);
            layout.marginLeft = 0;
            layout.marginRight = 0;
            layout.spacing = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            this.m_toolbar.setLayout((Layout)layout);
        }
        return this.m_toolbar;
    }

    public void add(IAction action, int alignment) {
        this.m_list.add(new ToolbarItem(action, alignment));
        this.m_list.sort(null);
        this.update();
        action.addPropertyChangeListener(this.actionListener);
    }

    public void add(IAction action) {
        this.add(action, 20);
    }

    public void remove(IAction action) {
        Control[] children;
        action.removePropertyChangeListener(this.actionListener);
        Control[] controlArray = children = this.getToolBar().getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            ToolbarItem item = (ToolbarItem)element.getData();
            if (action.equals(item.getAction())) {
                this.m_list.remove(item);
                this.update();
                return;
            }
            ++n2;
        }
    }

    private ToolbarItem getToolbarItem(HyperlinkEvent e) {
        return (ToolbarItem)e.widget.getData();
    }

    private void setImage(ImageHyperlink imageHyperLink, ImageDescriptor imageDescriptor) {
        if (imageHyperLink != null && imageDescriptor != null) {
            try {
                imageHyperLink.setImage(this.getResourceManager().createImage(imageDescriptor));
                imageHyperLink.redraw();
            }
            catch (DeviceResourceException deviceResourceException) {}
        }
    }

    private LocalResourceManager getResourceManager() {
        if (this.m_localResourceManager == null) {
            this.m_localResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.m_localResourceManager;
    }

    private boolean isCheckable(IAction action) {
        return action != null && (action.getStyle() & 2) != 0;
    }

    private boolean isRadioable(IAction action) {
        return action != null && (action.getStyle() & 8) != 0;
    }

    protected boolean isHoverable(IAction action) {
        return action != null && action.getHoverImageDescriptor() != null;
    }

    private void updateImage(ImageHyperlink imageHyperLink, IAction action) {
        if (action.isEnabled()) {
            if (this.isCheckable(action) || this.isRadioable(action)) {
                if (action.isChecked()) {
                    this.setImage(imageHyperLink, action.getImageDescriptor());
                } else {
                    this.setImage(imageHyperLink, action.getDisabledImageDescriptor());
                }
            } else {
                this.setImage(imageHyperLink, action.getImageDescriptor());
            }
        } else {
            this.setImage(imageHyperLink, action.getDisabledImageDescriptor());
        }
    }

    private void disposeToolbarItems() {
        if (!this.getToolBar().isDisposed()) {
            Control[] controls;
            Control[] controlArray = controls = this.getToolBar().getChildren();
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setData(null);
                control.dispose();
                ++n2;
            }
        }
    }

    private void createWidget(ToolbarItem item, Composite parent) {
        ImprovedImageHyperlink imageHyperLink = new ImprovedImageHyperlink(parent, 0x1000000);
        IAction action = item.getAction();
        imageHyperLink.setToolTipText(action.getToolTipText());
        this.updateText(imageHyperLink, action);
        imageHyperLink.setBackgroundImage(this.getParent().getBackgroundImage());
        imageHyperLink.addHyperlinkListener(new HyperLinkListener());
        imageHyperLink.setData("name", action.getId());
        imageHyperLink.setData(item);
        imageHyperLink.addTraverseListener(new SimpleTraverseListener(true));
        this.updateImage(imageHyperLink, action);
    }

    private void updateText(ImageHyperlink imageHyperLink, IAction action) {
        IPreferenceStore corePreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        boolean buttonsAsText = corePreferenceStore.getBoolean("accessibility.buttonsAsText");
        imageHyperLink.setText(buttonsAsText ? action.getText() : null);
        imageHyperLink.getParent().getParent().layout(true);
    }

    public class HyperLinkListener
    implements IHyperlinkListener {
        public void linkActivated(HyperlinkEvent e) {
            ToolbarItem activatedItem = MCToolBarManager.this.getToolbarItem(e);
            if (activatedItem != null) {
                IAction activatedAction = activatedItem.getAction();
                if (MCToolBarManager.this.isRadioable(activatedAction)) {
                    Control[] children = MCToolBarManager.this.getToolBar().getChildren();
                    int n = 0;
                    Iterator<ToolbarItem> iterator = MCToolBarManager.this.m_list.iterator();
                    while (iterator.hasNext()) {
                        ToolbarItem element;
                        ToolbarItem item = element = iterator.next();
                        ImageHyperlink imageHyperLink = (ImageHyperlink)children[n++];
                        IAction action = item.getAction();
                        if (!MCToolBarManager.this.isRadioable(action) || action == activatedItem.getAction()) continue;
                        action.setChecked(false);
                        MCToolBarManager.this.updateImage(imageHyperLink, action);
                    }
                    activatedAction.setChecked(true);
                    MCToolBarManager.this.updateImage((ImageHyperlink)e.widget, activatedAction);
                }
                if (MCToolBarManager.this.isCheckable(activatedAction)) {
                    activatedAction.setChecked(!activatedAction.isChecked());
                    MCToolBarManager.this.updateImage((ImageHyperlink)e.widget, activatedAction);
                }
                if (activatedAction.isEnabled()) {
                    activatedAction.run();
                }
            }
        }

        public void linkEntered(HyperlinkEvent e) {
            ToolbarItem item = MCToolBarManager.this.getToolbarItem(e);
            if (item != null) {
                MCToolBarManager.this.setImage((ImageHyperlink)e.widget, item.getAction().getHoverImageDescriptor());
            }
        }

        public void linkExited(HyperlinkEvent e) {
            ToolbarItem item = MCToolBarManager.this.getToolbarItem(e);
            if (item != null) {
                MCToolBarManager.this.updateImage((ImageHyperlink)e.widget, item.getAction());
            }
        }
    }

    public static class ImprovedImageHyperlink
    extends ImageHyperlink {
        public ImprovedImageHyperlink(Composite parent, int style) {
            super(parent, style);
        }

        public String getText() {
            String text = super.getText();
            return text == null || text.length() == 0 ? null : text;
        }
    }

    private static class ToolbarItem
    implements Comparable<ToolbarItem> {
        private final int m_alignment;
        private final IAction m_action;

        public ToolbarItem(IAction action, int alignMent) {
            this.m_alignment = alignMent;
            this.m_action = action;
        }

        public IAction getAction() {
            return this.m_action;
        }

        public int getAlignment() {
            return this.m_alignment;
        }

        @Override
        public int compareTo(ToolbarItem t) {
            return this.getAlignment() - t.getAlignment();
        }

        public int hashCode() {
            return this.m_action.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof ToolbarItem && ((ToolbarItem)o).getAction() == this.m_action;
        }
    }
}

