/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXServiceURL;
import org.openjdk.jmc.common.jvm.JVMDescriptor;
import org.openjdk.jmc.common.version.JavaVMVersionToolkit;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.RJMXCorePlugin;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.HotspotManagementToolkit;

public final class ConnectionToolkit {
    public static final int VALUE_DEFAULT_REMOTE_PORT_JMX = 7091;
    public static final ObjectName RUNTIME_BEAN_NAME = ConnectionToolkit.createObjectName("java.lang:type=Runtime");
    public static final ObjectName MEMORY_BEAN_NAME = ConnectionToolkit.createObjectName("java.lang:type=Memory");
    public static final ObjectName THREAD_BEAN_NAME = ConnectionToolkit.createObjectName("java.lang:type=Threading");
    public static final ObjectName OPERATING_SYSTEM_BEAN_NAME = ConnectionToolkit.createObjectName("java.lang:type=OperatingSystem");
    private static final String JFR_MBEAN_OBJECT_NAME = "jdk.management.jfr:type=FlightRecorder";

    private ConnectionToolkit() {
        throw new IllegalArgumentException("Don't instantiate this toolkit");
    }

    public static ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            assert (false);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static MemoryMXBean getMemoryBean(MBeanServerConnection server) throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=Memory", MemoryMXBean.class);
    }

    public static RuntimeMXBean getRuntimeBean(MBeanServerConnection server) throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=Runtime", RuntimeMXBean.class);
    }

    public static ThreadMXBean getThreadBean(MBeanServerConnection server) throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=Threading", ThreadMXBean.class);
    }

    public static OperatingSystemMXBean getOperatingSystemBean(MBeanServerConnection server) throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
    }

    public static Object invokeOperation(MBeanServerConnection server, ObjectName on, String operation, Object ... parameters) throws JMException, IOException {
        return server.invoke(on, operation, parameters, ConnectionToolkit.extractSignature(parameters));
    }

    private static String[] extractSignature(Object[] param) {
        String[] sig = new String[param.length];
        for (int i = 0; i < sig.length; ++i) {
            if (param[i].getClass() == Boolean.class) {
                sig[i] = Boolean.TYPE.getName();
                continue;
            }
            if (Number.class.isAssignableFrom(param[i].getClass())) {
                try {
                    sig[i] = ((Class)param[i].getClass().getField("TYPE").get(param[i])).getName();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new UndeclaredThrowableException(e);
                }
                catch (SecurityException e) {
                    throw new UndeclaredThrowableException(e);
                }
                catch (IllegalAccessException e) {
                    throw new UndeclaredThrowableException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
            sig[i] = CompositeData.class.isAssignableFrom(param[i].getClass()) ? CompositeData.class.getName() : (TabularData.class.isAssignableFrom(param[i].getClass()) ? TabularData.class.getName() : (List.class.isAssignableFrom(param[i].getClass()) ? List.class.getName() : param[i].getClass().getName()));
        }
        return sig;
    }

    public static String getHostName(JMXServiceURL url) {
        if (url.getHost() == null || "".equals(url.getHost().trim())) {
            return ConnectionToolkit.deriveHost(url);
        }
        return url.getHost();
    }

    public static int getPort(JMXServiceURL url) {
        if (url.getPort() <= 0) {
            return ConnectionToolkit.derivePort(url);
        }
        return url.getPort();
    }

    private static String deriveHost(JMXServiceURL url) {
        StringTokenizer st = new StringTokenizer(url.getURLPath(), ":/");
        if (st.countTokens() == 5) {
            for (int i = 0; i < 2; ++i) {
                st.nextToken();
            }
            String host = st.nextToken();
            return host;
        }
        return "unknown";
    }

    private static int derivePort(JMXServiceURL url) {
        StringTokenizer st = new StringTokenizer(url.getURLPath(), ":/");
        if (st.countTokens() == 5) {
            for (int i = 0; i < 3; ++i) {
                st.nextToken();
            }
            String port = st.nextToken();
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return 0;
    }

    public static JMXServiceURL createServiceURL(String host, int port) throws MalformedURLException {
        int actualPort = port != -1 ? port : 7091;
        return new JMXServiceURL("rmi", "", 0, "/jndi/rmi://" + host + ":" + actualPort + "/jmxrmi");
    }

    public static int getDefaultPort() {
        return 7091;
    }

    public static boolean isJRockit(IConnectionHandle connectionHandle) {
        String vmName = ConnectionToolkit.getVMName(connectionHandle);
        return JavaVMVersionToolkit.isJRockitJVMName((String)vmName);
    }

    public static boolean isHotSpot(IConnectionHandle connectionHandle) {
        String vmName = ConnectionToolkit.getVMName(connectionHandle);
        return vmName != null && JavaVMVersionToolkit.isHotspotJVMName((String)vmName);
    }

    public static boolean isSubstrateVM(IConnectionHandle connectionHandle) {
        String vmName = ConnectionToolkit.getVMName(connectionHandle);
        return vmName != null && JavaVMVersionToolkit.isSubstrateVMName((String)vmName);
    }

    public static boolean isOracle(IConnectionHandle handle) {
        MBeanServerConnection connection;
        JVMDescriptor descriptor = handle.getServerDescriptor().getJvmInfo();
        String name = null;
        if (descriptor != null) {
            name = descriptor.getJvmName();
        } else if (handle.isConnected() && (connection = handle.getServiceOrNull(MBeanServerConnection.class)) != null) {
            try {
                name = ConnectionToolkit.getRuntimeBean(connection).getVmName();
            }
            catch (IOException e) {
                RJMXCorePlugin.getDefault().getLogger().log(Level.WARNING, "Could not check if Oracle JVM", e);
            }
        }
        return name != null && name.contains("Java HotSpot");
    }

    public static boolean isZulu(IConnectionHandle connectionHandle) {
        String vmName = ConnectionToolkit.getVMName(connectionHandle);
        String vmVendor = ConnectionToolkit.getVmVendor(connectionHandle);
        return vmName != null && JavaVMVersionToolkit.isHotspotJVMName((String)vmName) && vmVendor != null && vmVendor.startsWith("Azul");
    }

    public static boolean isZing(IConnectionHandle connectionHandle) {
        String vmName = ConnectionToolkit.getVMName(connectionHandle);
        String vmVendor = ConnectionToolkit.getVmVendor(connectionHandle);
        return vmName != null && JavaVMVersionToolkit.isZingJVMName((String)vmName) && vmVendor != null && vmVendor.startsWith("Azul");
    }

    public static boolean isJavaVersionAboveOrEqual(IConnectionHandle connectionHandle, JavaVersion minVersion) {
        JavaVersion version = ConnectionToolkit.getJavaVersion(connectionHandle);
        return version != null ? version.isGreaterOrEqualThan(minVersion) : true;
    }

    private static String getVMName(IConnectionHandle connectionHandle) {
        MBeanServerConnection connection = connectionHandle.getServiceOrDummy(MBeanServerConnection.class);
        try {
            return ConnectionToolkit.getRuntimeBean(connection).getVmName();
        }
        catch (Exception e) {
            RJMXCorePlugin.getDefault().getLogger().log(Level.INFO, "Could not check the JVM name!", e);
            return null;
        }
    }

    private static String getVmVendor(IConnectionHandle connectionHandle) {
        MBeanServerConnection connection = connectionHandle.getServiceOrDummy(MBeanServerConnection.class);
        try {
            return ConnectionToolkit.getRuntimeBean(connection).getVmVendor();
        }
        catch (Exception e) {
            RJMXCorePlugin.getDefault().getLogger().log(Level.INFO, "Could not check the JVM vendor name!", e);
            return null;
        }
    }

    private static JavaVersion getJavaVersion(IConnectionHandle connectionHandle) {
        try {
            MBeanServerConnection server = connectionHandle.getServiceOrThrow(MBeanServerConnection.class);
            Map<String, String> serverProps = ConnectionToolkit.getRuntimeBean(server).getSystemProperties();
            String javaVersion = serverProps.get("java.version");
            if (javaVersion != null) {
                return new JavaVersion(javaVersion);
            }
            RJMXCorePlugin.getDefault().getLogger().log(Level.WARNING, "System Properties from " + connectionHandle.getDescription() + " contained no java.version property!");
        }
        catch (Exception e) {
            RJMXCorePlugin.getDefault().getLogger().log(Level.WARNING, "Could not check the java.version from System Properties!", e);
        }
        return null;
    }

    public static boolean hasFlightRecorder(IConnectionHandle connection) {
        if (ConnectionToolkit.isOracle(connection)) {
            return true;
        }
        MBeanServerConnection server = connection.getServiceOrNull(MBeanServerConnection.class);
        try {
            if (ConnectionToolkit.isSubstrateVM(connection)) {
                return server.isRegistered(new ObjectName(JFR_MBEAN_OBJECT_NAME));
            }
            HotspotManagementToolkit.getVMOption(server, "FlightRecorder");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFlightRecorderDisabled(IConnectionHandle connection, boolean explicitFlag) {
        try {
            boolean disabled;
            MBeanServerConnection server = connection.getServiceOrThrow(MBeanServerConnection.class);
            boolean bl = disabled = !Boolean.parseBoolean(HotspotManagementToolkit.getVMOption(server, "FlightRecorder").toString());
            if (explicitFlag) {
                return disabled && HotspotManagementToolkit.isVMOptionExplicit(server, "FlightRecorder");
            }
            return disabled;
        }
        catch (Exception e) {
            return false;
        }
    }
}

