/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.services.jfr.internal;

import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.openjdk.jmc.flightrecorder.configuration.FlightRecorderException;
import org.openjdk.jmc.flightrecorder.configuration.IRecordingDescriptor;
import org.openjdk.jmc.rjmx.common.ConnectionToolkit;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.HotspotManagementToolkit;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.IFlightRecorderCommunicationHelper;

final class FlightRecorderCommunicationHelperV1
implements IFlightRecorderCommunicationHelper {
    private final MBeanServerConnection server;
    private static final ObjectName JFR_MBEAN_OBJECT_NAME = ConnectionToolkit.createObjectName("com.oracle.jrockit:type=FlightRecorder");

    public FlightRecorderCommunicationHelperV1(MBeanServerConnection server) {
        this.server = server;
    }

    @Override
    public Object getAttribute(String attribute) throws FlightRecorderException {
        try {
            try {
                return this.getJfrAttribute(attribute);
            }
            catch (InstanceNotFoundException e) {
                HotspotManagementToolkit.registerMBeans(this.server);
                return this.getJfrAttribute(attribute);
            }
        }
        catch (IOException e) {
            throw new FlightRecorderException("Could not retrieve the attribute " + attribute + "!", (Throwable)e);
        }
        catch (JMException e) {
            throw new FlightRecorderException("Could not retrieve the attribute " + attribute + "!", (Throwable)e);
        }
    }

    private Object getJfrAttribute(String attribute) throws JMException, IOException {
        return this.server.getAttribute(JFR_MBEAN_OBJECT_NAME, attribute);
    }

    @Override
    public Object invokeOperation(String name, Object ... parameters) throws IOException, FlightRecorderException {
        try {
            try {
                return this.invokeJfrOperation(name, parameters);
            }
            catch (InstanceNotFoundException e) {
                HotspotManagementToolkit.registerMBeans(this.server);
                return this.invokeJfrOperation(name, parameters);
            }
        }
        catch (JMException e) {
            IOException throwMe = new IOException(e.getMessage());
            throwMe.initCause(e);
            throw throwMe;
        }
    }

    private Object invokeJfrOperation(String operation, Object ... parameters) throws JMException, IOException {
        return ConnectionToolkit.invokeOperation(this.server, JFR_MBEAN_OBJECT_NAME, operation, parameters);
    }

    @Override
    public void closeRecording(IRecordingDescriptor descriptor) throws FlightRecorderException {
        try {
            this.invokeOperation("close", descriptor.getObjectName());
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not close the recording!", (Throwable)e);
        }
    }
}

