/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.services.jfr.internal;

import java.io.IOException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.openjdk.jmc.rjmx.common.ConnectionToolkit;

public final class HotspotManagementToolkit {
    private static final String MC_BEAN_CLASS = "com.sun.management.MissionControl";
    private static final ObjectName MC_BEAN_NAME = ConnectionToolkit.createObjectName("com.sun.management:type=MissionControl");
    private static final ObjectName HS_DIAGNOSTICS_BEAN_NAME = ConnectionToolkit.createObjectName("com.sun.management:type=HotSpotDiagnostic");
    private static final String OPERATION_GET_VM_OPTION = "getVMOption";
    private static final String OPERATION_SET_VM_OPTION = "setVMOption";
    private static final String OPERATION_REGISTER_MBEANS = "registerMBeans";
    private static final String PARAMETER_STRING = String.class.getName();
    private static final String EXPLICIT_FLAG = "VM_CREATION";

    public static void setVMOption(MBeanServerConnection server, String flag, String value) throws Exception {
        server.invoke(HS_DIAGNOSTICS_BEAN_NAME, OPERATION_SET_VM_OPTION, new Object[]{flag, value}, new String[]{PARAMETER_STRING, PARAMETER_STRING});
    }

    public static Object getVMOption(MBeanServerConnection server, String flag) throws Exception {
        CompositeData data = (CompositeData)server.invoke(HS_DIAGNOSTICS_BEAN_NAME, OPERATION_GET_VM_OPTION, new Object[]{flag}, new String[]{PARAMETER_STRING});
        return data.get("value");
    }

    public static boolean isVMOptionExplicit(MBeanServerConnection server, String flag) throws Exception {
        CompositeData data = (CompositeData)server.invoke(HS_DIAGNOSTICS_BEAN_NAME, OPERATION_GET_VM_OPTION, new Object[]{flag}, new String[]{PARAMETER_STRING});
        return data.get("origin").equals(EXPLICIT_FLAG);
    }

    public static void registerMBeans(MBeanServerConnection server) throws JMException, IOException {
        block3: {
            try {
                server.createMBean(MC_BEAN_CLASS, MC_BEAN_NAME);
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            }
            catch (MBeanException mbe) {
                if (mbe.getTargetException() instanceof InstanceAlreadyExistsException) break block3;
                throw mbe;
            }
        }
        server.invoke(MC_BEAN_NAME, OPERATION_REGISTER_MBEANS, new Object[0], new String[0]);
    }
}

