/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.actions;

import java.io.Closeable;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.flightrecorder.configuration.IFlightRecorderService;
import org.openjdk.jmc.flightrecorder.configuration.IRecordingDescriptor;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.RecordingProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.ui.misc.AbstractWarningAction;
import org.openjdk.jmc.ui.misc.DialogToolkit;

public class CloseRecordingAction
extends AbstractWarningAction {
    private final RecordingProvider recording;

    public CloseRecordingAction(RecordingProvider recording) {
        super(Messages.ACTION_CLOSE_RECORDING_LABEL, Messages.ACTION_CLOSE_RECORDING_TOOLTIP, ControlPanel.getDefault().getMCImageDescriptor("jfr_close.png"));
        this.recording = recording;
    }

    private boolean okToCloseDefaultRecording() {
        return DialogToolkit.openQuestionOnUiThread((String)Messages.CLOSE_RECORDING_TITLE, (String)NLS.bind((String)Messages.CLOSE_RECORDING_MSG, (Object)this.recording.getRecordingDescriptor().getName()));
    }

    public void doExecute() throws Exception {
        IRecordingDescriptor recordingDescriptor = this.recording.getRecordingDescriptor();
        if (recordingDescriptor.getId() != 0L || this.okToCloseDefaultRecording()) {
            IConnectionHandle connection = null;
            try {
                this.recording.setClosed();
                connection = this.recording.getServerHandle().connect(Messages.ACTION_CLOSE_RECORDING_LABEL);
                ((IFlightRecorderService)connection.getServiceOrThrow(IFlightRecorderService.class)).close(recordingDescriptor);
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    IOToolkit.closeSilently(connection);
                }
                throw throwable;
            }
            if (connection != null) {
                IOToolkit.closeSilently((Closeable)connection);
            }
        }
    }
}

